/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.KDException;
import kd.bos.fileservice.ResolveUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class NettyFileClient {
    private static Log log = LogFactory.getLog(NettyFileClient.class);
    private String host;
    private int port;
    private ChannelFuture future;
    private EventLoopGroup group;

    public NettyFileClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public NettyFileClient(String url) {
        int index = url.indexOf(58);
        if (index <= 0) {
            throw new IllegalArgumentException("url format should be [ip:port], url :'" + url + "'");
        }
        this.host = url.substring(0, index);
        this.port = Integer.parseInt(url.substring(index + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(final FileSendHandler fileHander) throws InterruptedException {
        int connectTimeout = Integer.parseInt(System.getProperty("fileserver.client.connectTimeout", "5000"));
        int readTimeout = Integer.parseInt(System.getProperty("fileserver.client.readTimeout", "60000"));
        this.group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)262144)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).option(ChannelOption.SO_TIMEOUT, (Object)readTimeout)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{fileHander});
                }
            });
            this.future = b.connect(this.host, this.port).sync();
            this.future.channel().closeFuture().sync();
        }
        finally {
            if (!this.group.isTerminated()) {
                this.group.shutdownGracefully();
            }
        }
    }

    public void shutdown() {
        if (this.group != null && !this.group.isTerminated()) {
            this.group.shutdownGracefully();
        }
        this.group = null;
        if (this.future != null && !this.future.channel().isActive()) {
            this.future.channel().flush().close();
        }
        this.future = null;
    }

    public static class FileSendHandler
    extends ChannelInboundHandlerAdapter {
        private InputStream in;
        private Map<String, String> argMap;
        private Map<String, String> value;
        private CountDownLatch latch = new CountDownLatch(1);

        public FileSendHandler(InputStream in, Map<String, String> argMap) {
            if (in == null) {
                throw new NullPointerException();
            }
            this.in = in;
            this.argMap = argMap;
        }

        public void channelActive(ChannelHandlerContext ctx) throws IOException {
            int bodySize = this.in.available();
            String args = ResolveUtils.resolveJson(this.argMap);
            byte[] headers = args.getBytes(Charset.forName("utf-8"));
            int totalLen = bodySize + headers.length;
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])buffer);
            buf.clear();
            buf.writeInt(totalLen).writeInt(headers.length).writeBytes(headers);
            ctx.writeAndFlush((Object)buf);
            int totalSend = 0;
            int writeBytes = 0;
            if (bodySize > 0) {
                if (bodySize > bufferSize) {
                    int page = bodySize / bufferSize + 1;
                    int position = 0;
                    int len = bufferSize;
                    for (int i = 0; i < page; ++i) {
                        buf = Unpooled.wrappedBuffer((byte[])buffer);
                        buf.clear();
                        if (i != page - 1) {
                            writeBytes = buf.writeBytes(this.in, len);
                        } else {
                            len = bodySize - position;
                            writeBytes = buf.writeBytes(this.in, len);
                        }
                        position += len;
                        totalSend += writeBytes;
                        ctx.writeAndFlush((Object)buf);
                    }
                } else {
                    buf = Unpooled.wrappedBuffer((byte[])buffer);
                    buf.clear();
                    writeBytes = buf.writeBytes(this.in, bodySize);
                    totalSend += writeBytes;
                    ctx.writeAndFlush((Object)buf);
                }
            }
            StringBuilder msg = new StringBuilder();
            msg.append(" totalSend:").append(totalSend).append(", bodySize:").append(bodySize).append(", headSize:").append(totalLen - bodySize);
            msg.insert(0, "file upload:fileName:" + this.argMap.get("fileName"));
            log.info(msg.toString());
        }

        void fetctBytes(InputStream in, byte[] bytes, int offset, int len) throws IOException {
            in.read(bytes, offset, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws IOException {
            try {
                ByteBuf buf = (ByteBuf)msg;
                byte[] buffer = new byte[buf.readableBytes()];
                buf.readBytes(buffer);
                String body = new String(buffer, "UTF-8");
                Map<String, String> result = ResolveUtils.resolveJson(body);
                this.value = result;
                ctx.close();
            }
            finally {
                this.latch.countDown();
                ReferenceCountUtil.release((Object)msg);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws KDException {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("status", "error");
            resultMap.put("description", this.getThrowableStackTraceMessage(cause));
            this.value = resultMap;
            ctx.close();
        }

        /*
         * Exception decompiling
         */
        private String getThrowableStackTraceMessage(Throwable th) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Map<String, String> getValue() {
            return this.getValue(-1L, null);
        }

        public Map<String, String> getValue(long timeout, TimeUnit unit) {
            if (this.value != null) {
                return this.value;
            }
            try {
                if (timeout <= 0L) {
                    this.latch.await();
                } else if (this.latch.await(timeout, unit)) {
                    return this.value;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.value;
        }
    }
}

