/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TimeCachedMap<T> {
    private Map<Object, VItem> table = new ConcurrentHashMap<Object, VItem>();
    private long expirationMillis;

    public TimeCachedMap(int expirationSecs) {
        this.expirationMillis = (long)expirationSecs * 1000L;
    }

    public T get(Object key) {
        VItem v = this.table.get(key);
        if (v != null) {
            if (System.currentTimeMillis() - v.stime > this.expirationMillis) {
                this.table.remove(key);
                return null;
            }
            return (T)v.o;
        }
        return null;
    }

    public void put(Object key, T value) {
        this.table.put(key, new VItem(value));
    }

    public Object remove(Object key) {
        return this.table.remove(key);
    }

    public void cleanup() {
        this.table.clear();
    }

    private class VItem {
        private long stime;
        private T o;

        VItem(T o) {
            this.o = o;
            this.stime = System.currentTimeMillis();
        }
    }
}

