/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import com.lowagie.text.DocumentException;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import kd.bos.fileservice.config.FileServiceConfig;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.enums.WatermarkType;
import kd.bos.fileservice.excelpreview.ExcelPreviewFactory;
import kd.bos.fileservice.utils.FileTimeoutUtil;
import kd.bos.fileservice.utils.WatermarkUtil;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.fileservice.watermark.WatermarkHandlerFactory;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FileUtils;

public class WatermarkService {
    private static Log logger = LogFactory.getLog(WatermarkService.class);
    private static final String EXCELPREVIEWROOTPATH = "/excelpreview/";
    private static final String IMGEXT = "bmp,gif,jpg,png,jpeg,dib,emf,jfif,jpe,rle,wmf,tif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,webp,avif";

    public void addWatermarkExcel(Map<String, Object> result, InputStream imgWatermark, String textWatermark, int watermarkType) throws IOException {
        String url;
        Map mapResult = (Map)result.get(PreviewParams.RESULT.getEnumName());
        if (PreviewParams.SUCCESS.getEnumName().equals(mapResult.get(PreviewParams.STATUS.getEnumName())) && StringUtils.isNotEmpty((String)(url = (String)mapResult.get("url"))) && url.contains(EXCELPREVIEWROOTPATH)) {
            String[] tempStrArr = url.split(EXCELPREVIEWROOTPATH);
            String id = tempStrArr[1].substring(0, tempStrArr[1].indexOf(47));
            InputStream icon = this.drawImage(imgWatermark, textWatermark, watermarkType);
            if (icon != null) {
                ExcelPreviewFactory.getExcelPreview().addWartermarkData(id, icon);
            } else {
                throw new RuntimeException("add watermark drawImage fail");
            }
        }
    }

    public InputStream addWatermarkPdf(InputStream src, InputStream imgWatermark, String textWatermark, int watermarkType) throws IOException, DocumentException {
        ByteArrayInputStream watered = null;
        if (!(src == null || imgWatermark == null && StringUtils.isEmpty((String)textWatermark))) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            if (WatermarkType.TEXT.ordinal() == watermarkType) {
                WatermarkUtil.pdfWatermarkTxt(outputStream, src, textWatermark);
            } else if (WatermarkType.IMG.ordinal() == watermarkType) {
                WatermarkUtil.pdfWatermarkImg(outputStream, src, imgWatermark, 10);
            } else if (WatermarkType.UP_IMG_UNDER_TEXT.ordinal() == watermarkType) {
                WatermarkUtil.pdfWatermarkUpImgUnderTxt(outputStream, src, imgWatermark, textWatermark);
            } else if (WatermarkType.LEFT_IMG_RIGHT_TEXT.ordinal() == watermarkType) {
                WatermarkUtil.pdfWatermarkLeftImgRightTxt(outputStream, src, imgWatermark, textWatermark);
            }
            if (outputStream.size() != 0) {
                watered = new ByteArrayInputStream(outputStream.toByteArray());
            }
        }
        return watered;
    }

    public InputStream addWatermarkTxt(InputStream src, String charset, InputStream imgWatermark, String textWatermark, int watermarkType) throws IOException, DocumentException {
        InputStream pdf;
        InputStream watered = null;
        if (src != null && (pdf = WatermarkUtil.text2Pdf(src, charset)) != null) {
            watered = StringUtils.isNotEmpty((String)textWatermark) ? this.addWatermarkPdf(pdf, imgWatermark, textWatermark, watermarkType) : pdf;
        }
        return watered;
    }

    public InputStream addWatermarkImg(InputStream src, InputStream imgWatermark, String textWatermark, int watermarkType, String position, Color markContentColor) throws IOException {
        ByteArrayInputStream watered = null;
        if (!(src == null || imgWatermark == null && StringUtils.isEmpty((String)textWatermark))) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            if (WatermarkType.TEXT.ordinal() == watermarkType) {
                WatermarkUtil.imgWatermarkTxt(outputStream, src, markContentColor, textWatermark, position);
            } else if (WatermarkType.IMG.ordinal() == watermarkType) {
                WatermarkUtil.imgWatermarkImg(outputStream, src, imgWatermark, position);
            } else if (WatermarkType.UP_IMG_UNDER_TEXT.ordinal() == watermarkType) {
                WatermarkUtil.imgWatermarkUpImgUnderTxt(outputStream, src, imgWatermark, markContentColor, textWatermark, position);
            } else if (WatermarkType.LEFT_IMG_RIGHT_TEXT.ordinal() == watermarkType) {
                WatermarkUtil.imgWatermarkLeftImgRightTxt(outputStream, src, imgWatermark, markContentColor, textWatermark, position);
            }
            if (outputStream.size() != 0) {
                watered = new ByteArrayInputStream(outputStream.toByteArray());
            }
        }
        return watered;
    }

    public InputStream drawImage(InputStream imgWatermark, String textWatermark, int watermarkType) throws IOException {
        ByteArrayInputStream in = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (WatermarkType.TEXT.ordinal() == watermarkType) {
            WatermarkUtil.drawImageTxt(outputStream, textWatermark);
        } else if (WatermarkType.IMG.ordinal() == watermarkType) {
            WatermarkUtil.drawImageImg(outputStream, imgWatermark);
        } else if (WatermarkType.UP_IMG_UNDER_TEXT.ordinal() == watermarkType) {
            WatermarkUtil.drawImageUpImgUnderTxt(outputStream, imgWatermark, textWatermark);
        } else if (WatermarkType.LEFT_IMG_RIGHT_TEXT.ordinal() == watermarkType) {
            WatermarkUtil.drawImageLeftImgRightTxt(outputStream, imgWatermark, textWatermark);
        }
        if (outputStream.size() != 0) {
            in = new ByteArrayInputStream(outputStream.toByteArray());
        }
        return in;
    }

    public boolean checkValid(InputStream imgWatermark, String textWatermark, int watermarkType) {
        if (watermarkType == WatermarkType.NO_WATER.ordinal()) {
            return false;
        }
        if ((textWatermark == null || textWatermark.length() == 0) && WatermarkType.IMG.ordinal() != watermarkType) {
            logger.debug("watermarkType=" + watermarkType + ",but text is empty");
            return false;
        }
        if (imgWatermark == null && WatermarkType.TEXT.ordinal() != watermarkType) {
            logger.debug("watermarkType=" + watermarkType + ",but img is empty");
            return false;
        }
        return true;
    }

    public void addWaterPreview(Map<String, Object> result, InputStream imgWatermark, String textWatermark, int watermarkType, String fileName, String position, Color textColor) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        String status = (String)result.get(PreviewParams.STATUS.getEnumName());
        if (!PreviewParams.ERROR.getEnumName().equals(status) && this.checkValid(imgWatermark, textWatermark, watermarkType)) {
            logger.debug("addWaterPreview param: imgWatermark [{}],textWatermark [{}],watermarkType [{}]", new Object[]{imgWatermark != null ? 1 : 0, textWatermark, watermarkType});
            if (PreviewParams.XLSX_SUCCESS.getEnumName().equals(status)) {
                try {
                    this.addWatermarkExcel(result, imgWatermark, textWatermark, watermarkType);
                }
                catch (Exception e) {
                    logger.error("excel add water fail", (Throwable)e);
                }
            } else {
                Object previewRs = result.get(PreviewParams.RESULT.getEnumName());
                if (previewRs instanceof InputStream) {
                    InputStream in = (InputStream)previewRs;
                    if (!in.markSupported()) {
                        in = new BufferedInputStream(in);
                    }
                    in.mark(Integer.MAX_VALUE);
                    try {
                        InputStream watered = null;
                        if ("txt".equalsIgnoreCase(ext)) {
                            String charset = (String)result.get(PreviewParams.CHARSET.getEnumName());
                            watered = this.addWatermarkTxt(in, charset, imgWatermark, textWatermark, watermarkType);
                        } else if ("docx".equalsIgnoreCase(ext) || "doc".equalsIgnoreCase(ext) || "pptx".equalsIgnoreCase(ext) || "ppt".equalsIgnoreCase(ext) || "pdf".equalsIgnoreCase(ext)) {
                            watered = this.addWatermarkPdf(in, imgWatermark, textWatermark, watermarkType);
                        } else if (IMGEXT.contains(ext.toLowerCase())) {
                            watered = this.addWatermarkImg(in, imgWatermark, textWatermark, watermarkType, position, textColor);
                        }
                        if (watered != null) {
                            result.put(PreviewParams.RESULT.getEnumName(), watered);
                        } else {
                            in.reset();
                        }
                    }
                    catch (Exception e) {
                        try {
                            in.reset();
                        }
                        catch (IOException e1) {
                            logger.warn("", (Throwable)e);
                        }
                        logger.error("preview add water fail", (Throwable)e);
                    }
                }
            }
        }
    }

    public void addWatermark(Map<String, Object> result, String fileName, WatermarkParameter watermarkParameter) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        String status = (String)result.get(PreviewParams.STATUS.getEnumName());
        boolean checkResult = watermarkParameter.valid();
        logger.debug("addWatermark checkResult[{}], param[{}] ", (Object)checkResult, (Object)watermarkParameter.toString());
        if (!PreviewParams.ERROR.getEnumName().equals(status) && checkResult) {
            if (PreviewParams.XLSX_SUCCESS.getEnumName().equals(status)) {
                try {
                    this.addWatermark4Excel(result, watermarkParameter);
                }
                catch (Exception e) {
                    logger.error("excel watermarking failed", (Throwable)e);
                }
            } else {
                Object previewRs = result.get(PreviewParams.RESULT.getEnumName());
                if (previewRs instanceof InputStream) {
                    InputStream in = (InputStream)previewRs;
                    String tempFilePath = kd.bos.util.FileUtils.checkFileUrl((String)(IWatermarkHandler.TEMP_DIR + "/tempFile" + UUID.randomUUID().toString().replace("-", "")));
                    try {
                        InputStream watermarked;
                        IWatermarkHandler handler;
                        File tempFile = new File(tempFilePath);
                        FileUtils.copyToFile((InputStream)in, (File)tempFile);
                        FileTimeoutUtil.removeFile(tempFilePath, null, 120000L);
                        String pdfImpl = watermarkParameter.getPdfImpl();
                        if (FileServiceConfig.WATERMARK_OPT_PDFBOX_ENABLE.getBoolean()) {
                            pdfImpl = "PDFBox";
                        }
                        if ((handler = WatermarkHandlerFactory.getHandler(ext, pdfImpl)) == null) {
                            logger.debug("no handler fileName[{}]" + fileName);
                            return;
                        }
                        try (FileInputStream temp = new FileInputStream(tempFilePath);){
                            watermarked = handler.watermark(result, temp, watermarkParameter);
                        }
                        if (watermarked != null) {
                            result.put(PreviewParams.RESULT.getEnumName(), watermarked);
                        } else {
                            result.put(PreviewParams.RESULT.getEnumName(), new FileInputStream(tempFilePath));
                        }
                    }
                    catch (Exception e) {
                        try {
                            result.put(PreviewParams.RESULT.getEnumName(), new FileInputStream(tempFilePath));
                        }
                        catch (IOException e1) {
                            logger.warn("watermarking failed, get inputStream from temp file error", (Throwable)e);
                        }
                        logger.error("watermarking failed", (Throwable)e);
                    }
                }
            }
        }
    }

    private void addWatermark4Excel(Map<String, Object> result, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
        String url;
        Map mapResult = (Map)result.get(PreviewParams.RESULT.getEnumName());
        if (PreviewParams.SUCCESS.getEnumName().equals(mapResult.get(PreviewParams.STATUS.getEnumName())) && StringUtils.isNotEmpty((String)(url = (String)mapResult.get("url"))) && url.contains(EXCELPREVIEWROOTPATH)) {
            String[] tempStrArr = url.split(EXCELPREVIEWROOTPATH);
            String id = tempStrArr[1].substring(0, tempStrArr[1].indexOf(47));
            InputStream icon = WatermarkHandlerFactory.getExcelHandler().watermark(result, null, watermarkParameter);
            if (icon != null) {
                ExcelPreviewFactory.getExcelPreview().addWartermarkData(id, icon);
            } else {
                throw new RuntimeException("add watermark drawImage fail");
            }
        }
    }
}

