/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.lightfilestorage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.filestorage.spi.FileStorageService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class LightFileStorage
implements FileStorageService {
    private FileStorageConfig fileStorageConfig;
    private static String rootPath;
    private static int maxUploadSize;
    private static final String STORAGE_DIR = "filestorage";
    private static Log logger;

    public void setConfig(FileStorageConfig fileStorageConfig) {
        this.fileStorageConfig = fileStorageConfig;
        this.fileStorageConfig.setMaxUploadSize(maxUploadSize);
    }

    public List<String> getForbiddenExtensions() throws Exception {
        return new ArrayList<String>();
    }

    public String getTicket() throws Exception {
        return null;
    }

    public String upload(InputStream inputStream, String path, String fileName, boolean isCreateNewFileWhenExists, Map<String, String> headers) throws Exception {
        String filePath = this.createFilePath(path, fileName);
        try (FileOutputStream fos = new FileOutputStream(filePath);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int len;
            byte[] writeByte = new byte[8192];
            while ((len = inputStream.read(writeByte)) != -1) {
                bos.write(writeByte, 0, len);
            }
            bos.flush();
        }
        return filePath;
    }

    public InputStream getInputStream(String path, String userAgent) throws Exception {
        path = this.formatPath(path);
        FileInputStream fis = new FileInputStream(path);
        return fis;
    }

    public void download(String path, OutputStream out, String userAgent) throws Exception {
        try (FileInputStream fis = new FileInputStream(path);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            int len;
            byte[] writeByte = new byte[8192];
            while ((len = bis.read(writeByte)) != -1) {
                out.write(writeByte, 0, len);
            }
            out.flush();
        }
    }

    public void delete(String path) throws Exception {
        File file = new File(path);
        if (file.delete()) {
            LightFileStorage.deleteEmptyDir(new File(rootPath));
        } else {
            logger.error("Delete file fail :" + path);
        }
    }

    public boolean exists(String path) throws Exception {
        File file = new File(path);
        return file.exists();
    }

    public void close() throws IOException {
    }

    private static void deleteEmptyDir(File dir) {
        if (!dir.exists() || dir.isFile()) {
            return;
        }
        for (File sub : dir.listFiles()) {
            LightFileStorage.deleteEmptyDir(sub);
        }
        if (!dir.delete()) {
            logger.error("delete dir fail");
        }
    }

    private String createFilePath(String targetPath, String fileName) {
        String saveRootPath;
        String filePath = saveRootPath = rootPath;
        if (StringUtils.isNotEmpty((String)targetPath)) {
            if ((targetPath = this.formatPath(targetPath)).startsWith(File.separator)) {
                targetPath = targetPath.substring(1);
            }
            filePath = filePath + File.separator + targetPath;
            int index = targetPath.lastIndexOf(File.separator);
            String saveDir = index > 0 ? targetPath.substring(0, index) : "";
            saveRootPath = saveRootPath + File.separator + saveDir;
        } else {
            filePath = filePath + File.separator + fileName;
        }
        File dir = new File(saveRootPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return filePath;
    }

    private String formatPath(String path) {
        String format = "";
        if ("\\".equals(File.separator)) {
            format = path.replaceAll("/", "\\\\");
        }
        if ("/".equals(File.separator)) {
            format = path.replaceAll("\\\\", "/");
        }
        return format;
    }

    static {
        logger = LogFactory.getLog(LightFileStorage.class);
        String userDir = System.getProperty("user.dir");
        String path = userDir + File.separator + STORAGE_DIR;
        rootPath = FilenameUtils.normalize((String)path);
        maxUploadSize = Integer.parseInt(System.getProperty("attachmentServer.maxFileSize", "52428800"));
    }
}

