/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.manage;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.ResolveUtils;
import kd.bos.fileservice.impl.FileServiceVersion;
import kd.bos.fileservice.impl.HttpFileClient;
import kd.bos.fileservice.manage.DiskUrlInfo;
import kd.bos.fileservice.manage.FileMsgInfo;
import kd.bos.fileservice.manage.FileServerManage;
import kd.bos.fileservice.manage.FileServerMsgInfo;
import kd.bos.fileservice.manage.FileServiceType;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class FileServerManageImpl
implements FileServerManage {
    private static final String COOKIE = "Cookie";
    private static final String ERROR = "error";
    private static final String UTF_8 = "utf-8";
    private static final String STATUS = "status";
    private static final String DESCRIPTION = "description";
    public static final String DATA = "data";
    private static Log logger = LogFactory.getLog(FileServerManageImpl.class);
    private FileServiceType fileServiceType;
    private FileService fileService;

    public FileServerManageImpl(FileServiceType fileServiceType) {
        this.fileServiceType = fileServiceType;
        if (FileServiceType.ATTACHMENT == fileServiceType) {
            this.fileService = FileServiceFactory.getAttachmentFileService();
        } else if (FileServiceType.IMAGE == fileServiceType) {
            this.fileService = FileServiceFactory.getImageFileService();
        } else if (FileServiceType.ERECEIPT == fileServiceType) {
            this.fileService = FileServiceFactory.getEreceiptService();
        } else {
            throw new KDException(BosErrorCode.bOS, new Object[]{"unsupported fileServiceType:" + fileServiceType.toString()});
        }
    }

    @Override
    public FileServerMsgInfo getFileServerMsgInfo() {
        boolean isAvailable = true;
        String availableMsg = Resources.getString((String)"\u6587\u4ef6\u670d\u52a1\u5668\u6b63\u5e38\u8fd0\u884c\u4e2d\uff01", (String)"FileServerManageImpl_3");
        FileServiceVersion fileServiceVersion = FileServiceVersion.VERSION1;
        if (Instance.isLightWeightDeploy()) {
            isAvailable = false;
            availableMsg = Resources.getString((String)"\u8f7b\u91cf\u7ea7\u73af\u5883\u4e0d\u652f\u6301\u9644\u4ef6\u7ba1\u7406\u670d\u52a1\uff01", (String)"FileServerManageImpl_0");
        } else if (!this.isDefaultFileStorage()) {
            isAvailable = false;
            availableMsg = Resources.getString((String)"\u4e8c\u5f00\u81ea\u5b9a\u4e49\u6587\u4ef6\u5b58\u50a8\u4e0d\u652f\u6301\u9644\u4ef6\u7ba1\u7406\u670d\u52a1\uff01", (String)"FileServerManageImpl_1");
        }
        try {
            fileServiceVersion = this.getFileServerVersion();
            if (fileServiceVersion.myCompareTo(FileServiceVersion.VERSION5) < 0) {
                isAvailable = false;
                availableMsg = String.format(Resources.getString((String)"\u670d\u52a1\u7aef\u7248\u672c\u8fc7\u4f4e\uff0c\u8bf7\u5347\u7ea7\u6587\u4ef6\u670d\u52a1\u5668\u5230%s\u7248\u672c\u4ee5\u4e0a\uff01", (String)"FileServerManageImpl_2"), new Object[]{FileServiceVersion.VERSION5});
            }
        }
        catch (Exception e) {
            isAvailable = false;
            availableMsg = e.getMessage();
            logger.error((Throwable)e);
        }
        FileServerMsgInfo fileServerMsgInfo = new FileServerMsgInfo();
        fileServerMsgInfo.setAvailable(isAvailable);
        fileServerMsgInfo.setFileServiceVersion(fileServiceVersion);
        fileServerMsgInfo.setAvailableMsg(availableMsg);
        fileServerMsgInfo.setMaxDirectoryScanDepth(this.getMaxDirectoryScanDepth());
        return fileServerMsgInfo;
    }

    @Override
    public List<DiskUrlInfo> getDiskUrlInfoList(boolean withSpaceMsg) throws IOException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("withSpaceMsg", withSpaceMsg);
        ResponseInfo responseInfo = this.executeHttpGetRequest("/fileServerManage/getDiskUrlInfos.do", paramsMap, HttpFileClient.getReadTimeout());
        String respStr = responseInfo.getResponseStr();
        int statusCode = responseInfo.getStatusCode();
        if (statusCode != 200) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
        }
        String data = this.getDataStr(respStr);
        List<DiskUrlInfo> diskUrlInfoList = new ArrayList<DiskUrlInfo>(1);
        if (StringUtils.isNotEmpty((String)data)) {
            diskUrlInfoList = (List)JSONUtils.cast((String)data, (boolean)true, List.class, (Class[])new Class[]{DiskUrlInfo.class});
        }
        return diskUrlInfoList;
    }

    @Override
    public String getFileMsgTreeJsonData(String diskUrl, int depth) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("diskUrl", diskUrl);
        paramsMap.put("depth", depth);
        ResponseInfo responseInfo = this.executeHttpGetRequest("/fileServerManage/getFileMsgInfoTree.do", paramsMap, 60000);
        String respStr = responseInfo.getResponseStr();
        int statusCode = responseInfo.getStatusCode();
        if (statusCode != 200) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
        }
        return this.getDataStr(respStr);
    }

    @Override
    public FileMsgInfo getFileMsgInfo(String diskUrl, String filePath) throws IOException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("diskUrl", diskUrl);
        paramsMap.put("filePath", filePath);
        ResponseInfo responseInfo = this.executeHttpGetRequest("/fileServerManage/getFileMsgInfo.do", paramsMap, 60000);
        String respStr = responseInfo.getResponseStr();
        int statusCode = responseInfo.getStatusCode();
        if (statusCode != 200) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
        }
        String data = this.getDataStr(respStr);
        FileMsgInfo fileMsgInfo = null;
        if (StringUtils.isNotEmpty((String)data)) {
            fileMsgInfo = (FileMsgInfo)JSONUtils.cast((String)data, (boolean)true, FileMsgInfo.class, (Class[])new Class[0]);
        }
        return fileMsgInfo;
    }

    @Override
    public List<FileMsgInfo> getChildrenFileMsgInfoList(String diskUrl, String filePath) throws IOException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("diskUrl", diskUrl);
        paramsMap.put("filePath", filePath);
        ResponseInfo responseInfo = this.executeHttpGetRequest("/fileServerManage/getChildrenFileMsgInfos.do", paramsMap, 60000);
        String respStr = responseInfo.getResponseStr();
        int statusCode = responseInfo.getStatusCode();
        if (statusCode != 200) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
        }
        String data = this.getDataStr(respStr);
        List<FileMsgInfo> fileMsgInfoList = new ArrayList<FileMsgInfo>(1);
        if (StringUtils.isNotEmpty((String)data)) {
            fileMsgInfoList = (List)JSONUtils.cast((String)data, (boolean)true, List.class, (Class[])new Class[]{FileMsgInfo.class});
        }
        return fileMsgInfoList;
    }

    @Override
    public List<FileMsgInfo> getMatchFileMsgInfoList(String diskUrl, String matchRules, int depth) throws IOException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("diskUrl", diskUrl);
        paramsMap.put("matchRules", matchRules);
        paramsMap.put("depth", depth);
        ResponseInfo responseInfo = this.executeHttpGetRequest("/fileServerManage/getMatchFileMsgInfos.do", paramsMap, 120000);
        String respStr = responseInfo.getResponseStr();
        int statusCode = responseInfo.getStatusCode();
        if (statusCode != 200) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
        }
        String data = this.getDataStr(respStr);
        List<FileMsgInfo> fileMsgInfoList = new ArrayList<FileMsgInfo>(1);
        if (StringUtils.isNotEmpty((String)data)) {
            fileMsgInfoList = (List)JSONUtils.cast((String)data, (boolean)true, List.class, (Class[])new Class[]{FileMsgInfo.class});
        }
        return fileMsgInfoList;
    }

    @Override
    public String buildCopyScript(String diskUrl, String targetDiskUrl, String ... filePaths) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("diskUrl", diskUrl);
        paramsMap.put("targetDiskUrl", targetDiskUrl);
        paramsMap.put("filePaths", this.buildParamOfFilePaths(filePaths));
        ResponseInfo responseInfo = this.executeHttpPostRequest("/fileServerManage/buildCopyScript.do", paramsMap, 120000);
        String respStr = responseInfo.getResponseStr();
        int statusCode = responseInfo.getStatusCode();
        if (statusCode != 200) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
        }
        return this.getDataStr(respStr);
    }

    @Override
    public String buildRmScript(String diskUrl, String ... filePaths) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("diskUrl", diskUrl);
        paramsMap.put("filePaths", this.buildParamOfFilePaths(filePaths));
        ResponseInfo responseInfo = this.executeHttpPostRequest("/fileServerManage/buildRmScript.do", paramsMap, 120000);
        String respStr = responseInfo.getResponseStr();
        int statusCode = responseInfo.getStatusCode();
        if (statusCode != 200) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
        }
        return this.getDataStr(respStr);
    }

    private String buildParamOfFilePaths(String ... filePaths) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filePaths.length; ++i) {
            sb.append(filePaths[i]);
            if (i == filePaths.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private int getMaxDirectoryScanDepth() {
        try {
            ResponseInfo responseInfo = this.executeHttpGetRequest("/fileServerManage/getMaxDirectoryScanDepth.do", null, HttpFileClient.getReadTimeout());
            String respStr = responseInfo.getResponseStr();
            int statusCode = responseInfo.getStatusCode();
            if (statusCode != 200) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
            }
            String data = this.getDataStr(respStr);
            if (StringUtils.isNotEmpty((String)data)) {
                return Integer.parseInt(data);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return 5;
    }

    private FileServiceVersion getFileServerVersion() {
        ResponseInfo responseInfo = this.executeHttpGetRequest("/fileServerManage/getVersion.do", null, HttpFileClient.getReadTimeout());
        String respStr = responseInfo.getResponseStr();
        int statusCode = responseInfo.getStatusCode();
        if (statusCode == 404) {
            return FileServiceVersion.VERSION1;
        }
        if (statusCode != 200) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
        }
        String data = this.getDataStr(respStr);
        if (StringUtils.isNotEmpty((String)data)) {
            return FileServiceVersion.getValueOf(data);
        }
        return FileServiceVersion.VERSION1;
    }

    private String getDataStr(String respStr) {
        Map<String, String> responseMap = ResolveUtils.resolveJson(respStr);
        if (responseMap != null) {
            String description;
            if (ERROR.equals(responseMap.get(STATUS)) && !StringUtils.isEmpty((String)(description = responseMap.get(DESCRIPTION)))) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{description});
            }
            return responseMap.get(DATA);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseInfo executeHttpPostRequest(String requestPath, Map<String, Object> paramMap, int readTimeOut) {
        ResponseInfo responseInfo;
        String httpUrlPrefix = this.fileService.getHttpUrlPrefix();
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            client = HttpFileClient.getHttpClient(readTimeOut, httpUrlPrefix);
            StringBuilder uri = new StringBuilder();
            if (httpUrlPrefix.endsWith("/")) {
                httpUrlPrefix = httpUrlPrefix.substring(0, httpUrlPrefix.length() - 1);
            }
            uri.append(httpUrlPrefix);
            if (!requestPath.startsWith("/")) {
                requestPath = "/" + requestPath;
            }
            uri.append(requestPath);
            HttpPost httpPost = new HttpPost(uri.toString());
            this.setCookie(httpPost);
            StringEntity params = new StringEntity(JSONUtils.toString(paramMap), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)params);
            response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity resEntity = response.getEntity();
            String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)UTF_8);
            responseInfo = new ResponseInfo(statusCode, respStr);
        }
        catch (KDException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.fileserviceException, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                HttpFileClient.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
        HttpFileClient.closeClientAndResponse(client, response);
        return responseInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseInfo executeHttpGetRequest(String requestPath, Map<String, Object> paramMap, int readTimeOut) {
        ResponseInfo responseInfo;
        String httpUrlPrefix = this.fileService.getHttpUrlPrefix();
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            StringBuilder uri = new StringBuilder();
            client = HttpFileClient.getHttpClient(readTimeOut, httpUrlPrefix);
            if (httpUrlPrefix.endsWith("/")) {
                httpUrlPrefix = httpUrlPrefix.substring(0, httpUrlPrefix.length() - 1);
            }
            uri.append(httpUrlPrefix);
            if (!requestPath.startsWith("/")) {
                requestPath = "/" + requestPath;
            }
            uri.append(requestPath);
            if (paramMap != null && !paramMap.isEmpty()) {
                int size = 0;
                for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                    if (size == 0) {
                        uri.append("?");
                    } else {
                        uri.append("&");
                    }
                    uri.append(entry.getKey()).append("=").append(entry.getValue());
                    ++size;
                }
            }
            HttpGet get = new HttpGet();
            this.setCookie(get);
            get.setURI(new URI(uri.toString()));
            response = client.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity resEntity = response.getEntity();
            String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)UTF_8);
            responseInfo = new ResponseInfo(statusCode, respStr);
        }
        catch (KDException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.fileserviceException, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                HttpFileClient.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
        HttpFileClient.closeClientAndResponse(client, response);
        return responseInfo;
    }

    private boolean isDefaultFileStorage() {
        if (FileServiceType.ATTACHMENT == this.fileServiceType && !FileServiceFactory.isDefaultAttachmentFileStorageClass()) {
            return false;
        }
        if (FileServiceType.IMAGE == this.fileServiceType && !FileServiceFactory.isDefaultImageFileStorageClass()) {
            return false;
        }
        return FileServiceType.ERECEIPT != this.fileServiceType || FileServiceFactory.isDefaultEreceiptFileStorageClass();
    }

    private void setCookie(HttpGet get) {
        if (this.fileService.needAuth()) {
            String ticket = this.fileService.getTicket();
            get.addHeader(COOKIE, "ticket=" + ticket);
        }
    }

    private void setCookie(HttpPost httpPost) {
        if (this.fileService.needAuth()) {
            String ticket = this.fileService.getTicket();
            httpPost.addHeader(COOKIE, "ticket=" + ticket);
        }
    }

    private void setCookie(Map<String, String> header) {
        if (header != null && this.fileService.needAuth()) {
            String ticket = this.fileService.getTicket();
            header.put(COOKIE, "ticket=" + ticket);
        }
    }

    private static class ResponseInfo {
        private int statusCode;
        private String responseStr;

        public ResponseInfo(int statusCode, String responseStr) {
            this.statusCode = statusCode;
            this.responseStr = responseStr;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResponseStr() {
            return this.responseStr;
        }
    }
}

