/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.permission;

import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.permission.IllegalPathStorageFactory;
import kd.bos.fileservice.recycle.RecycleBin;
import kd.bos.fileservice.utils.FilePathCheckUtil;
import kd.bos.fileservice.utils.TAUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.jetbrains.annotations.NotNull;

public class FilePermissionManager {
    private static final String FILESERVER_CHECK_ENABLE = "permission.check.fileserver.enable";
    private static final String FILESERVER_CHECK_IS_PUBLIC = "permission.check.isPublic";
    public static final String TRUE_STR = "true";
    public static final String PATH_PREFIX = "/";
    private static final Log logger = LogFactory.getLog(FilePermissionManager.class);
    public static final String BOS_FILESERVICE_SDK = "bos-fileservice-sdk";

    public static String checkDownloadPath(String path, FileService fileService) {
        try {
            if (FilePermissionManager.isWhite(path) || !FilePermissionManager.isPublic()) {
                return path;
            }
            String finalPath = FilePermissionManager.formatPath(path);
            String tenantId = TAUtil.getTenantId();
            String accountId = TAUtil.getAccountId();
            String currentTAPrefix = FilePermissionManager.getCurrentTAPrefix(tenantId, accountId);
            if (FilePermissionManager.isStartWithTAPrefix(finalPath)) {
                if (!finalPath.startsWith(currentTAPrefix)) {
                    throw new KDException(BosErrorCode.fileserviceException, new Object[]{Resources.getString((String)"\u7981\u6b62\u8de8\u6570\u636e\u4e2d\u5fc3\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5668\uff01path=%1$s CurrentTA=%2$s", (String)"FilePermissionManager_1", (String)BOS_FILESERVICE_SDK, (Object[])new Object[]{path, currentTAPrefix})});
                }
            } else if (!fileService._existsNopm(finalPath = FilePermissionManager.buildPathWithCurrentTAPrefix(finalPath, tenantId, accountId))) {
                finalPath = path;
                if (FilePermissionManager.isEnable() && fileService._existsNopm(finalPath)) {
                    IllegalPathStorageFactory.getIllegalPathStorage().write(FilePermissionManager.formatPath(path), tenantId, accountId);
                }
            }
            return finalPath;
        }
        catch (Throwable t) {
            if (FilePermissionManager.isEnable()) {
                if (t instanceof KDException) {
                    throw t;
                }
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{t});
            }
            return path;
        }
    }

    public static String checkUploadPath(String path) {
        if (FilePermissionManager.isWhite(path)) {
            return path;
        }
        if (path.startsWith(RecycleBin.getRootPath())) {
            return path;
        }
        FilePermissionManager.fileUploadPathGovern(path);
        if (!FilePermissionManager.isEnable() || !FilePermissionManager.isPublic()) {
            return path;
        }
        String finalPath = FilePermissionManager.formatPath(path);
        String tenantId = TAUtil.getTenantId();
        String accountId = TAUtil.getAccountId();
        String currentTAPrefix = FilePermissionManager.getCurrentTAPrefix(tenantId, accountId);
        if (FilePermissionManager.isStartWithTAPrefix(finalPath)) {
            if (!finalPath.startsWith(currentTAPrefix)) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{Resources.getString((String)"\u7981\u6b62\u8de8\u6570\u636e\u4e2d\u5fc3\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5668\uff01path=%1$s CurrentTA=%2$s", (String)"FilePermissionManager_1", (String)BOS_FILESERVICE_SDK, (Object[])new Object[]{path, currentTAPrefix})});
            }
        } else {
            finalPath = FilePermissionManager.buildPathWithCurrentTAPrefix(finalPath, tenantId, accountId);
        }
        return finalPath;
    }

    private static String getCurrentTAPrefix(String tenantId, String accountId) {
        if (StringUtils.isEmpty((String)tenantId) || StringUtils.isEmpty((String)accountId)) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{Resources.getString((String)"\u5f53\u524d\u7ebf\u7a0b\u4e2d\u65e0RequestContext\u4fe1\u606f\uff0c\u7981\u6b62\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5668\uff01", (String)"FilePermissionManager_2", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0])});
        }
        return PATH_PREFIX + tenantId + PATH_PREFIX + accountId;
    }

    private static boolean isStartWithTAPrefix(String path) {
        List<String> taPrefixList = TAUtil.getAllTAPrefixList(PATH_PREFIX);
        if (taPrefixList.isEmpty()) {
            throw new KDException(BosErrorCode.fileserviceException, new Object[]{Resources.getString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u73af\u5883\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\uff01", (String)"FilePermissionManager_3", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0])});
        }
        for (String taPrefix : taPrefixList) {
            if (!path.startsWith(taPrefix)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String buildPathWithCurrentTAPrefix(String finalPath, String tenantId, String accountID) {
        String pathA = PATH_PREFIX + accountID;
        String pathT = PATH_PREFIX + tenantId;
        if (!finalPath.startsWith(pathA)) {
            finalPath = pathA + finalPath;
        }
        if (!finalPath.startsWith(pathT)) {
            finalPath = pathT + finalPath;
        }
        return finalPath;
    }

    private static void fileUploadPathGovern(String path) {
        block4: {
            try {
                FilePathCheckUtil.FilePathCheckInfo filePathCheckInfo = FilePathCheckUtil.check(path);
                if (!filePathCheckInfo.isLegal()) {
                    StringBuilder msg = new StringBuilder();
                    String tip = Resources.getString((String)"\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84\u975e\u6cd5\uff1apath=%1$s, \u5408\u6cd5\u6587\u4ef6\u8def\u5f84\u89c4\u5219\uff1a'/\u79df\u6237ID/\u8d26\u5957ID/\u65e5\u671f'\u4f5c\u4e3a\u524d\u7f00, \u975e\u6cd5\u539f\u56e0\uff1a%2$s", (String)"FilePermissionManager_4", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
                    msg.append(String.format(tip, path, filePathCheckInfo.getMsg()));
                    throw new KDException(BosErrorCode.fileserviceException, new Object[]{msg.toString()});
                }
            }
            catch (Throwable e) {
                logger.error(e);
                if (!FilePathCheckUtil.isEnable()) break block4;
                if (e instanceof KDException) {
                    throw e;
                }
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{e});
            }
        }
    }

    private static boolean isWhite(String path) {
        try {
            return FilePathCheckUtil.isMatchWhiteRule(path);
        }
        catch (Throwable e) {
            logger.error(e);
            return false;
        }
    }

    private static boolean isEnable() {
        return TRUE_STR.equals(FilePermissionManager.getProperty(FILESERVER_CHECK_ENABLE));
    }

    private static boolean isPublic() {
        return TRUE_STR.equals(FilePermissionManager.getProperty(FILESERVER_CHECK_IS_PUBLIC));
    }

    @NotNull
    private static String formatPath(String path) {
        if (path.startsWith("//")) {
            path = path.substring(1);
        }
        if (!path.startsWith(PATH_PREFIX)) {
            path = PATH_PREFIX + path;
        }
        return path;
    }

    private static String getProperty(String key) {
        String tenantId = TAUtil.getTenantId();
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((String)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }
}

