/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.preview;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kd.bos.bundle.BosRes;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.config.FileServiceConfig;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.excelpreview.ExcelPreviewFactory;
import kd.bos.fileservice.impl.AbstractFileService;
import kd.bos.fileservice.impl.AttachmentFileService;
import kd.bos.fileservice.impl.FileServiceVersion;
import kd.bos.fileservice.impl.HttpFileClient;
import kd.bos.fileservice.impl.YunHomeService;
import kd.bos.fileservice.multiserver.Dispatcher;
import kd.bos.fileservice.multiserver.DispatcherFactory;
import kd.bos.fileservice.path.DecodeFileFactory;
import kd.bos.fileservice.preview.PreviewService;
import kd.bos.fileservice.spiimpl.FileServiceImpl;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.fileservice.utils.FileTimeoutUtil;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.fileservice.utils.HeaderUtil;
import kd.bos.fileservice.utils.ParameterUtil;
import kd.bos.fileservice.utils.TAUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class DefaultPreviewServiceImpl
implements PreviewService {
    private static Log logger = LogFactory.getLog(DefaultPreviewServiceImpl.class);
    private static final String MAGIC_STRING = "frSheet";
    private static final String COOKIE = "Cookie";
    private static final String BOS_FILESERVICE_SDK = "bos-fileservice-sdk";
    private static final String PREVIEW_CACHE_REFRESH = "filepreview.refresh.enable";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private boolean isPreviewcacheEnable;
    private boolean isPreviewcacheRefresh;
    private int uploadTimeout;
    private FileService fileService;
    private YunHomeService yunHomeService;
    private Dispatcher fileServerDispatcher;
    private Dispatcher previewServerDispatcher;

    @Override
    public void init(FileService fileService) {
        this.fileService = fileService;
        this.isPreviewcacheEnable = AttachmentFileService.isPreviewcacheEnable() && fileService instanceof AttachmentFileService;
        this.isPreviewcacheRefresh = Boolean.parseBoolean(System.getProperty(PREVIEW_CACHE_REFRESH));
        this.uploadTimeout = AttachmentFileService.getUploadTimeout();
        this.fileServerDispatcher = DispatcherFactory.build("attachmentServer.url", BosErrorCode.fileServerNotConfigured);
        this.previewServerDispatcher = DispatcherFactory.build("yunpan.previewUrl", BosErrorCode.previewFailed);
        this.yunHomeService = new YunHomeService(fileService);
    }

    @Override
    public Map<String, Object> preview(String fileName, String path, String userAgent) {
        path = DecodeFileFactory.getDecodeService().getDecodeFilePath(path);
        path = path.replaceAll("//", "/");
        InputStream in = null;
        Map<Object, Object> result = new HashMap();
        HashMap<String, Object> previewResult = new HashMap<String, Object>(3);
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        long startTime = 0L;
        long endTime = 0L;
        if (YunHomeService.isNotNeedDeal(ext)) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            if (userAgent != null) {
                headerMap.put("USER-AGENT", userAgent);
            }
            try {
                in = this.fileService.download(path, headerMap, new HashMap<String, String>());
            }
            catch (Exception e) {
                result = ExceptionUtil.setErrorInfo(e.getMessage());
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), result);
                return previewResult;
            }
            previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.NOT_NEED_CHANGE.getEnumName());
            previewResult.put(PreviewParams.RESULT.getEnumName(), in);
            if ("txt".equalsIgnoreCase(ext)) {
                previewResult.put(PreviewParams.CHARSET.getEnumName(), FileUtil.getFilecharsetNew(in));
            }
            return previewResult;
        }
        if (this.isPreviewcacheRefresh) {
            return this.getYunPanCovertRs(path, fileName, ext, userAgent, false);
        }
        if (this.isPreviewcacheEnable) {
            startTime = System.currentTimeMillis();
            String previewUrl = path + ("xls".equalsIgnoreCase(ext) || "xlsx".equalsIgnoreCase(ext) ? ".zip" : ".pdf");
            String previewMetaUrl = path + ".meta";
            try {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("preview", "true");
                headerMap.put("preview.url", URLEncoder.encode(previewUrl, StandardCharsets.UTF_8.name()));
                headerMap.put("preview.metaUrl", URLEncoder.encode(previewMetaUrl, StandardCharsets.UTF_8.name()));
                HashMap<String, String> resHeader = new HashMap<String, String>();
                in = this.fileService.download(path, headerMap, resHeader);
                endTime = System.currentTimeMillis();
                if (!"xls".equalsIgnoreCase(ext) && !"xlsx".equalsIgnoreCase(ext)) {
                    previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.PDF_SUCCESS.getEnumName());
                    previewResult.put(PreviewParams.RESULT.getEnumName(), in);
                    logger.info(String.format("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6%s\u6240\u8017\u8d39\u7684\u65f6\u95f4\u4e3a%s\u6beb\u79d2", fileName, endTime - startTime));
                    return previewResult;
                }
                String id = (String)resHeader.get("cacheId");
                if (StringUtils.isNotEmpty((String)id)) {
                    result = ExcelPreviewFactory.getExcelPreview().preview(id, in);
                    if (result.containsKey("url")) {
                        String accountId = TAUtil.getAccountId();
                        String url = (String)result.get("url");
                        url = url + "?kdcdc=" + accountId;
                        result.put("url", url);
                    }
                    previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.XLSX_SUCCESS.getEnumName());
                    previewResult.put(PreviewParams.RESULT.getEnumName(), result);
                    logger.info(String.format("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6%s\u6240\u8017\u8d39\u7684\u65f6\u95f4\u4e3a%s\u6beb\u79d2", fileName, endTime - startTime));
                    return previewResult;
                }
            }
            catch (Exception e) {
                logger.error("\u65e0\u6cd5\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u83b7\u53d6\u9884\u89c8\u6570\u636e\uff0c\u6267\u884cgetYunPanCovertRs\u65b9\u6cd5\uff0c\u8fdb\u884c\u6587\u4ef6\u9884\u89c8\u4e91\u76d8\u8f6c\u6362", (Object)e.getMessage());
            }
        }
        return this.getYunPanCovertRs(path, fileName, ext, userAgent, false);
    }

    @Override
    public void removePreview(String id) {
        ExcelPreviewFactory.getExcelPreview().remove(id);
    }

    @Override
    public Map<String, Object> previewFromCache(String fileName, String path, String userAgent, InputStream cacheIn) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (YunHomeService.isNotNeedDeal(ext)) {
            InputStream in = DecodeFileFactory.getDecodeService().getDecodeFileStream(cacheIn);
            return YunHomeService.getNotNeedTransferRs(in, ext);
        }
        String decodeFilePath = DecodeFileFactory.getDecodeService().getDecodeFilePath(path);
        return this.getYunPanCovertRs(decodeFilePath, fileName, ext, userAgent, true);
    }

    @Override
    public Map<String, Object> previewWPS(String fileName, String path, String userAgent, Map<String, String> config) {
        String oringPath = path;
        path = DecodeFileFactory.getDecodeService().getDecodeFilePath(path);
        HashMap<String, Object> result = new HashMap<String, Object>();
        InputStream fileStream = null;
        String error = null;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (userAgent != null) {
            headerMap.put("USER-AGENT", userAgent);
        }
        try {
            fileStream = this.fileService.download(path, headerMap, new HashMap<String, String>());
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        if (error == null && fileStream != null) {
            return this.yunHomeService.transferPreviewStream(config, fileStream, fileName, oringPath);
        }
        result.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
        result.put(PreviewParams.DESCRIPTION.getEnumName(), Resources.getString((String)error, (String)"AbstractFileService_1", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> previewFromCacheWPS(String fileName, String path, String userAgent, InputStream cacheIn, Map<String, String> config) {
        InputStream in = DecodeFileFactory.getDecodeService().getDecodeFileStream(cacheIn);
        try {
            Map<String, Object> map = this.yunHomeService.transferPreviewStream(config, in, fileName, YunHomeService.getIdFromTempCachePreviewUrl(path));
            return map;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("stream close error", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void deletePreviewCacheWps(String url, Map<String, String> config) {
        this.yunHomeService.deletePrevieCache(config, url, true);
    }

    @Override
    public void deletePreviewWps(String path, Map<String, String> config) {
        if (this.fileService instanceof AbstractFileService) {
            ((AbstractFileService)this.fileService).physicalDelete(path);
        } else if (this.fileService instanceof FileServiceImpl) {
            ((FileServiceImpl)this.fileService).physicalDelete(path);
        } else {
            this.fileService.delete(path);
        }
        this.yunHomeService.deletePrevieCache(config, this.fileService.getFileServiceExt().getRealPath(path), false);
    }

    private Map<String, Object> getYunPanCovertRs(String path, String fileName, String ext, String userAgent, boolean temp) {
        InputStream in = null;
        Map<Object, Object> result = new HashMap();
        Map<String, Object> previewResult = new HashMap<String, Object>();
        long startTime = System.currentTimeMillis();
        HashMap<String, String> detail = new HashMap<String, String>();
        if (FileServiceConfig.PREVIEW_SIZE_LIMIT_ENABLE.getBoolean()) {
            try {
                InputStream checkInputStream;
                long limitMax = Math.min(FileServiceConfig.PREVIEW_SIZE_LIMIT_MAX.getLong(), FileServiceConfig.PREVIEW_SIZE_LIMIT_MAX.getDefault());
                long limit = Math.min(FileServiceConfig.PREVIEW_SIZE_LIMIT.getLong(), limitMax);
                if (temp) {
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    checkInputStream = cache.getInputStream(path);
                } else {
                    checkInputStream = this.fileService.getInputStream(path);
                }
                boolean checkResult = DefaultPreviewServiceImpl.checkFileSize(checkInputStream, fileName, limit == 0L ? limitMax : limit);
                if (!checkResult) {
                    previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
                    previewResult.put(PreviewParams.RESULT.getEnumName(), ExceptionUtil.setExceedInfo(limitMax));
                    return previewResult;
                }
            }
            catch (Exception e) {
                result = ExceptionUtil.setErrorInfo(e.getMessage());
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), result);
                return previewResult;
            }
        }
        try {
            in = this.yunPanConvert(path, fileName, userAgent, detail, temp);
        }
        catch (Exception e) {
            result = ExceptionUtil.setErrorInfo(e.getMessage());
            previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
            previewResult.put(PreviewParams.RESULT.getEnumName(), result);
            return previewResult;
        }
        long endTime = System.currentTimeMillis();
        logger.info(String.format("%s\u5728\u4e91\u76d8\u8f6c\u6362\u4e2d\u6240\u8017\u8d39\u7684\u65f6\u95f4\u4e3a%s\u6beb\u79d2", fileName, endTime - startTime));
        if ("xlsx".equalsIgnoreCase(ext) || "xls".equalsIgnoreCase(ext)) {
            if (FileServiceConfig.PREVIEW_TRANS_EXCEL_ENABLE.getBoolean()) {
                in = DefaultPreviewServiceImpl.transferByReplaceContent(in, fileName, detail);
            }
            if (this.isPreviewcacheEnable && !temp && !((String)detail.get("id")).endsWith("tip")) {
                previewResult = this.saveAndPreview(in, fileName, path, (String)detail.get("id"));
            } else {
                result = ExcelPreviewFactory.getExcelPreview().preview((String)detail.get("id"), in);
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.XLSX_SUCCESS.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), result);
            }
            try {
                String url;
                Map res = (Map)previewResult.get(PreviewParams.RESULT.getEnumName());
                if (res != null && res.containsKey("url") && StringUtils.isNotEmpty((String)(url = (String)res.get("url")))) {
                    String accountId = TAUtil.getAccountId();
                    url = url + "?kdcdc=" + accountId;
                    res.put("url", url);
                    previewResult.put(PreviewParams.RESULT.getEnumName(), res);
                }
            }
            catch (Exception e) {
                logger.error("Error concatenating kdcdc: " + e.getMessage());
            }
        } else if (this.isPreviewcacheEnable && !temp) {
            previewResult = this.saveAndPreview(in, fileName, path, null);
        } else {
            previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.PDF_SUCCESS.getEnumName());
            previewResult.put(PreviewParams.RESULT.getEnumName(), in);
        }
        return previewResult;
    }

    private void setCookie(HttpGet get) {
        if (this.fileService.needAuth()) {
            String ticket = this.fileService.getTicket();
            get.addHeader(COOKIE, "ticket=" + ticket);
        }
    }

    private String getDownloadUrl(String path) {
        try {
            Class<?> clazzUrlService = Class.forName("kd.bos.url.UrlService");
            Method getAttachmentFullUrl = clazzUrlService.getMethod("getAttachmentFullUrl", String.class);
            String url = (String)getAttachmentFullUrl.invoke(clazzUrlService.newInstance(), path);
            Class<?> clazzEncreptSessionUtils = Class.forName("kd.bos.session.EncreptSessionUtils");
            Method encryptSession = clazzEncreptSessionUtils.getMethod("encryptSession", String.class);
            String downUrl = (String)encryptSession.invoke(clazzEncreptSessionUtils.newInstance(), url);
            downUrl = downUrl + RevProxyUtil.getHttpParamCollectFlag((String)downUrl) + "source=preview";
            if (DefaultPreviewServiceImpl.isLog()) {
                logger.info("yunpan downLoadUrl=" + downUrl);
            }
            return downUrl;
        }
        catch (Exception t) {
            throw new KDException(BosErrorCode.fileserviceException, "getDownloadUrl error", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> saveAndPreview(InputStream in, String fileName, String path, String excelId) {
        if (excelId != null) {
            fileName = fileName + ".zip";
            path = path + ".zip";
        } else {
            fileName = fileName + ".pdf";
            path = path + ".pdf";
        }
        Map<Object, Object> result = new HashMap();
        HashMap<String, Object> previewResult = new HashMap<String, Object>();
        String tmpfilePath = null;
        FileInputStream tempFileStream = null;
        try {
            tmpfilePath = FileUtil.writeFileToDisk(in, fileName);
            tempFileStream = new FileInputStream(tmpfilePath);
        }
        catch (Exception e) {
            result = ExceptionUtil.setErrorInfo(Resources.getString((String)"\u4e91\u76d8\u8f6c\u6362\u6d41\u7f13\u5b58\u5230\u78c1\u76d8\u4e2d\u5931\u8d25:", (String)"AbstractFileService_12", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]) + e);
            previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
            previewResult.put(PreviewParams.RESULT.getEnumName(), result);
            HashMap<String, Object> hashMap = previewResult;
            return hashMap;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        FileItem fileItem = new FileItem(fileName, path, tempFileStream);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("uploadCache", "true");
        if (excelId != null) {
            headers.put("cacheId", excelId);
        }
        try {
            try {
                this.upload(fileItem, headers);
            }
            catch (Exception t) {
                logger.error("Save cache file to FileServer error.", (Throwable)t);
            }
            finally {
                fileItem.close();
                if (tempFileStream != null) {
                    ((InputStream)tempFileStream).close();
                }
            }
            in = new FileInputStream(tmpfilePath);
            FileTimeoutUtil.removeFile(tmpfilePath, in, 120000L);
            if (excelId != null) {
                result = ExcelPreviewFactory.getExcelPreview().preview(excelId, in);
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.XLSX_SUCCESS.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), result);
            } else {
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.PDF_SUCCESS.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), in);
            }
        }
        catch (Exception e) {
            result = ExceptionUtil.setErrorInfo(Resources.getString((String)"\u4e91\u76d8\u8f6c\u6362\u6d41\u7f13\u5b58\u5230\u78c1\u76d8\u4e2d\u5931\u8d25:", (String)"AbstractFileService_12", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]) + e);
            previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
            previewResult.put(PreviewParams.RESULT.getEnumName(), result);
            return previewResult;
        }
        return previewResult;
    }

    private String upload(FileItem item, Map<String, String> headers) {
        String httpUrlPrefix = this.fileServerDispatcher.select();
        String httpUploadUrlPrefix = httpUrlPrefix + (httpUrlPrefix.endsWith("/") ? "" : "/") + "file/upload.do";
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("version", FileServiceVersion.VERSION1.toString());
        arg.put("url", item.getPath());
        arg.put("fileName", item.getFileName());
        arg.put("createNewFileWhenExists", String.valueOf(item.isCreateNewFileWhenExists()));
        if (headers != null) {
            arg.putAll(headers);
        }
        try {
            if (item.getFileName() != null && item.getFileName().lastIndexOf(".") <= 0) {
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{"upload file " + item.getPath() + Resources.getString((String)" failed. description: \u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFileService_0", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0])});
            }
            if (this.fileService.needAuth()) {
                arg.put("ticket", this.fileService.getTicket());
            }
            Map<String, String> result = HttpFileClient.sendFile(httpUploadUrlPrefix, this.uploadTimeout * 1000, item.getInputStream(), arg);
            item.close();
            if (result != null) {
                String description;
                String url = result.get("url");
                if (StringUtils.isEmpty((String)url) && StringUtils.isNotEmpty((String)(description = result.get("description")))) {
                    throw new KDException(BosErrorCode.uploadFailed, new Object[]{"upload " + item.getPath() + " failed. description:" + description});
                }
                String string = this.fileService.getFileServiceExt().save(url);
                return string;
            }
            try {
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{"upload timeout within " + this.uploadTimeout + " seconds" + item.getPath()});
            }
            catch (KDException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"upload " + item.getPath() + " failed."});
            }
        }
        finally {
            item.close();
        }
    }

    private InputStream yunPanConvert(String path, String fileName, String userAgent, Map<String, String> rs, boolean temp) {
        CloseableHttpResponse response;
        String previewUrlPrefix = null;
        InputStream in = null;
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        try {
            previewUrlPrefix = this.previewServerDispatcher.select();
        }
        catch (KDException e) {
            throw new KDException(BosErrorCode.previewFailed, BosRes.get((String)BOS_FILESERVICE_SDK, (String)"DefaultPreviewServiceImpl_0", (String)"\u8bbf\u95ee\u4e91\u76d8\u63a5\u53e3\u670d\u52a1\u7684ip\u6ca1\u6709\u914d\u7f6e,\u6216\u662f\u914d\u7f6e\u7684\u5730\u5740\u4e0d\u53ef\u7528", (Object[])new Object[0]), (Throwable)e);
        }
        Map<Object, Object> paramResult = new HashMap();
        StringBuilder uri = new StringBuilder(previewUrlPrefix).append(previewUrlPrefix.endsWith("/") ? "" : "/").append("api/officeToPdf?");
        try {
            String fileDownloadUrl = "";
            if (temp) {
                if (DefaultPreviewServiceImpl.isLog()) {
                    logger.info("yunpan temp downLoadUrl=" + path);
                }
                fileDownloadUrl = URLEncoder.encode(path, StandardCharsets.UTF_8.name());
            } else {
                fileDownloadUrl = URLEncoder.encode(this.getDownloadUrl(URLEncoder.encode(path, StandardCharsets.UTF_8.name())), StandardCharsets.UTF_8.name());
            }
            paramResult = ParameterUtil.concatUrl(uri, fileName, ext, fileDownloadUrl);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.previewFailed, new Object[]{BosRes.get((String)BOS_FILESERVICE_SDK, (String)"DefaultPreviewServiceImpl_1", (String)"filename\u6216download_url encode\u51fa\u9519:", (Object[])new Object[0]) + e});
        }
        uri = (StringBuilder)paramResult.get("uri");
        String id = (String)paramResult.get("id");
        rs.put("id", id);
        CloseableHttpClient client = HttpFileClient.getHttpClient(previewUrlPrefix);
        HttpGet get = new HttpGet(uri.toString());
        get.setConfig(RequestConfig.custom().setSocketTimeout(this.uploadTimeout * 1000).setConnectTimeout(this.uploadTimeout * 1000).build());
        this.setCookie(get);
        HeaderUtil.setHttpGet(get, userAgent);
        try {
            response = client.execute((HttpUriRequest)get);
            in = response.getEntity().getContent();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.previewFailed, new Object[]{BosRes.get((String)BOS_FILESERVICE_SDK, (String)"DefaultPreviewServiceImpl_2", (String)"\u4e91\u76d8\u670d\u52a1\u54cd\u5e94\u5931\u8d25:", (Object[])new Object[0]) + e.getMessage()});
        }
        if (in == null) {
            throw new KDException(BosErrorCode.previewFailed, new Object[]{BosRes.get((String)BOS_FILESERVICE_SDK, (String)"DefaultPreviewServiceImpl_3", (String)"\u4ece\u4e91\u76d8\u4e2d\u672a\u83b7\u53d6\u5230pdf\u6d41\u6570\u636e,pdf\u8f6c\u6362\u5931\u8d25:", (Object[])new Object[0])});
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            try {
                if (DefaultPreviewServiceImpl.isLog()) {
                    logger.error("yunpan return msg:" + IOUtils.toString((InputStream)in, (String)"utf-8"));
                }
                in.close();
            }
            catch (IOException e) {
                logger.error("logger error info fail");
            }
            throw new KDException(BosErrorCode.previewFailed, new Object[]{this.getErrorMsg(statusCode)});
        }
        return in;
    }

    private static boolean checkFileSize(InputStream inputStream, String fileName, Long limitSize) {
        long totalBytesWritten = 0L;
        try {
            int read;
            byte[] buffer = new byte[1024];
            while ((read = inputStream.read(buffer)) != -1) {
                if ((totalBytesWritten += (long)read) <= limitSize) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("checkFileSize error fileName=" + fileName, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static long totalZipFileSize(ZipFile zipFile) {
        long total = 0L;
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if (ze.isDirectory()) continue;
                total += ze.getSize();
            }
        }
        return total;
    }

    private static InputStream transferByReplaceContent(InputStream source, String fileName, Map<String, String> detail) {
        FileOutputStream out;
        String value = MAGIC_STRING + System.currentTimeMillis();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String tempFilePath = kd.bos.util.FileUtils.checkFileUrl((String)(TEMP_DIR + "/tempExcel" + uuid));
        String targetFilePath = kd.bos.util.FileUtils.checkFileUrl((String)(TEMP_DIR + "/tempTarget" + uuid));
        try {
            out = new FileOutputStream(targetFilePath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("transferByReplaceContent error fileName=" + fileName, e);
        }
        ZipOutputStream zos = new ZipOutputStream((OutputStream)out, Charset.forName("GBK"));
        ZipFile zipFile = null;
        try {
            long limitSize = FileServiceConfig.PREVIEW_SIZE_LIMIT_4_EXCEL.getLong();
            limitSize = limitSize <= 0L ? FileServiceConfig.PREVIEW_SIZE_LIMIT_4_EXCEL.getDefault() : limitSize;
            File tempFile = new File(tempFilePath);
            FileTimeoutUtil.removeFile(tempFilePath, null, 120000L);
            FileUtils.copyToFile((InputStream)source, (File)tempFile);
            zipFile = new ZipFile(tempFile);
            long totalSize = DefaultPreviewServiceImpl.totalZipFileSize(zipFile);
            if (totalSize > limitSize) {
                String tipHtml = DefaultPreviewServiceImpl.tipHtml(limitSize, totalSize);
                String id = detail.get("id") + "tip";
                detail.put("id", id);
                zos.putNextEntry(new ZipEntry(detail.get("id") + ".html"));
                zos.write(tipHtml.getBytes(Charset.forName("GBK")));
                zos.closeEntry();
            } else {
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    String name = ze.getName();
                    zos.putNextEntry(new ZipEntry(name));
                    InputStream currentFileInputStream = zipFile.getInputStream(ze);
                    if (name.endsWith(".html") || name.endsWith(".htm")) {
                        String newLine;
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(currentFileInputStream, Charset.forName("GBK")));
                        if (name.contains("sheet")) {
                            while ((line = reader.readLine()) != null) {
                                newLine = line.replace("window.name!=\"frSheet\"", "window.name!=\"" + value + "\"");
                                zos.write(newLine.getBytes(Charset.forName("GBK")));
                                zos.write(System.getProperty("line.separator").getBytes());
                            }
                        } else if (name.contains("tabstrip")) {
                            while ((line = reader.readLine()) != null) {
                                newLine = line.replace("target=\"frSheet\"", "target=\"" + value + "\"");
                                zos.write(newLine.getBytes(Charset.forName("GBK")));
                                zos.write(System.getProperty("line.separator").getBytes());
                            }
                        } else {
                            while ((line = reader.readLine()) != null) {
                                String line1 = line.replace("name=\"frSheet\"", "name=\"" + value + "\"");
                                String line2 = line1.replace("target=\\\"frSheet\\\"", "target=\\\"" + value + "\\\"");
                                String line3 = line2.replace("name=\\\"frSheet\\\"", "name=\\\"" + value + "\\\"");
                                zos.write(line3.getBytes(Charset.forName("GBK")));
                                zos.write(System.getProperty("line.separator").getBytes());
                            }
                        }
                        reader.close();
                    } else {
                        int size;
                        byte[] buf = new byte[8196];
                        while ((size = currentFileInputStream.read(buf)) > 0) {
                            zos.write(buf, 0, size);
                        }
                    }
                    zos.closeEntry();
                }
            }
            FileInputStream in = new FileInputStream(targetFilePath);
            FileTimeoutUtil.removeFile(targetFilePath, in, 120000L);
            FileInputStream fileInputStream = in;
            return fileInputStream;
        }
        catch (Exception e) {
            throw new RuntimeException("transferByReplaceContent error fileName=" + fileName, e);
        }
        finally {
            try {
                zos.close();
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getErrorMsg(Integer statusCode) {
        switch (statusCode) {
            case 401: {
                return Resources.getString((String)"\u4e91\u76d8\u670d\u52a1\u54cd\u5e94401,URL\u4f20\u53c2\u9519\u8bef,\u8bf7\u68c0\u67e5sdk\u4ee3\u7801", (String)"AbstractFileService_7", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
            }
            case 402: {
                return Resources.getString((String)"\u4e91\u76d8\u670d\u52a1\u54cd\u5e94402,\u4e91\u76d8\u670d\u52a1\u4e0b\u8f7d\u6587\u6863\u5931\u8d25", (String)"AbstractFileService_8", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
            }
            case 502: {
                return Resources.getString((String)"\u4e91\u76d8\u670d\u52a1\u54cd\u5e94502,\u6587\u4ef6\u5df2\u88ab\u52a0\u5bc6,\u65e0\u6cd5\u8fdb\u884cpdf\u8f6c\u6362,\u9884\u89c8\u5931\u8d25", (String)"AbstractFileService_9", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
            }
            case 503: {
                return Resources.getString((String)"\u4e91\u76d8\u670d\u52a1\u54cd\u5e94503,\u6587\u4ef6\u8f6c\u6362\u5931\u8d25,\u8bf7\u67e5\u770b\u4e91\u76d8\u65e5\u5fd7", (String)"AbstractFileService_10", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
            }
        }
        return Resources.getString((String)("\u4e91\u76d8\u670d\u52a1\u54cd\u5e94" + statusCode + ",\u6587\u4ef6\u65e0\u6cd5\u8fdb\u884cpdf\u8f6c\u6362,\u9884\u89c8\u5931\u8d25"), (String)"AbstractFileService_11", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
    }

    private static boolean isLog() {
        return Boolean.getBoolean("yunpan.debug.enable.log");
    }

    private static String tipHtml(long limitSize, long totalSize) {
        return "<!DOCTYPE html>\n<html>\n<head>\n    <title>Tips Page</title>\n    <style>\n        body {\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            height: 100vh;\n            margin: 0;\n            background-color: #f7f7f7;\n            font-family: Arial, sans-serif;\n        }\n        \n        .container {\n            max-width: 400px;\n            text-align: center;\n            padding: 20px;\n            background-color: #ffffff;\n            border-radius: 8px;\n            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);\n        }\n        \n        h1 {\n            color: #333333;\n            font-size: 24px;\n            margin-bottom: 10px;\n        }\n        \n        p {\n            color: #666666;\n            font-size: 16px;\n            margin-bottom: 20px;\n        }\n        \n        .btn {\n            display: inline-block;\n            padding: 10px 20px;\n            background-color: #007bff;\n            color: #ffffff;\n            text-decoration: none;\n            border-radius: 4px;\n            transition: background-color 0.3s ease;\n        }\n        \n        .btn:hover {\n            background-color: #0056b3;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <h1>Tips</h1>\n        <p>Exceeded the preview limit, please download to view</p>\n        <p>System Excel content limit is\uff1a" + BigDecimal.valueOf(limitSize).divide(BigDecimal.valueOf(0x100000L), 2, RoundingMode.UP) + "M</p>\n        <p>Current Excel content size is\uff1a" + BigDecimal.valueOf(totalSize).divide(BigDecimal.valueOf(0x100000L), 2, RoundingMode.UP) + "M</p>\n    </div>\n</body>\n</html>\n";
    }
}

