/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.spiimpl;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.util.StringUtils;

public class EreceiptFileServiceConfig {
    private static final String ERECEIPT_FILESERVER_HTTP_URL = "ereceipt.url";
    private static final String ERECEIPT_FILESERVER_AUTH_TYPE = "ereceipt.authtype";
    private static final String ERECEIPT_FILESERVER_AUTH_USER = "ereceipt.authuser";
    private static final String ERECEIPT_FILESERVER_AUTH_PASS = "ereceipt.authpass";
    private static final String ERECEIPT_FILESERVER_CONTAINER = "ereceipt.container";
    private static final String ERECEIPT_FILESERVER_UPLOAD_TIMEOUT = "ereceipt.upload.timeout";
    private static final String ERECEIPT_FILESERVER_MAX_FILE_SIZE = "ereceiptServer.maxFileSize";
    private static final int DEFAULT_UPLOAD_TIMEOUT = 60;
    private static final String FILESERVER_ACCESS_KEY = "ereceipt.accessKey";
    private static final String FILESERVER_SECRET_KEY = "ereceipt.secretKey";
    private static final String FILESERVER_BUCKET = "ereceipt.bucket";
    private static final String FILESERVER_PREVIEW_URL = "yunpan.previewUrl";
    private static final String PREVIEW_CACHE_ENABLE = "filepreview.cache.enable";
    private static final boolean DEFAULT_PREVIEW_CACHE_ENABLE = true;
    private static final int DEFAULT_MAX_FILE_SIZE = 0x3200000;

    private int getUploadTimeout() {
        String s = FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESERVER_UPLOAD_TIMEOUT);
        if (s != null && !"".equals(s)) {
            return Integer.parseInt(s);
        }
        return 60;
    }

    private boolean getPreviewcacheEnable() {
        String isCacheEnable = FileServiceFactory.getPropertyByTenant(PREVIEW_CACHE_ENABLE);
        if (isCacheEnable != null && !"".equals(isCacheEnable)) {
            return Boolean.parseBoolean(isCacheEnable);
        }
        return true;
    }

    private String getAuthUserName() {
        String accessKey = FileServiceFactory.getPropertyByTenant(FILESERVER_ACCESS_KEY);
        return StringUtils.isEmpty((String)accessKey) ? FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESERVER_AUTH_USER) : accessKey;
    }

    private String getAuthPassWord() {
        String secretKey = FileServiceFactory.getPropertyByTenant(FILESERVER_SECRET_KEY);
        return StringUtils.isEmpty((String)secretKey) ? FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESERVER_AUTH_PASS) : secretKey;
    }

    private String getContainer() {
        String bucket = FileServiceFactory.getPropertyByTenant(FILESERVER_BUCKET);
        return StringUtils.isEmpty((String)bucket) ? FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESERVER_CONTAINER) : bucket;
    }

    private int getMaxUploadSize() {
        String maxFileSize = FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESERVER_MAX_FILE_SIZE);
        if (maxFileSize != null && !"".equals(maxFileSize)) {
            return Integer.parseInt(maxFileSize);
        }
        return 0x3200000;
    }

    private String getFileServerHttpUrl() {
        String httpUrlPrefix = FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESERVER_HTTP_URL);
        if (StringUtils.isEmpty((String)httpUrlPrefix)) {
            throw new KDException(BosErrorCode.fileServerNotConfigured, new Object[]{"server " + httpUrlPrefix + " is required"});
        }
        return httpUrlPrefix;
    }

    private String getPreviewUrl() {
        return FileServiceFactory.getPropertyByTenant(FILESERVER_PREVIEW_URL);
    }

    private String getAuthType() {
        return FileServiceFactory.getPropertyByTenant(ERECEIPT_FILESERVER_AUTH_TYPE);
    }

    public FileStorageConfig getConfig() {
        return new FileStorageConfig(this.getFileServerHttpUrl(), this.getAuthUserName(), this.getAuthPassWord(), this.getContainer(), this.getAuthType(), this.getUploadTimeout(), this.getMaxUploadSize(), this.getPreviewcacheEnable(), this.getPreviewUrl());
    }
}

