/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.spiimpl;

import com.alibaba.fastjson.JSON;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.config.FileServiceTenantConfig;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.fileservice.manage.FileServiceType;
import kd.bos.fileservice.preview.PreviewServiceFactory;
import kd.bos.fileservice.recycle.RecycleBin;
import kd.bos.fileservice.spiimpl.FileStorageSPIFactory;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.filestorage.spi.FileStorageConfig;
import kd.bos.filestorage.spi.FileStorageService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class FileServiceImpl
implements FileService {
    private static final String VALIDATE_ENABLE = "fileservice.validata.enable";
    private static final String USER_AGENT = "USER-AGENT";
    private static final String STATUS_CODE = "statusCode";
    private static final String INPUT_STREAM = "inputStream";
    private static final String UTF_8 = "utf-8";
    private static final String ERROR = "error";
    private static final String COOKIE = "Cookie";
    private static final String FAILED = " failed:";
    private static final String DOWNLOAD_FILE = "download file ";
    private static final String FILENAME = ". Filename:";
    private static final String BOS_FILESERVICE_SDK = "bos-fileservice-sdk";
    private static final Log logger = LogFactory.getLog(FileServiceImpl.class);
    private String fileServiceType;
    private final FileStorageConfig fileStorageConfig;
    private final FileStorageService fileStorageService;

    @Deprecated
    public FileServiceImpl(FileStorageConfig fileStorageConfig, String fileStorageClassName) {
        this.fileStorageConfig = fileStorageConfig;
        this.fileStorageService = FileStorageSPIFactory.getFileStorageService(fileStorageClassName);
        this.fileStorageService.setConfig(fileStorageConfig);
    }

    public FileServiceImpl(FileStorageConfig fileStorageConfig, String fileServiceType, String fileStorageClassName) {
        this.fileServiceType = fileServiceType;
        this.fileStorageConfig = fileStorageConfig;
        this.fileStorageService = FileStorageSPIFactory.getFileStorageService(fileServiceType, fileStorageClassName, fileStorageConfig);
    }

    @Override
    public int getMaxUploadSize() {
        return this.fileStorageConfig.getMaxUploadSize();
    }

    @Override
    public String upload(FileItem fileItem) {
        return this.upload(fileItem, null, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String upload(FileItem fileItem, Map<String, String> headers, boolean autoCloseHttpClient) {
        String string;
        InputStream inputStream = null;
        try {
            String oriPath = this.getValidFileName(fileItem.getPath());
            String path = this.getFileServiceExt().getRealPath(oriPath);
            this.printPath("upload-getRealPath", oriPath, path);
            if (!fileItem.isVerified()) {
                inputStream = this.getFileServiceExt().checkFile(fileItem.getInputStream(), fileItem.getFileName());
                fileItem.setVerified(true);
            } else {
                inputStream = fileItem.getInputStream();
            }
            logger.info("upload file, path:" + path);
            inputStream = this.getFileServiceExt().encode(path, inputStream);
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            if (StringUtil.isNotEmpty((String)fileItem.getAppId())) {
                headers.put("appId", fileItem.getAppId());
            }
            if (StringUtil.isNotEmpty((String)fileItem.getFId())) {
                headers.put("fid", fileItem.getFId());
            }
            if (StringUtil.isNotEmpty((String)fileItem.getType())) {
                headers.put("type", fileItem.getType());
            }
            if (StringUtil.isNotEmpty((String)fileItem.getPageId())) {
                headers.put("pageId", fileItem.getPageId());
            }
            String url = this.fileStorageService.upload(inputStream, path, fileItem.getFileName(), fileItem.isCreateNewFileWhenExists(), headers);
            fileItem.close();
            String saveUrl = this.getFileServiceExt().save(url);
            this.printPath("upload-save", url, saveUrl);
            string = saveUrl;
            fileItem.close();
        }
        catch (KDException e) {
            try {
                logger.error("upload file " + fileItem.getPath() + FAILED + e.getMessage(), (Throwable)e);
                throw e;
                catch (Exception e2) {
                    logger.error("upload file " + fileItem.getPath() + FAILED + e2.getMessage(), (Throwable)e2);
                    throw new KDException((Throwable)e2, BosErrorCode.uploadFailed, new Object[]{"upload " + fileItem.getPath() + " failed."});
                }
            }
            catch (Throwable throwable) {
                fileItem.close();
                IOUtils.closeQuietly(inputStream);
                if (autoCloseHttpClient) {
                    this.closeFileStorageService();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (autoCloseHttpClient) {
            this.closeFileStorageService();
        }
        return string;
    }

    private void closeFileStorageService() {
        try {
            this.fileStorageService.close();
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }

    @Override
    public List<String> upload(FileItem[] fileItems) {
        ArrayList<String> list = new ArrayList<String>(fileItems.length);
        try {
            for (FileItem item : fileItems) {
                String fileName = this.upload(item);
                list.add(fileName);
            }
        }
        catch (KDException e) {
            for (String url : list) {
                try {
                    this.physicalDelete(url);
                }
                catch (KDException e2) {
                    logger.error(e.getMessage(), (Throwable)e);
                    logger.error("Fail delete url when post error.", (Throwable)e2);
                }
            }
            throw e;
        }
        finally {
            this.closeFileStorageService();
        }
        return list;
    }

    @Override
    public void download(String path, OutputStream out, String userAgent) {
        InputStream inputStream = null;
        InputStream decodeStream = null;
        try {
            String oriPath = path = this.getValidFileName(path);
            path = this.getFileServiceExt().getRealPath(path);
            this.printPath("download1-getRealPath", oriPath, path);
            inputStream = this.fileStorageService.getInputStream(path, userAgent);
            decodeStream = this.getFileServiceExt().beforeWriteToResponse(path, inputStream, userAgent);
            IOUtils.copy((InputStream)decodeStream, (OutputStream)out);
        }
        catch (KDException e) {
            logger.error(DOWNLOAD_FILE + path + FAILED + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(DOWNLOAD_FILE + path + FAILED + e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{"error-" + e.getMessage() + FILENAME + path});
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (decodeStream != null) {
                    decodeStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void download(String path, HttpServletResponse servletResponse, String userAgent) {
        InputStream inputStream = null;
        InputStream decodeStream = null;
        try {
            String oriPath = path = this.getValidFileName(path);
            path = this.getFileServiceExt().getRealPath(path);
            this.printPath("download2-getRealPath", oriPath, path);
            ServletOutputStream outputStream = servletResponse.getOutputStream();
            inputStream = this.fileStorageService.getInputStream(path, userAgent);
            Map<String, Object> ret = this.getFileServiceExt().beforeWrite(path, inputStream, userAgent, new HashMap<String, Object>());
            decodeStream = (InputStream)ret.get("returnInputStream");
            if (FileServiceTenantConfig.DOWNLOAD_FILE_SIZE_DEF_ENABLE.getBooleanTenant()) {
                servletResponse.setHeader("Content-Length", String.valueOf(decodeStream.available()));
            }
            if (ret.get("fileSize") != null) {
                servletResponse.setHeader("Content-Length", (String)ret.get("fileSize"));
            }
            IOUtils.copy((InputStream)decodeStream, (OutputStream)outputStream);
            servletResponse.setStatus(200);
        }
        catch (KDException e) {
            logger.error(DOWNLOAD_FILE + path + FAILED + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(DOWNLOAD_FILE + path + FAILED + e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{"error-" + e.getMessage() + FILENAME + path});
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (decodeStream != null) {
                    decodeStream.close();
                }
            }
            catch (Exception exception) {}
            this.closeFileStorageService();
        }
    }

    @Override
    public Map<String, Object> download(String url, String userAgent, String ext) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            String oriUrl = url = this.getValidFileName(url);
            url = this.getFileServiceExt().getRealPath(url);
            this.printPath("download3-getRealPath", oriUrl, url);
            InputStream inputStream = this.fileStorageService.getInputStream(url, userAgent);
            InputStream decodeStream = this.getFileServiceExt().decode(url, inputStream);
            if ("txt".equalsIgnoreCase(ext)) {
                BufferedInputStream bfIn = new BufferedInputStream(decodeStream);
                bfIn.mark(0);
                String fileCharset = FileUtil.getFilecharset(bfIn);
                result.put(PreviewParams.CHARSET.getEnumName(), fileCharset);
                bfIn.reset();
                result.put(INPUT_STREAM, bfIn);
            } else {
                result.put(INPUT_STREAM, decodeStream);
            }
            result.put(STATUS_CODE, 200);
            return result;
        }
        catch (KDException e) {
            logger.error(DOWNLOAD_FILE + url + FAILED + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(DOWNLOAD_FILE + url + FAILED + e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{"error-" + e.getMessage() + FILENAME + url});
        }
    }

    @Override
    public InputStream download(String path, Map<String, String> header, Map<String, String> resHeader) {
        String ext = path.substring(path.lastIndexOf(46) + 1);
        try {
            String headerStr = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36";
            if (header != null && header.size() != 0) {
                headerStr = JSON.toJSONString(header);
            }
            String oriPath = path = this.getValidFileName(path);
            path = this.getFileServiceExt().getRealPath(path);
            this.printPath("download4-getRealPath", oriPath, path);
            InputStream inputStream = this.fileStorageService.getInputStream(path, headerStr);
            InputStream decodeStream = this.getFileServiceExt().decode(path, inputStream);
            InputStream tempIn = "txt".equalsIgnoreCase(ext) && !decodeStream.markSupported() ? new BufferedInputStream(decodeStream) : decodeStream;
            return tempIn;
        }
        catch (KDException e) {
            logger.error(DOWNLOAD_FILE + path + FAILED + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(DOWNLOAD_FILE + path + FAILED + e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{"error-" + e.getMessage() + FILENAME + path});
        }
    }

    @Override
    public InputStream getInputStream(String path) {
        try {
            String oriPath = path = this.getValidFileName(path);
            path = this.getFileServiceExt().getRealPath(path);
            this.printPath("getInputStream-getRealPath", oriPath, path);
            InputStream inputStream = this.fileStorageService.getInputStream(path, null);
            InputStream decodeStream = this.getFileServiceExt().decode(path, inputStream);
            return decodeStream;
        }
        catch (KDException e) {
            logger.error(DOWNLOAD_FILE + path + FAILED + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(DOWNLOAD_FILE + path + FAILED + e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{"error-" + e.getMessage() + FILENAME + path});
        }
    }

    @Override
    public void delete(String path) {
        if (RecycleBin.spiOpened()) {
            if (this.exists(path)) {
                try (InputStream in = this.getInputStream(path);){
                    String recyclePath = path.startsWith("/") ? RecycleBin.getCurrentDateRecyclePath() + path : RecycleBin.getCurrentDateRecyclePath() + "/" + path;
                    FileItem item = new FileItem("", recyclePath, in);
                    this.upload(item);
                }
                catch (IOException e) {
                    logger.error("Soft delete error, path: " + path, (Throwable)e);
                    throw new KDException((Throwable)e, BosErrorCode.deleteFailed, new Object[]{"error-" + e.getMessage() + FILENAME + path});
                }
                this.physicalDelete(path);
            }
        } else {
            this.physicalDelete(path);
        }
    }

    public void physicalDelete(String path) {
        try {
            String oriPath = path = this.getValidFileName(path);
            path = this.getFileServiceExt().getRealPath(path);
            this.printPath("delete-getRealPath", oriPath, path);
            this.fileStorageService.delete(path);
            this.getFileServiceExt().afterDeleteFile(path);
        }
        catch (KDException e) {
            logger.error("delete file " + path + FAILED + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("delete file " + path + FAILED + e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.deleteFailed, new Object[]{"error-" + e.getMessage() + FILENAME + path});
        }
        finally {
            this.closeFileStorageService();
        }
    }

    @Override
    public void batchDownload(BatchDownloadRequest request, OutputStream out, String userAgent) {
        ZipOutputStream zout = null;
        try {
            String encoding = System.getProperty("fileservice.batchdownload.encoding", "gbk");
            zout = new ZipOutputStream(out);
            zout.setEncoding(encoding);
            this.filesZip(request.getFiles(), zout, userAgent, "");
            this.DirsZip(request.getDirs(), zout, userAgent, "");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (zout != null) {
                try {
                    zout.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public void batchDownload(BatchDownloadRequest request, HttpServletResponse servletResponse, String userAgent) {
        ServletOutputStream out = null;
        try {
            out = servletResponse.getOutputStream();
            this.batchDownload(request, (OutputStream)out, userAgent);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[0]);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public List<String> getForbiddenExtensions() {
        try {
            List list = this.fileStorageService.getForbiddenExtensions();
            return list;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[0]);
        }
        finally {
            this.closeFileStorageService();
        }
    }

    @Override
    public List<String> getAllowExtensions() {
        try {
            List list = this.fileStorageService.getAllowExtensions();
            return list;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadExtentionNotAllowed, new Object[0]);
        }
        finally {
            this.closeFileStorageService();
        }
    }

    private void filesZip(BatchDownloadRequest.File[] files, ZipOutputStream out, String userAgent, String path) {
        if (files != null) {
            for (BatchDownloadRequest.File file : files) {
                if (file == null) continue;
                this.simpleFileZip(file, out, userAgent, path);
            }
        }
    }

    private void DirsZip(BatchDownloadRequest.Dir[] dirs, ZipOutputStream out, String userAgent, String path) {
        if (dirs != null) {
            for (BatchDownloadRequest.Dir dir : dirs) {
                this.simpleDirZip(dir, out, userAgent, path);
            }
        }
    }

    private void simpleDirZip(BatchDownloadRequest.Dir dir, ZipOutputStream out, String userAgent, String path) {
        String dirname = dir.getName();
        this.filesZip(dir.getFiles(), out, userAgent, "".equals(path) ? dirname : path + "/" + dirname);
        this.DirsZip(dir.getDirs(), out, userAgent, "".equals(path) ? dirname : path + "/" + dirname);
    }

    private void simpleFileZip(BatchDownloadRequest.File file, ZipOutputStream out, String userAgent, String path) {
        String entryName = file.getName();
        String url = file.getUrl();
        String oriUrl = url = this.getValidFileName(url);
        url = this.getFileServiceExt().getRealPath(url);
        this.printPath("simpleFileZip-getRealPath", oriUrl, url);
        InputStream in = null;
        InputStream decode = null;
        try {
            in = this.fileStorageService.getInputStream(url, userAgent);
            decode = this.getFileServiceExt().beforeWriteToResponse(url, in, userAgent);
            this.doZip(decode, out, path, entryName);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{url + ERROR});
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (decode != null) {
                    decode.close();
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    private void doZip(InputStream in, ZipOutputStream out, String dir, String entryName) throws IOException {
        if (!"".equals(dir)) {
            entryName = dir + "/" + entryName;
        }
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        int len = 0;
        byte[] buffer = new byte[8192];
        BufferedInputStream fis = new BufferedInputStream(in);
        while ((len = fis.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            out.flush();
        }
        out.closeEntry();
        fis.close();
    }

    public String getValidFileName(String name) {
        String validate = FileServiceFactory.getPropertyByTenant(VALIDATE_ENABLE);
        if (validate != null && !"".equals(validate)) {
            if (Boolean.parseBoolean(validate) && name.contains(" ")) {
                name = name.replace(" ", "");
            }
        } else if (name.contains(" ")) {
            name = name.replace(" ", "");
        }
        if (name.contains("//")) {
            name = name.replace("//", "/");
        }
        return name;
    }

    @Override
    public String getTicket() {
        try {
            return this.fileStorageService.getTicket();
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[0]);
        }
    }

    @Override
    public boolean exists(String path) {
        try {
            String oriPath = path;
            path = this.getFileServiceExt().getRealPath(path);
            this.printPath("exists-getRealPath", oriPath, path);
            return this.fileStorageService.exists(path);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("call FileServiceImpl#exist err found, path: %s", path)});
        }
    }

    @Override
    public long getFileSize(String path) {
        if (FileServiceTenantConfig.DOWNLOAD_EXT_DECIDE_ENABLE.getBooleanTenant()) {
            if (this.fileServiceType != null && this.fileServiceType.equals(FileServiceType.IMAGE.name())) {
                if (FileServiceExtFactory.hasImageFileServiceExt()) {
                    logger.info("has ext, return -1");
                    return -1L;
                }
            } else if (this.fileServiceType != null && this.fileServiceType.equals(FileServiceType.ATTACHMENT.name()) && FileServiceExtFactory.hasAttachFileServiceExt()) {
                logger.info("has ext, return -1");
                return -1L;
            }
        }
        try {
            String oriPath = path;
            path = this.getFileServiceExt().getRealPath(path);
            this.printPath("getFileSize-getRealPath", oriPath, path);
            return this.fileStorageService.getFileSize(path);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("call FileServiceImpl#getFileSize err found, path: %s", path)});
        }
    }

    @Override
    public String compressPicUpload(FileItem fileItem, long capacity) {
        return this.upload(fileItem);
    }

    @Override
    public Map<String, Object> preview(String fileName, String path, String userAgent) {
        return PreviewServiceFactory.getPreviewService(this).preview(fileName, path, userAgent);
    }

    @Override
    public void removePreview(String id) {
        PreviewServiceFactory.getPreviewService(this).removePreview(id);
    }

    @Override
    public Map<String, Object> previewFromCache(String fileName, String path, String userAgent, InputStream cacheIn) {
        return PreviewServiceFactory.getPreviewService(this).previewFromCache(fileName, path, userAgent, cacheIn);
    }

    @Override
    public Map<String, Object> previewWPS(String fileName, String path, String userAgent, Map<String, String> config) {
        return PreviewServiceFactory.getPreviewService(this).previewWPS(fileName, path, userAgent, config);
    }

    @Override
    public Map<String, Object> previewFromCacheWPS(String fileName, String path, String userAgent, InputStream cacheIn, Map<String, String> config) {
        return PreviewServiceFactory.getPreviewService(this).previewFromCacheWPS(fileName, path, userAgent, cacheIn, config);
    }

    @Override
    public void deletePreviewCacheWps(String id, Map<String, String> config) {
        PreviewServiceFactory.getPreviewService(this).deletePreviewCacheWps(id, config);
    }

    @Override
    public void deletePreviewWps(String path, Map<String, String> config) {
        PreviewServiceFactory.getPreviewService(this).deletePreviewWps(path, config);
    }

    @Override
    public FileServiceExt getFileServiceExt() {
        if (this.fileServiceType != null && this.fileServiceType.equals(FileServiceType.IMAGE.name())) {
            return FileServiceExtFactory.getImageFileServiceExt();
        }
        if (this.fileServiceType != null && this.fileServiceType.equals(FileServiceType.ATTACHMENT.name())) {
            return FileServiceExtFactory.getAttachFileServiceExt();
        }
        return FileServiceExtFactory.getDefaultFileServiceExt();
    }

    @Override
    public void checkServer(String url) {
        String tempPath = UUID.randomUUID().toString().replace("-", "") + ".png";
        this.exists(tempPath);
    }

    @Override
    public List<String> getFileServerList() {
        String fileServerHttpUrl = this.fileStorageConfig.getFileServerHttpUrl();
        return new ArrayList<String>(Collections.singleton(fileServerHttpUrl));
    }

    private void printPath(String action, String origin, String after) {
        if (Boolean.getBoolean("fileserviceimpl.log.enable")) {
            logger.info(String.format("action: %s, origin: %s, after: %s", action, origin, after));
        }
    }

    @SdkInternal
    public void decodeOutputStream(ByteArrayOutputStream tempOutput, OutputStream outputStream, String path) throws IOException {
        try (InputStream inputStream = this.getFileServiceExt().decode(path, new ByteArrayInputStream(tempOutput.toByteArray()));){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            tempOutput.close();
        }
    }
}

