/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.utils.TAUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class FilePathCheckUtil {
    public static final char ASTERISK_CHAR = '*';
    private static final String REGEX = "^(19|20)\\d\\d(0[1-9]|1[0-2])";
    private static final String TENANT_ID = "\\{TenantId}";
    private static final String ACCOUNT_ID = "\\{AccountId}";
    private static final String YEAR = "\\{Year}";
    private static final String MONTH = "\\{Month}";
    private static final String CHECK_ENABLE_KEY = "audit.fileservice.pathcheck.enable";
    private static final String RULE_WHITELIST_KEY = "audit.fileservice.pathcheck.rule.whitelist";
    private static final String DEFAULT_RULE_WHITELIST = "/tempfile/*,/previewcache/*,/rim/*";
    private static final String[] DEFAULT_WHITE_MOUDULES = new String[]{"printfile", "printtpl", "importfile", "exportfile", "reportExcel"};
    public static final String PATH_PREFIX = "/";
    private static final Log logger = LogFactory.getLog(FilePathCheckUtil.class);
    public static final String TRUE_STR = "true";
    public static final String EMPTY_STR = "";
    public static final String BOS_FILESERVICE_SDK = "bos-fileservice-sdk";

    public static boolean isEnable() {
        return TRUE_STR.equals(FilePathCheckUtil.getProperty(CHECK_ENABLE_KEY));
    }

    public static FilePathCheckInfo check(String path) {
        if (path.startsWith("//")) {
            path = path.substring(1);
        }
        if (!path.startsWith(PATH_PREFIX)) {
            path = PATH_PREFIX + path;
        }
        FilePathCheckInfo filePathCheckInfo = FilePathCheckUtil.checkStandardRule(path);
        return filePathCheckInfo;
    }

    private static FilePathCheckInfo checkStandardRule(String path) {
        boolean isLegal = true;
        String msg = EMPTY_STR;
        if (!StringUtils.isEmpty((String)path)) {
            String[] strArr = path.split(PATH_PREFIX);
            if (strArr.length < 4) {
                isLegal = false;
                msg = Resources.getString((String)"path\u76ee\u5f55\u5c42\u7ea7\u5c0f\u4e8e3\u7ea7\uff01", (String)"FilePathCheckUtil_1", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
            } else {
                String tenantId = TAUtil.getTenantId();
                String accountId = TAUtil.getAccountId();
                if (StringUtils.isEmpty((String)tenantId) || StringUtils.isEmpty((String)accountId)) {
                    isLegal = false;
                    msg = Resources.getString((String)"\u65e0\u6cd5\u4ece\u8bf7\u6c42\u4e0a\u4e0b\u6587\u4e2d\u83b7\u53d6\u5230\u79df\u6237ID\u548c\u6570\u636e\u4e2d\u5fc3ID\uff01", (String)"FilePathCheckUtil_2", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
                } else if (!strArr[1].equals(tenantId)) {
                    isLegal = false;
                    msg = Resources.getString((String)"\u79df\u6237ID\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"FilePathCheckUtil_3", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
                } else if (!strArr[2].equals(accountId)) {
                    isLegal = false;
                    msg = Resources.getString((String)"\u6570\u636e\u4e2d\u5fc3ID\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"FilePathCheckUtil_4", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
                } else if (!FilePathCheckUtil.isIegalDate(strArr[3]) && !FilePathCheckUtil.isWhiteMoudule(strArr[3])) {
                    isLegal = false;
                    msg = Resources.getString((String)"\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", (String)"FilePathCheckUtil_5", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
                }
            }
        } else {
            isLegal = false;
            msg = Resources.getString((String)"path\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"FilePathCheckUtil_6", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]);
        }
        return new FilePathCheckInfo(isLegal, msg);
    }

    private static boolean isIegalDate(String dateStr) {
        if (StringUtils.isEmpty((String)dateStr) || dateStr.length() < 6) {
            return false;
        }
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(dateStr);
        return matcher.find();
    }

    public static boolean isMatchWhiteRule(String path) {
        List<String> ruleWhitelist = FilePathCheckUtil.getRuleWhitelist();
        for (String rule : ruleWhitelist) {
            if (!FilePathCheckUtil.isMatch(path, rule)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhiteMoudule(String module) {
        boolean isWhiteMoudule = false;
        for (String str : DEFAULT_WHITE_MOUDULES) {
            if (!str.equals(module)) continue;
            isWhiteMoudule = true;
            break;
        }
        return isWhiteMoudule;
    }

    private static List<String> getRuleWhitelist() {
        ArrayList<String> whitelistRule = new ArrayList<String>(5);
        try {
            for (String rule : DEFAULT_RULE_WHITELIST.split(",")) {
                whitelistRule.add(rule);
            }
            String tenantId = TAUtil.getTenantId();
            String accountId = TAUtil.getAccountId();
            if (StringUtils.isEmpty((String)tenantId) || StringUtils.isEmpty((String)accountId)) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{Resources.getString((String)"\u65e0\u6cd5\u4ece\u8bf7\u6c42\u4e0a\u4e0b\u6587\u4e2d\u83b7\u53d6\u5230\u79df\u6237ID\u548c\u6570\u636e\u4e2d\u5fc3ID\uff01", (String)"FilePathCheckUtil_2", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0])});
            }
            Calendar calendar = Calendar.getInstance();
            String year = String.valueOf(calendar.get(1));
            int tempMonth = calendar.get(2) + 1;
            String month = tempMonth >= 10 ? String.valueOf(tempMonth) : "0" + tempMonth;
            try {
                String whitelistRuleStr = FilePathCheckUtil.getProperty(RULE_WHITELIST_KEY);
                if (!StringUtils.isEmpty((String)whitelistRuleStr)) {
                    for (String rule : whitelistRuleStr.split(",")) {
                        rule = rule.replaceAll(TENANT_ID, tenantId);
                        rule = rule.replaceAll(ACCOUNT_ID, accountId);
                        rule = rule.replaceAll(YEAR, year);
                        rule = rule.replaceAll(MONTH, month);
                        whitelistRule.add(rule);
                    }
                }
            }
            catch (Exception e) {
                logger.error("analyze mc whitelist audit.fileservice.pathcheck.rule.whitelist error!", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("analyze audit.fileservice.pathcheck.rule.whitelist error!", (Throwable)e);
        }
        return whitelistRule;
    }

    private static String getProperty(String key) {
        String tenantId = TAUtil.getTenantId();
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((String)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }

    private static boolean isMatch(String s, String p) {
        if (StringUtils.isEmpty((String)s) || StringUtils.isEmpty((String)p)) {
            return false;
        }
        int sn = s.length();
        int pn = p.length();
        int i = 0;
        int j = 0;
        int start = -1;
        int match = 0;
        while (i < sn) {
            if (j < pn && (s.charAt(i) == p.charAt(j) || p.charAt(j) == '?')) {
                ++i;
                ++j;
                continue;
            }
            if (j < pn && p.charAt(j) == '*') {
                start = j++;
                match = i;
                continue;
            }
            if (start != -1) {
                j = start + 1;
                i = ++match;
                continue;
            }
            return false;
        }
        while (j < pn) {
            if (p.charAt(j) != '*') {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static class FilePathCheckInfo {
        boolean isLegal;
        String msg;

        public FilePathCheckInfo(boolean isLegal, String msg) {
            this.isLegal = isLegal;
            this.msg = msg;
        }

        public boolean isLegal() {
            return this.isLegal;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

