/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;

public class FileTimeoutUtil {
    private static Log logger = LogFactory.getLog(FileTimeoutUtil.class);

    public static void removeFile(String file, InputStream in, long timeout) {
        new Thread(new Runner(file, in, timeout)).start();
    }

    static class Runner
    implements Runnable {
        private String path;
        private long timeout;
        private InputStream in;

        public Runner(String path, InputStream in, long timeout) {
            this.path = path;
            this.in = in;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            File file = new File(FileUtils.checkFileUrl((String)this.path));
            file.delete();
        }
    }
}

