/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.utils;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.excelpreview.ExcelPreviewFactory;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.resource.Resources;
import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    public static final String FILE_DELETE_FAIL = "file delete fail";
    public static final String UTF_8 = "UTF-8";
    private static FileService fileService;
    private static Log logger;
    private static final int DEFAULT_TRANS_UNIT = 1024;
    private static Set<String> picSuffixes;
    private static final String[] exts;

    public static String makeOutDatetime(Date date, int days) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(5, days);
        return new SimpleDateFormat(PreviewParams.Date_Formatter.getEnumName()).format(rightNow.getTime());
    }

    public static void savePreviewFile(String cachePath, String cacheFileName, long createTimeStamp, String id, InputStream in) throws IOException {
        FileItem fileItem = new FileItem(cacheFileName, cachePath, in);
        fileItem.setCreateNewFileWhenExists(true);
        try {
            fileService.upload(fileItem);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.uploadFailed, new Object[]{"save cacheFile failed in FileUtil:" + e});
        }
        String cacheFileCreateTime = cacheFileName.substring(0, cacheFileName.lastIndexOf(46)) + ".meta";
        File tempFile = File.createTempFile(cacheFileName.substring(0, cacheFileName.lastIndexOf(46)) + ".createTime", ".meta");
        String path = tempFile.getCanonicalPath();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            FileOutputStream out2 = new FileOutputStream(tempFile);
            Properties properties2 = new Properties();
            properties2.setProperty("id", id);
            properties2.setProperty("timestamp", Long.toString(createTimeStamp));
            properties2.setProperty("time", new SimpleDateFormat(PreviewParams.Date_Formatter.getEnumName()).format(new Date(createTimeStamp)));
            properties2.store(out2, "");
            FileInputStream idFile = new FileInputStream(tempFile.getCanonicalPath());
            String idsCachePath = cachePath.substring(0, cachePath.lastIndexOf(47) + 1) + cacheFileCreateTime;
            FileItem fileItem3 = new FileItem(cacheFileCreateTime, idsCachePath, idFile);
            fileItem3.setCreateNewFileWhenExists(true);
            try {
                fileService.upload(fileItem3);
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{"save cacheIdFile failed in FileUtil:" + e});
            }
            idFile.close();
            out2.close();
            File file2 = new File(path);
            if (file2.exists() && !file2.delete()) {
                logger.warn(FILE_DELETE_FAIL);
            }
        } else {
            FileOutputStream out = new FileOutputStream(tempFile);
            Properties properties = new Properties();
            properties.setProperty("createTimeStamp", Long.toString(createTimeStamp));
            properties.setProperty("createTime", new SimpleDateFormat(PreviewParams.Date_Formatter.getEnumName()).format(new Date(createTimeStamp)));
            properties.store(out, "");
            FileInputStream dateFile = new FileInputStream(tempFile.getCanonicalPath());
            String datesCachePath = cachePath.substring(0, cachePath.lastIndexOf(47) + 1) + cacheFileCreateTime;
            FileItem fileItem2 = new FileItem(cacheFileCreateTime, datesCachePath, dateFile);
            fileItem2.setCreateNewFileWhenExists(true);
            try {
                fileService.upload(fileItem2);
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{"save cacheDateFile failed in FileUtil:" + e});
            }
            dateFile.close();
            out.close();
            File file = new File(path);
            if (file.exists() && !file.delete()) {
                logger.warn(FILE_DELETE_FAIL);
            }
        }
    }

    public static String getId(String path) {
        InputStream in = null;
        String line = "";
        try {
            in = fileService.getInputStream(path);
            Properties properties = new Properties();
            properties.load(in);
            line = System.getProperty("id");
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, new Object[]{"get File content failed in FileUtil:" + e});
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFileToDisk(InputStream in, String fileName) throws IOException {
        String prefix = fileName.substring(0, fileName.lastIndexOf(46));
        String ext = fileName.substring(fileName.lastIndexOf(46));
        String uuid = UUID.randomUUID().toString().replace("-", "");
        File tempFile = File.createTempFile("previewcache_" + uuid, ext);
        String path = tempFile.getCanonicalPath();
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            int len = 0;
            while ((len = in.read()) != -1) {
                out.write(len);
            }
        }
        logger.debug(String.format("\u4e34\u65f6\u6587\u4ef6\u7684\u8def\u5f84\u4e3a%s", tempFile.getCanonicalPath()));
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getPreviewResult(InputStream in, String fileName, String cachePath, String cacheFileName, String id) {
        InputStream cacheIn = null;
        InputStream browserIn = null;
        Map<Object, Object> result = new HashMap();
        HashMap<String, Object> previewResult = new HashMap<String, Object>();
        String tmpfilePath = null;
        try {
            try {
                tmpfilePath = FileUtil.writeFileToDisk(in, fileName);
                cacheIn = new FileInputStream(tmpfilePath);
            }
            catch (Exception e) {
                File file;
                result = ExceptionUtil.setErrorInfo(Resources.getString((String)"\u4e91\u76d8\u8f6c\u6362\u6d41\u7f13\u5b58\u5230\u78c1\u76d8\u4e2d\u5931\u8d25:", (String)"FileUtil_0", (String)"bos-fileservice-sdk", (Object[])new Object[0]) + e);
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), result);
                HashMap<String, Object> hashMap = previewResult;
                try {
                    if (cacheIn != null) {
                        cacheIn.close();
                    }
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                }
                if (tmpfilePath != null && tmpfilePath.length() > 0 && (file = new File(tmpfilePath)).exists() && !file.delete()) {
                    logger.warn(FILE_DELETE_FAIL);
                }
                return hashMap;
            }
            try {
                FileUtil.savePreviewFile(cachePath, cacheFileName, new Date().getTime(), id, cacheIn);
            }
            catch (Exception e) {
                result = ExceptionUtil.setErrorInfo(Resources.getString((String)"pdf\u6d41\u7f13\u5b58\u5230\u6587\u4ef6\u670d\u52a1\u5668\u4e2d\u5931\u8d25:", (String)"FileUtil_1", (String)"bos-fileservice-sdk", (Object[])new Object[0]) + e);
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), result);
            }
            browserIn = fileService.getInputStream(cachePath);
            if (id != null) {
                result = ExcelPreviewFactory.getExcelPreview().preview(id, browserIn);
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.XLSX_SUCCESS.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), result);
            } else {
                previewResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.PDF_SUCCESS.getEnumName());
                previewResult.put(PreviewParams.RESULT.getEnumName(), browserIn);
            }
            HashMap<String, Object> hashMap = previewResult;
            return hashMap;
        }
        finally {
            File file;
            try {
                if (cacheIn != null) {
                    cacheIn.close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            if (tmpfilePath != null && tmpfilePath.length() > 0 && (file = new File(tmpfilePath)).exists() && !file.delete()) {
                logger.warn(FILE_DELETE_FAIL);
            }
        }
    }

    public static String getFilecharset(InputStream in) {
        String charset;
        block14: {
            charset = "GBK";
            byte[] first3Bytes = new byte[3];
            BufferedInputStream bfIn = new BufferedInputStream(in);
            try {
                boolean checked = false;
                bfIn.mark(0);
                int read = bfIn.read(first3Bytes, 0, 3);
                if (read == -1) {
                    return charset;
                }
                if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                    charset = "UTF-16LE";
                    checked = true;
                } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                    charset = "UTF-16BE";
                    checked = true;
                } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                    charset = UTF_8;
                    checked = true;
                }
                bfIn.reset();
                if (checked) break block14;
                int loc = 0;
                while ((read = bfIn.read()) != -1) {
                    ++loc;
                    if (read < 240 && (128 > read || read > 191)) {
                        if (192 <= read && read <= 223) {
                            read = bfIn.read();
                            if (128 <= read && read <= 191) {
                                continue;
                            }
                        } else {
                            if (224 > read || read > 239) continue;
                            read = bfIn.read();
                            if (128 <= read && read <= 191 && 128 <= (read = bfIn.read()) && read <= 191) {
                                charset = UTF_8;
                            }
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return charset;
    }

    public static String getFilecharsetNew(InputStream in) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        InputStream inputStream = null;
        inputStream = in.markSupported() ? in : new BufferedInputStream(in);
        try {
            boolean checked = false;
            inputStream.mark(Integer.MAX_VALUE);
            int read = inputStream.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = UTF_8;
                checked = true;
            }
            if (!checked) {
                inputStream.reset();
                int loc = 0;
                while ((read = inputStream.read()) != -1) {
                    ++loc;
                    if (read >= 240 || 128 <= read && read <= 191) break;
                    if (192 <= read && read <= 223) {
                        read = inputStream.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = inputStream.read();
                    if (128 > read || read > 191 || 128 > (read = inputStream.read()) || read > 191) break;
                    charset = UTF_8;
                    break;
                }
            }
            inputStream.reset();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return charset;
    }

    public static boolean isExtExist(String targetExt) {
        for (String ext : exts) {
            if (!ext.equalsIgnoreCase(targetExt)) continue;
            return true;
        }
        return false;
    }

    public static InputStream compressPic(String fileName, InputStream srcImgInputStream, long capacity) {
        ByteArrayInputStream resultBais;
        if (srcImgInputStream == null) {
            throw new KDException(BosErrorCode.paramError, new Object[]{"compressPic srcImgInputStream is null"});
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (!picSuffixes.contains(suffix)) {
            logger.error(fileName + " is not pic suffix, fileName: " + fileName);
            return srcImgInputStream;
        }
        try {
            byte[] byt = FileUtil.calRotateImage2Bytes(srcImgInputStream, suffix);
            long imgSize = byt.length;
            while (imgSize > capacity * 1024L) {
                ByteArrayInputStream bais = new ByteArrayInputStream(byt);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedImage bufferedImage = ImageIO.read(bais);
                double rate = Math.sqrt((double)(capacity * 1024L) / (double)imgSize);
                int newWidth = (int)((double)bufferedImage.getWidth() * rate);
                int newHeight = (int)((double)bufferedImage.getHeight() * rate);
                int imageType = "png".equalsIgnoreCase(suffix) ? 2 : 1;
                BufferedImage compressImg = new BufferedImage(newWidth, newHeight, imageType);
                compressImg.getGraphics().drawImage(bufferedImage, 0, 0, newWidth, newHeight, null);
                ImageIO.write((RenderedImage)compressImg, suffix, baos);
                byt = baos.toByteArray();
                baos.close();
                bais.close();
                imgSize = byt.length;
            }
            resultBais = new ByteArrayInputStream(byt);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"compress pic failed: " + fileName});
        }
        return resultBais;
    }

    /*
     * Exception decompiling
     */
    private static byte[] calRotateImage2Bytes(InputStream srcImgInputStream, String suffix) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Rectangle calcRotatedRectangle(Rectangle rectangle, double rotateByOrientation) {
        if (rotateByOrientation >= 90.0) {
            if (rotateByOrientation / 90.0 % 2.0 == 1.0) {
                int temp = rectangle.height;
                rectangle.height = rectangle.width;
                rectangle.width = temp;
            }
            rotateByOrientation %= 90.0;
        }
        double r = Math.sqrt(rectangle.height * rectangle.height + rectangle.width * rectangle.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(rotateByOrientation) / 2.0) * r;
        double angelAlpha = (Math.PI - Math.toRadians(rotateByOrientation)) / 2.0;
        double angelDataWidth = Math.atan((double)rectangle.height / (double)rectangle.width);
        double angelDataHeight = Math.atan((double)rectangle.width / (double)rectangle.height);
        int len_data_width = (int)(len * Math.cos(Math.PI - angelAlpha - angelDataWidth));
        int len_data_height = (int)(len * Math.cos(Math.PI - angelAlpha - angelDataHeight));
        int desWidth = rectangle.width + len_data_width * 2;
        int desHeight = rectangle.height + len_data_height * 2;
        return new Rectangle(new Dimension(desWidth, desHeight));
    }

    static {
        picSuffixes = new HashSet<String>();
        exts = new String[]{"jpg", "jpeg", "gif", "bmp", "png", "dib", "rle", "emf", "jpe", "pcx", "dcx", "pic", "tga", "tif", "wmf", "jfif", "pdf", "pptx", "ppt", "doc", "docx", "xls", "xlsx", "txt"};
        picSuffixes.addAll(Arrays.asList("jpg,jpeg,png,gif,bmp,tiff,tga,ico,dib,rle,emf,jpe,jfif,pcx,pic,tif,wmf,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,hdri,ai,raw".split(",")));
        fileService = FileServiceFactory.getAttachmentFileService();
        logger = LogFactory.getLog(FileUtil.class);
    }
}

