/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import java.awt.AlphaComposite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import kd.bos.fileservice.enums.WatermarkType;
import kd.bos.fileservice.watermark.ImageWatermarkHandler;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GifImageWatermarkHandler
extends ImageWatermarkHandler {
    private static final Log logger = LogFactory.getLog(GifImageWatermarkHandler.class);

    @Override
    public void watermarkTxt(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        boolean success = this.watermarkGif(outputStream, inputStream, watermarkParameter);
        if (!success) {
            return;
        }
        logger.debug("GifImageWatermarkHandler.watermarkTxt success");
    }

    @Override
    public void watermarkImg(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        boolean success = this.watermarkGif(outputStream, inputStream, watermarkParameter);
        if (!success) {
            return;
        }
        logger.debug("GifImageWatermarkHandler.watermarkImg success");
    }

    @Override
    public void watermarkUpImgUnderTxt(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        boolean success = this.watermarkGif(outputStream, inputStream, watermarkParameter);
        if (!success) {
            return;
        }
        logger.debug("GifImageWatermarkHandler.watermarkUpImgUnderTxt success");
    }

    @Override
    public void watermarkLeftImgRightTxt(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        boolean success = this.watermarkGif(outputStream, inputStream, watermarkParameter);
        if (!success) {
            return;
        }
        logger.debug("GifImageWatermarkHandler.watermarkLeftImgRightTxt success");
    }

    private boolean watermarkGif(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        Integer type = watermarkParameter.getType();
        Image watermarkImg = null;
        if (type.intValue() == WatermarkType.IMG.ordinal() || type.intValue() == WatermarkType.UP_IMG_UNDER_TEXT.ordinal() || type.intValue() == WatermarkType.LEFT_IMG_RIGHT_TEXT.ordinal()) {
            byte[] imgBytes = IOUtils.toByteArray((InputStream)watermarkParameter.getImage());
            if (imgBytes.length > 0xA00000) {
                logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
                return false;
            }
            watermarkImg = new ImageIcon(imgBytes).getImage();
        }
        ImageReader reader = ImageIO.getImageReadersBySuffix("gif").next();
        reader.setInput(ImageIO.createImageInputStream(inputStream));
        ImageWriter writer = ImageIO.getImageWriter(reader);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        writer.setOutput(imageOutputStream);
        writer.prepareWriteSequence(null);
        int frameCount = reader.getNumImages(true);
        int firstFrameHeight = 0;
        int firstFrameWidth = 0;
        for (int i = 0; i < frameCount; ++i) {
            BufferedImage frame = reader.read(i);
            if (i == 0) {
                firstFrameHeight = frame.getHeight();
                firstFrameWidth = frame.getWidth();
            }
            IIOMetadata metadata = reader.getImageMetadata(i);
            Node tree = metadata.getAsTree("javax_imageio_gif_image_1.0");
            NodeList children = tree.getChildNodes();
            int imageLeftPosition = 0;
            int imageTopPosition = 0;
            for (int j = 0; j < children.getLength(); ++j) {
                Node node = children.item(j);
                if (!node.getNodeName().equals("ImageDescriptor")) continue;
                NamedNodeMap map = node.getAttributes();
                imageLeftPosition = Integer.parseInt(map.getNamedItem("imageLeftPosition").getNodeValue());
                imageTopPosition = Integer.parseInt(map.getNamedItem("imageTopPosition").getNodeValue());
                break;
            }
            Graphics2D g = frame.createGraphics();
            this.drawWatermark(watermarkImg, watermarkParameter, g, firstFrameWidth, firstFrameHeight, imageLeftPosition, imageTopPosition);
            writer.writeToSequence(new IIOImage(frame, null, metadata), null);
        }
        writer.endWriteSequence();
        reader.dispose();
        writer.dispose();
        imageOutputStream.flush();
        return true;
    }

    private void drawWatermark(Image watermarkImg, WatermarkParameter watermarkParameter, Graphics2D g, int firstFrameWidth, int firstFrameHeight, int imageLeftPosition, int imageTopPosition) {
        Integer type = watermarkParameter.getType();
        if (type.intValue() == WatermarkType.TEXT.ordinal()) {
            this.drawWatermarkTxt(watermarkParameter, g, firstFrameWidth, firstFrameHeight, imageLeftPosition, imageTopPosition);
        } else if (type.intValue() == WatermarkType.IMG.ordinal()) {
            this.drawWatermarkImg(watermarkImg, watermarkParameter, g, firstFrameWidth, firstFrameHeight, imageLeftPosition, imageTopPosition);
        } else if (type.intValue() == WatermarkType.UP_IMG_UNDER_TEXT.ordinal()) {
            this.drawWatermarkUpImgUnderTxt(watermarkImg, watermarkParameter, g, firstFrameWidth, firstFrameHeight, imageLeftPosition, imageTopPosition);
        } else if (type.intValue() == WatermarkType.LEFT_IMG_RIGHT_TEXT.ordinal()) {
            this.drawWatermarkLeftImgRightTxt(watermarkImg, watermarkParameter, g, firstFrameWidth, firstFrameHeight, imageLeftPosition, imageTopPosition);
        }
    }

    private void drawWatermarkTxt(WatermarkParameter watermarkParameter, Graphics2D g, int firstFrameWidth, int firstFrameHeight, int imageLeftPosition, int imageTopPosition) {
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        String text = watermarkParameter.getText();
        String position = watermarkParameter.getPosition();
        ImageWatermarkHandler.BeginPoint beginPoint = new ImageWatermarkHandler.BeginPoint(position, firstFrameWidth, firstFrameHeight, frameWidth, frameHeight).invoke();
        if (beginPoint.getX() == -1 && beginPoint.getY() == -1) {
            BufferedImage watermark = this.createTxtWatermark(watermarkParameter);
            for (int x = X1; x < firstFrameWidth; x += frameWidth) {
                for (int y = Y1; y < firstFrameHeight; y += frameHeight) {
                    g.drawImage(watermark, x - imageLeftPosition, y - imageTopPosition, frameWidth, frameHeight, null);
                }
            }
        } else {
            g.drawString(text, beginPoint.getX(), beginPoint.getY());
        }
        g.dispose();
    }

    private void drawWatermarkImg(Image watermarkImg, WatermarkParameter watermarkParameter, Graphics2D g, int firstFrameWidth, int firstFrameHeight, int imageLeftPosition, int imageTopPosition) {
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        String text = watermarkParameter.getText();
        String position = watermarkParameter.getPosition();
        ImageWatermarkHandler.BeginPoint beginPoint = new ImageWatermarkHandler.BeginPoint(position, firstFrameWidth, firstFrameHeight, frameWidth, frameHeight).invoke();
        if (beginPoint.getX() == -1 && beginPoint.getY() == -1) {
            BufferedImage watermark = this.createImgWatermark(watermarkParameter, watermarkImg);
            for (int x = X1; x < firstFrameWidth; x += frameWidth) {
                for (int y = Y1; y < firstFrameHeight; y += frameHeight) {
                    g.drawImage(watermark, x - imageLeftPosition, y - imageTopPosition, frameWidth, frameHeight, null);
                }
            }
        } else {
            int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
            g.drawImage(watermarkImg, beginPoint.getX(), beginPoint.getY(), imageHeight, 50, null);
        }
        g.setComposite(AlphaComposite.getInstance(3));
        g.dispose();
    }

    private void drawWatermarkLeftImgRightTxt(Image watermarkImg, WatermarkParameter watermarkParameter, Graphics2D g, int firstFrameWidth, int firstFrameHeight, int imageLeftPosition, int imageTopPosition) {
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        String text = watermarkParameter.getText();
        String position = watermarkParameter.getPosition();
        ImageWatermarkHandler.BeginPoint beginPoint = new ImageWatermarkHandler.BeginPoint(position, firstFrameWidth, firstFrameHeight, frameWidth, frameHeight).invoke();
        if (beginPoint.getX() == -1 && beginPoint.getY() == -1) {
            BufferedImage watermark = this.createLeftRightWatermark(watermarkParameter, watermarkImg);
            for (int x = X1; x < firstFrameWidth; x += frameWidth) {
                for (int y = Y1; y < firstFrameHeight; y += frameHeight) {
                    g.drawImage(watermark, x - imageLeftPosition, y - imageTopPosition, frameWidth, frameHeight, null);
                }
            }
        } else {
            int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
            JLabel label = new JLabel();
            label.setText(text);
            FontMetrics metrics = label.getFontMetrics(label.getFont());
            int textHeight = metrics.getHeight();
            g.drawImage(watermarkImg, beginPoint.getX(), beginPoint.getY(), 50, imageHeight, null);
            g.drawString(text, beginPoint.getX() + 50 + 5, beginPoint.getY() + (textHeight + imageHeight) / 2 + 5);
        }
        g.dispose();
    }

    private void drawWatermarkUpImgUnderTxt(Image watermarkImg, WatermarkParameter watermarkParameter, Graphics2D g, int firstFrameWidth, int firstFrameHeight, int imageLeftPosition, int imageTopPosition) {
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        String text = watermarkParameter.getText();
        String position = watermarkParameter.getPosition();
        ImageWatermarkHandler.BeginPoint beginPoint = new ImageWatermarkHandler.BeginPoint(position, firstFrameWidth, firstFrameHeight, frameWidth, frameHeight).invoke();
        if (beginPoint.getX() == -1 && beginPoint.getY() == -1) {
            BufferedImage watermark = this.createUpUnderWatermark(watermarkParameter, watermarkImg);
            for (int x = X1; x < firstFrameWidth; x += frameWidth) {
                for (int y = Y1; y < firstFrameHeight; y += frameHeight) {
                    g.drawImage(watermark, x, y, frameWidth, frameHeight, null);
                }
            }
        } else {
            int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
            g.drawImage(watermarkImg, beginPoint.getX(), beginPoint.getY(), imageHeight, 50, null);
            g.drawString(watermarkParameter.getText(), beginPoint.getX(), beginPoint.getY() + imageHeight + 5);
        }
        g.dispose();
    }
}

