/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import kd.bos.fileservice.config.FileServiceConfig;
import kd.bos.fileservice.watermark.ExcelWatermarkHandler;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;

public class ImageWatermarkHandler
implements IWatermarkHandler {
    private static final Log logger = LogFactory.getLog(ImageWatermarkHandler.class);
    protected static final int IMAGE_WIDTH = 50;
    protected static Font font;

    @Override
    public void watermarkTxt(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int screenWidth = watermarkParameter.getStyle().getResolution().getWidth();
        int srcSize = inputStream.available();
        BufferedImage srcImg = ImageIO.read(inputStream);
        int srcWidth = srcImg.getWidth(null);
        int srcHeight = srcImg.getHeight(null);
        BeginPoint beginPoint = new BeginPoint(watermarkParameter.getPosition(), srcWidth, srcHeight, frameWidth, frameHeight).invoke();
        BufferedImage resultImg = new BufferedImage(srcWidth, srcHeight, 2);
        Graphics2D g = resultImg.createGraphics();
        g.drawImage(srcImg, 0, 0, srcWidth, srcHeight, null);
        if (beginPoint.getX() == -1 && beginPoint.getY() == -1) {
            BufferedImage watermark;
            BufferedImage scaledWatermark = watermark = this.createTxtWatermark(watermarkParameter);
            if (watermarkParameter.getStyle().isScale()) {
                scaledWatermark = this.getScaledWatermark(watermark, srcWidth, frameWidth, screenWidth);
            }
            int scaledWidth = scaledWatermark.getWidth();
            int scaledHeight = scaledWatermark.getHeight();
            for (int x = X1; x < srcWidth; x += scaledWidth) {
                for (int y = Y1; y < srcHeight; y += scaledHeight) {
                    g.drawImage(scaledWatermark, x, y, scaledWidth, scaledHeight, null);
                }
            }
        } else {
            g.drawString(watermarkParameter.getText(), beginPoint.getX(), beginPoint.getY());
        }
        g.dispose();
        logger.debug("draw cost: " + (System.currentTimeMillis() - startTime) + " ms");
        startTime = System.currentTimeMillis();
        if (watermarkParameter.getCompress().booleanValue() && FileServiceConfig.WATERMARK_OPT_IMAGE_COMPRESS_ENABLE.getBoolean()) {
            ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
            this.outputResult(srcWidth, srcHeight, resultImg, tempOutput);
            ByteArrayInputStream tempInput = new ByteArrayInputStream(tempOutput.toByteArray());
            int retSize = tempInput.available();
            BufferedImage tempResult = ImageIO.read(tempInput);
            this.outputResult2(srcSize, retSize, tempResult, outputStream);
        } else {
            ImageIO.write((RenderedImage)resultImg, "png", outputStream);
        }
        logger.debug("output cost: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    private BufferedImage getScaledWatermark(BufferedImage watermark, int srcWidth, int frameWidth, int screenWidth) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((BufferedImage[])new BufferedImage[]{watermark}).scale(this.calculateScale(srcWidth, frameWidth, screenWidth)).outputFormat("png").toOutputStream((OutputStream)out);
        return ImageIO.read(new ByteArrayInputStream(out.toByteArray()));
    }

    private double calculateScale(int srcWidth, int frameWidth, int screenWidth) {
        BigDecimal magic = BigDecimal.valueOf(screenWidth).divide(BigDecimal.valueOf(frameWidth), 2, RoundingMode.HALF_DOWN).divide(BigDecimal.valueOf(1.6506), 2, RoundingMode.HALF_DOWN);
        BigDecimal d = BigDecimal.valueOf(srcWidth).divide(BigDecimal.valueOf(frameWidth), 2, RoundingMode.HALF_DOWN);
        return d.divide(magic, 2, RoundingMode.HALF_DOWN).doubleValue();
    }

    private void outputResult(int srcWidth, int srcHeight, BufferedImage resultImg, OutputStream outputStream) throws IOException {
        double scale = 1.0;
        int calcLength = Math.max(srcWidth, srcHeight);
        int HD_1080p = 1920;
        int QHD_2k = 2560;
        int UHD_4k = 3840;
        if (calcLength > QHD_2k) {
            scale = BigDecimal.valueOf(HD_1080p).divide(BigDecimal.valueOf(calcLength), 2, RoundingMode.HALF_UP).doubleValue();
        }
        if (calcLength > UHD_4k) {
            scale = BigDecimal.valueOf(QHD_2k).divide(BigDecimal.valueOf(calcLength), 2, RoundingMode.HALF_UP).doubleValue();
        }
        Thumbnails.of((BufferedImage[])new BufferedImage[]{resultImg}).scale(scale).outputFormat("png").toOutputStream(outputStream);
    }

    private void outputResult2(int srcL, int result, BufferedImage resultImg, OutputStream outputStream) throws IOException {
        int SIZE_3M = 0x300000;
        int SIZE_300K = 307200;
        int i = BigDecimal.valueOf(result).divide(BigDecimal.valueOf(srcL), 2, RoundingMode.HALF_UP).intValue();
        if (i >= 10 && srcL > SIZE_300K && result > SIZE_3M) {
            Thumbnails.of((BufferedImage[])new BufferedImage[]{resultImg}).scale(0.2).outputFormat("png").toOutputStream(outputStream);
        } else if (i >= 5 && srcL > SIZE_300K && result > SIZE_3M) {
            Thumbnails.of((BufferedImage[])new BufferedImage[]{resultImg}).scale(0.4).outputFormat("png").toOutputStream(outputStream);
        } else if (i >= 3 && srcL > SIZE_300K && result > SIZE_3M) {
            Thumbnails.of((BufferedImage[])new BufferedImage[]{resultImg}).scale(0.6).outputFormat("png").toOutputStream(outputStream);
        } else {
            ImageIO.write((RenderedImage)resultImg, "png", outputStream);
        }
    }

    @Override
    public void watermarkImg(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int screenWidth = watermarkParameter.getStyle().getResolution().getWidth();
        int srcSize = inputStream.available();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)watermarkParameter.getImage());
        if (imgBytes.length > 0xA00000) {
            logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
            return;
        }
        Image watermarkImg = new ImageIcon(imgBytes).getImage();
        BufferedImage srcImg = ImageIO.read(inputStream);
        int srcWidth = srcImg.getWidth(null);
        int srcHeight = srcImg.getHeight(null);
        BufferedImage resultImg = new BufferedImage(srcWidth, srcHeight, 2);
        Graphics2D g = resultImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(srcImg.getScaledInstance(srcWidth, srcHeight, 4), 0, 0, null);
        BeginPoint beginPoint = new BeginPoint(watermarkParameter.getPosition(), srcWidth, srcHeight, frameWidth, frameHeight).invoke();
        if (beginPoint.getX() == -1 && beginPoint.getY() == -1) {
            BufferedImage watermark;
            BufferedImage scaledWatermark = watermark = this.createImgWatermark(watermarkParameter, watermarkImg);
            if (watermarkParameter.getStyle().isScale()) {
                scaledWatermark = this.getScaledWatermark(watermark, srcWidth, frameWidth, screenWidth);
            }
            int scaledWidth = scaledWatermark.getWidth();
            int scaledHeight = scaledWatermark.getHeight();
            for (int x = X1; x < srcWidth; x += scaledWidth) {
                for (int y = Y1; y < srcHeight; y += scaledHeight) {
                    g.drawImage(scaledWatermark, x, y, scaledWidth, scaledHeight, null);
                }
            }
        } else {
            int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
            g.drawImage(watermarkImg, beginPoint.getX(), beginPoint.getY(), imageHeight, 50, null);
        }
        g.setComposite(AlphaComposite.getInstance(3));
        g.dispose();
        logger.debug("draw cost: " + (System.currentTimeMillis() - startTime) + " ms");
        if (watermarkParameter.getCompress().booleanValue() && FileServiceConfig.WATERMARK_OPT_IMAGE_COMPRESS_ENABLE.getBoolean()) {
            ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
            this.outputResult(srcWidth, srcHeight, resultImg, tempOutput);
            ByteArrayInputStream tempInput = new ByteArrayInputStream(tempOutput.toByteArray());
            int retSize = tempInput.available();
            BufferedImage tempResult = ImageIO.read(tempInput);
            this.outputResult2(srcSize, retSize, tempResult, outputStream);
        } else {
            ImageIO.write((RenderedImage)resultImg, "png", outputStream);
        }
        logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    @Override
    public void watermarkUpImgUnderTxt(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int screenWidth = watermarkParameter.getStyle().getResolution().getWidth();
        int srcSize = inputStream.available();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)watermarkParameter.getImage());
        if (imgBytes.length > 0xA00000) {
            logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
            return;
        }
        Image watermarkImg = new ImageIcon(imgBytes).getImage();
        BufferedImage srcImg = ImageIO.read(inputStream);
        int srcWidth = srcImg.getWidth(null);
        int srcHeight = srcImg.getHeight(null);
        BufferedImage resultImg = new BufferedImage(srcWidth, srcHeight, 2);
        Graphics2D g = resultImg.createGraphics();
        g.drawImage(srcImg, 0, 0, srcWidth, srcHeight, null);
        BeginPoint beginPoint = new BeginPoint(watermarkParameter.getPosition(), srcWidth, srcHeight, frameWidth, frameHeight).invoke();
        if (beginPoint.getX() == -1 && beginPoint.getY() == -1) {
            BufferedImage watermark;
            BufferedImage scaledWatermark = watermark = this.createUpUnderWatermark(watermarkParameter, watermarkImg);
            if (watermarkParameter.getStyle().isScale()) {
                scaledWatermark = this.getScaledWatermark(watermark, srcWidth, frameWidth, screenWidth);
            }
            int scaledWidth = scaledWatermark.getWidth();
            int scaledHeight = scaledWatermark.getHeight();
            for (int x = X1; x < srcWidth; x += scaledWidth) {
                for (int y = Y1; y < srcHeight; y += scaledHeight) {
                    g.drawImage(scaledWatermark, x, y, scaledWidth, scaledHeight, null);
                }
            }
        } else {
            int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
            g.drawImage(watermarkImg, beginPoint.getX(), beginPoint.getY(), imageHeight, 50, null);
            g.drawString(watermarkParameter.getText(), beginPoint.getX(), beginPoint.getY() + imageHeight + 5);
        }
        g.dispose();
        logger.debug("draw cost: " + (System.currentTimeMillis() - startTime) + " ms");
        if (watermarkParameter.getCompress().booleanValue() && FileServiceConfig.WATERMARK_OPT_IMAGE_COMPRESS_ENABLE.getBoolean()) {
            ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
            this.outputResult(srcWidth, srcHeight, resultImg, tempOutput);
            ByteArrayInputStream tempInput = new ByteArrayInputStream(tempOutput.toByteArray());
            int retSize = tempInput.available();
            BufferedImage tempResult = ImageIO.read(tempInput);
            this.outputResult2(srcSize, retSize, tempResult, outputStream);
        } else {
            ImageIO.write((RenderedImage)resultImg, "png", outputStream);
        }
        logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    @Override
    public void watermarkLeftImgRightTxt(OutputStream outputStream, InputStream inputStream, WatermarkParameter watermarkParameter) throws IOException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int screenWidth = watermarkParameter.getStyle().getResolution().getWidth();
        int srcSize = inputStream.available();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)watermarkParameter.getImage());
        if (imgBytes.length > 0xA00000) {
            logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
            return;
        }
        Image watermarkImg = new ImageIcon(imgBytes).getImage();
        BufferedImage srcImg = ImageIO.read(inputStream);
        int srcWidth = srcImg.getWidth(null);
        int srcHeight = srcImg.getHeight(null);
        BufferedImage resultImg = new BufferedImage(srcWidth, srcHeight, 2);
        Graphics2D g = resultImg.createGraphics();
        g.drawImage(srcImg, 0, 0, srcWidth, srcHeight, null);
        BeginPoint beginPoint = new BeginPoint(watermarkParameter.getPosition(), srcWidth, srcHeight, frameWidth, frameHeight).invoke();
        if (beginPoint.getX() == -1 && beginPoint.getY() == -1) {
            BufferedImage watermark;
            BufferedImage scaledWatermark = watermark = this.createLeftRightWatermark(watermarkParameter, watermarkImg);
            if (watermarkParameter.getStyle().isScale()) {
                scaledWatermark = this.getScaledWatermark(watermark, srcWidth, frameWidth, screenWidth);
            }
            int scaledWidth = scaledWatermark.getWidth();
            int scaledHeight = scaledWatermark.getHeight();
            for (int x = X1; x < srcWidth; x += scaledWidth) {
                for (int y = Y1; y < srcHeight; y += scaledHeight) {
                    g.drawImage(scaledWatermark, x, y, scaledWidth, scaledHeight, null);
                }
            }
        } else {
            String text = watermarkParameter.getText();
            int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
            JLabel label = new JLabel();
            label.setText(text);
            FontMetrics metrics = label.getFontMetrics(label.getFont());
            int textHeight = metrics.getHeight();
            g.drawImage(watermarkImg, beginPoint.getX(), beginPoint.getY(), 50, imageHeight, null);
            g.drawString(text, beginPoint.getX() + 50 + 5, beginPoint.getY() + (textHeight + imageHeight) / 2 + 5);
        }
        g.dispose();
        logger.debug("draw cost: " + (System.currentTimeMillis() - startTime) + " ms");
        if (watermarkParameter.getCompress().booleanValue() && FileServiceConfig.WATERMARK_OPT_IMAGE_COMPRESS_ENABLE.getBoolean()) {
            ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
            this.outputResult(srcWidth, srcHeight, resultImg, tempOutput);
            ByteArrayInputStream tempInput = new ByteArrayInputStream(tempOutput.toByteArray());
            int retSize = tempInput.available();
            BufferedImage tempResult = ImageIO.read(tempInput);
            this.outputResult2(srcSize, retSize, tempResult, outputStream);
        } else {
            ImageIO.write((RenderedImage)resultImg, "png", outputStream);
        }
        logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
    }

    protected BufferedImage createTxtWatermark(WatermarkParameter watermarkParameter) {
        String s;
        int i;
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        String text = watermarkParameter.getText();
        int fontSize = watermarkParameter.getSize();
        if (text == null || text.equals("")) {
            return null;
        }
        String[] texts = this.splitNewline(text);
        BufferedImage bufImg = new BufferedImage(frameWidth, frameHeight, 2);
        Graphics2D g = bufImg.createGraphics();
        this.initGraphics(watermarkParameter, g);
        for (i = 0; i < texts.length; ++i) {
            s = texts[i];
            g.drawString(s, X1, Y1 + i * fontSize);
        }
        this.reRotateGraphics(g, watermarkParameter);
        for (i = 0; i < texts.length; ++i) {
            s = texts[i];
            g.drawString(s, X2, Y2 + i * fontSize);
        }
        g.dispose();
        return bufImg;
    }

    protected BufferedImage createImgWatermark(WatermarkParameter watermarkParameter, Image watermarkImg) {
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
        BufferedImage bufImg = new BufferedImage(frameWidth, frameHeight, 2);
        Graphics2D g = bufImg.createGraphics();
        this.initGraphics(watermarkParameter, g);
        g.drawImage(watermarkImg, X1, Y1, 50, imageHeight, null);
        this.reRotateGraphics(g, watermarkParameter);
        g.drawImage(watermarkImg, X2, Y2, 50, imageHeight, null);
        g.dispose();
        return bufImg;
    }

    protected BufferedImage createLeftRightWatermark(WatermarkParameter watermarkParameter, Image watermarkImg) {
        int i;
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        String text = watermarkParameter.getText();
        int fontSize = watermarkParameter.getSize();
        if (text == null || text.equals("")) {
            return null;
        }
        String[] texts = this.splitNewline(text);
        int newLineCenterOffset = (int)((double)(texts.length - 2) * 0.5 * (double)fontSize);
        int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
        BufferedImage bufImg = new BufferedImage(frameWidth, frameHeight, 2);
        Graphics2D g = bufImg.createGraphics();
        this.initGraphics(watermarkParameter, g);
        g.drawImage(watermarkImg, X1, Y1, 50, imageHeight, null);
        for (i = 0; i < texts.length; ++i) {
            int x = X1 + 50 + 5;
            int y = Y1 + imageHeight / 2 - fontSize / 2 - newLineCenterOffset;
            g.drawString(texts[i], x, y + i * fontSize);
        }
        this.reRotateGraphics(g, watermarkParameter);
        g.drawImage(watermarkImg, X2, Y2, 50, imageHeight, null);
        for (i = 0; i < texts.length; ++i) {
            int x2 = X2 + 50 + 5;
            int y2 = Y2 + imageHeight / 2 - fontSize / 2 - newLineCenterOffset;
            g.drawString(texts[i], x2, y2 + i * fontSize);
        }
        g.dispose();
        return bufImg;
    }

    protected BufferedImage createUpUnderWatermark(WatermarkParameter watermarkParameter, Image watermarkImg) {
        String s;
        int i;
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        String text = watermarkParameter.getText();
        int fontSize = watermarkParameter.getSize();
        if (text == null || text.equals("")) {
            return null;
        }
        String[] texts = this.splitNewline(text);
        int imageHeight = (int)this.calImageHeight(watermarkImg.getWidth(null), watermarkImg.getHeight(null), 50.0);
        JLabel label = new JLabel();
        label.setText(watermarkParameter.getText());
        FontMetrics metrics = label.getFontMetrics(label.getFont());
        int textHeight = metrics.getHeight();
        BufferedImage bufImg = new BufferedImage(frameWidth, frameHeight, 2);
        Graphics2D g = bufImg.createGraphics();
        this.initGraphics(watermarkParameter, g);
        g.drawImage(watermarkImg, X1, Y1, 50, imageHeight, null);
        for (i = 0; i < texts.length; ++i) {
            s = texts[i];
            g.drawString(s, X1, Y1 + imageHeight + 10 + i * fontSize);
        }
        this.reRotateGraphics(g, watermarkParameter);
        g.drawImage(watermarkImg, X2, Y2, 50, imageHeight, null);
        for (i = 0; i < texts.length; ++i) {
            s = texts[i];
            g.drawString(s, X2, Y2 + imageHeight + 10 + i * fontSize);
        }
        g.dispose();
        return bufImg;
    }

    protected double calImageHeight(double w, double h, double i) {
        return i * (h / w);
    }

    protected Graphics2D initGraphics(WatermarkParameter watermarkParameter, Graphics2D g) {
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        if (font != null) {
            g.setFont(font.deriveFont(0, watermarkParameter.getSize().intValue()));
        }
        g.setColor(watermarkParameter.getColor());
        g.rotate(Math.toRadians(-watermarkParameter.getRotation().intValue()), X1, Y1);
        g.setComposite(AlphaComposite.getInstance(11, watermarkParameter.getAlpha().floatValue()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g;
    }

    private void reRotateGraphics(Graphics2D g, WatermarkParameter watermarkParameter) {
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        g.rotate(Math.toRadians(watermarkParameter.getRotation().intValue()), X1, Y1);
        g.rotate(Math.toRadians(-watermarkParameter.getRotation().intValue()), X2, Y2);
    }

    static {
        try (InputStream stream = ExcelWatermarkHandler.class.getResourceAsStream("/resources/SIMHEI.TTF");){
            font = Font.createFont(0, stream);
        }
        catch (Exception e) {
            logger.error("create font failed", (Throwable)e);
        }
    }

    protected static class BeginPoint {
        private String position;
        private int srcWidth;
        private int srcHeight;
        private int markHeight;
        private int markWidth;
        private int x;
        private int y;

        public BeginPoint(String position, int srcWidth, int srcHeight, int markHeight, int markWidth) {
            this.position = position;
            this.srcWidth = srcWidth;
            this.srcHeight = srcHeight;
            this.markHeight = markHeight;
            this.markWidth = markWidth;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public BeginPoint invoke() {
            switch (this.position) {
                case "topLeft": {
                    this.x = 0;
                    this.y = 0;
                    break;
                }
                case "topRight": {
                    this.x = this.srcWidth - this.markWidth;
                    this.y = 0;
                    break;
                }
                case "topCenter": {
                    this.x = (this.srcWidth - this.markWidth) / 2;
                    this.y = 0;
                    break;
                }
                case "center": {
                    this.x = (this.srcWidth - this.markWidth) / 2;
                    this.y = (this.srcHeight - this.markHeight) / 2;
                    break;
                }
                case "centerLeft": {
                    this.x = 0;
                    this.y = (this.srcHeight - this.markHeight) / 2;
                    break;
                }
                case "centerRight": {
                    this.x = this.srcWidth - this.markWidth;
                    this.y = (this.srcHeight - this.markHeight) / 2;
                    break;
                }
                case "bottomLeft": {
                    this.x = 0;
                    this.y = this.srcHeight - this.markHeight;
                    break;
                }
                case "bottomCenter": {
                    this.x = (this.srcWidth - this.markWidth) / 2;
                    this.y = this.srcHeight - this.markHeight;
                    break;
                }
                case "bottomRight": {
                    this.x = this.srcWidth - this.markWidth;
                    this.y = this.srcHeight - this.markHeight;
                    break;
                }
                default: {
                    this.x = -1;
                    this.y = -1;
                }
            }
            return this;
        }
    }
}

