/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.awt.FontMetrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.UUID;
import javax.swing.JLabel;
import kd.bos.fileservice.config.FileServiceConfig;
import kd.bos.fileservice.utils.FileTimeoutUtil;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PdfWatermarkHandler
implements IWatermarkHandler {
    private static final Log logger = LogFactory.getLog(PdfWatermarkHandler.class);
    private static BaseFont font;
    private static final String TEMP_DIR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermarkTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            if (FileServiceConfig.WATERMARK_OPT_PDF_ENABLE.getBoolean()) {
                String tempFilePath = kd.bos.util.FileUtils.checkFileUrl((String)(TEMP_DIR + "/tempPDF" + UUID.randomUUID().toString().replace("-", "")));
                File tempFile = new File(tempFilePath);
                FileUtils.copyToFile((InputStream)origin, (File)tempFile);
                FileTimeoutUtil.removeFile(tempFilePath, null, 120000L);
                RandomAccessFileOrArray file = new RandomAccessFileOrArray(tempFilePath, false, FileServiceConfig.WATERMARK_OPT_PDF_PLAIN.getBoolean());
                reader = new PdfReader(file, null);
            } else {
                reader = new PdfReader(origin);
            }
            PdfWatermarkHandler.tryDecrypt(reader);
            stamper = new PdfStamper(reader, outputStream);
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(watermarkParameter.getAlpha().floatValue());
            gs.setStrokeOpacity(watermarkParameter.getAlpha().floatValue());
            int total = reader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                PdfContentByte content = stamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                content.beginText();
                content.setFontAndSize(font, (float)watermarkParameter.getSize().intValue());
                content.setColorFill(watermarkParameter.getColor());
                content.setColorStroke(watermarkParameter.getColor());
                content.setLeading((float)watermarkParameter.getSize().intValue());
                Rectangle pageSizeWithRotation = reader.getPageSizeWithRotation(i);
                float pageH = pageSizeWithRotation.getHeight();
                float pageW = pageSizeWithRotation.getWidth();
                int x = X1;
                while ((float)x < pageW) {
                    int y = Y1;
                    while ((float)y < pageH) {
                        this.showTextSupportNewline(content, 0, x, y, false, watermarkParameter);
                        this.showTextSupportNewline(content, 0, x + (X2 - X1), y + (Y2 - Y1), false, watermarkParameter);
                        y += frameHeight;
                    }
                    x += frameWidth;
                }
                content.endText();
            }
            logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    logger.error("stamper close failed", (Throwable)e);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermarkImg(OutputStream outputStream, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        InputStream imgWarterMarkStream = watermarkParameter.getImage();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)imgWarterMarkStream);
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            if (imgBytes.length > 0xA00000) {
                logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
                return;
            }
            if (FileServiceConfig.WATERMARK_OPT_PDF_ENABLE.getBoolean()) {
                String tempFilePath = kd.bos.util.FileUtils.checkFileUrl((String)(TEMP_DIR + "/tempPDF" + UUID.randomUUID().toString().replace("-", "")));
                File tempFile = new File(tempFilePath);
                FileUtils.copyToFile((InputStream)origin, (File)tempFile);
                FileTimeoutUtil.removeFile(tempFilePath, null, 120000L);
                RandomAccessFileOrArray file = new RandomAccessFileOrArray(tempFilePath, false, FileServiceConfig.WATERMARK_OPT_PDF_PLAIN.getBoolean());
                reader = new PdfReader(file, null);
            } else {
                reader = new PdfReader(origin);
            }
            PdfWatermarkHandler.tryDecrypt(reader);
            stamper = new PdfStamper(reader, outputStream);
            Image image = Image.getInstance((byte[])imgBytes);
            float imgWidth = image.getWidth();
            float imgHeight = image.getHeight();
            float dmarkHeight = imgHeight > 30.0f ? 30.0f : imgHeight;
            float dmarkWidth = dmarkHeight / imgHeight * imgWidth;
            image.scaleAbsolute(dmarkWidth, dmarkHeight);
            image.setRotationDegrees((float)watermarkParameter.getRotation().intValue());
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(watermarkParameter.getAlpha().floatValue());
            gs.setStrokeOpacity(watermarkParameter.getAlpha().floatValue());
            int total = reader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                PdfContentByte content = stamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                Rectangle pageSizeWithRotation = reader.getPageSizeWithRotation(i);
                float pageH = pageSizeWithRotation.getHeight();
                float pageW = pageSizeWithRotation.getWidth();
                int x = X1;
                while ((float)x < pageW) {
                    int y = Y1;
                    while ((float)y < pageH) {
                        image.setAbsolutePosition((float)x, (float)y);
                        content.addImage(image);
                        image.setAbsolutePosition((float)(x + (X2 - X1)), (float)(y + (Y2 - Y1)));
                        content.addImage(image);
                        y += frameHeight;
                    }
                    x += frameWidth;
                }
            }
            logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    logger.error("stamper close failed", (Throwable)e);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermarkUpImgUnderTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        InputStream in = watermarkParameter.getImage();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)in);
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            if (imgBytes.length > 0xA00000) {
                logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
                return;
            }
            if (FileServiceConfig.WATERMARK_OPT_PDF_ENABLE.getBoolean()) {
                String tempFilePath = kd.bos.util.FileUtils.checkFileUrl((String)(TEMP_DIR + "/tempPDF" + UUID.randomUUID().toString().replace("-", "")));
                File tempFile = new File(tempFilePath);
                FileUtils.copyToFile((InputStream)origin, (File)tempFile);
                FileTimeoutUtil.removeFile(tempFilePath, null, 120000L);
                RandomAccessFileOrArray file = new RandomAccessFileOrArray(tempFilePath, false, FileServiceConfig.WATERMARK_OPT_PDF_PLAIN.getBoolean());
                reader = new PdfReader(file, null);
            } else {
                reader = new PdfReader(origin);
            }
            PdfWatermarkHandler.tryDecrypt(reader);
            stamper = new PdfStamper(reader, outputStream);
            Image image = Image.getInstance((byte[])imgBytes);
            float imgWidth = image.getWidth();
            float imgHeight = image.getHeight();
            float dmarkHeight = imgHeight > 30.0f ? 30.0f : imgHeight;
            float dmarkWidth = dmarkHeight / imgHeight * imgWidth;
            image.scaleAbsolute(dmarkWidth, dmarkHeight);
            JLabel label = new JLabel();
            label.setText(watermarkParameter.getText());
            FontMetrics metrics = label.getFontMetrics(label.getFont());
            int textH = metrics.getHeight();
            int textW = metrics.stringWidth(label.getText());
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(watermarkParameter.getAlpha().floatValue());
            gs.setStrokeOpacity(watermarkParameter.getAlpha().floatValue());
            int total = reader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                PdfContentByte content = stamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                content.beginText();
                content.setFontAndSize(font, (float)watermarkParameter.getSize().intValue());
                content.setColorFill(watermarkParameter.getColor());
                content.setColorStroke(watermarkParameter.getColor());
                content.setLeading((float)watermarkParameter.getSize().intValue());
                Rectangle pageSizeWithRotation = reader.getPageSizeWithRotation(i);
                float pageH = pageSizeWithRotation.getHeight();
                float pageW = pageSizeWithRotation.getWidth();
                float mergeHeight = (float)textH + dmarkHeight;
                image.setRotationDegrees((float)watermarkParameter.getRotation().intValue());
                int x = X1;
                while ((float)x < pageW) {
                    int y = Y1;
                    while ((float)y < pageH) {
                        image.setAbsolutePosition((float)x, (float)y);
                        content.addImage(image);
                        image.setAbsolutePosition((float)(x + (X2 - X1)), (float)(y + (Y2 - Y1)));
                        content.addImage(image);
                        this.showTextSupportNewline(content, 0, x, (float)y + dmarkHeight - mergeHeight, false, watermarkParameter);
                        this.showTextSupportNewline(content, 0, x + (X2 - X1), (float)(y + (Y2 - Y1)) + dmarkHeight - mergeHeight, false, watermarkParameter);
                        y += frameHeight;
                    }
                    x += frameWidth;
                }
                content.endText();
            }
            logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    logger.error("stamper close failed", (Throwable)e);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watermarkLeftImgRightTxt(OutputStream outputStream, InputStream origin, WatermarkParameter watermarkParameter) throws IOException, DocumentException {
        long startTime = System.currentTimeMillis();
        int frameWidth = watermarkParameter.getStyle().getFrameWidth();
        int frameHeight = watermarkParameter.getStyle().getFrameHeight();
        int X1 = watermarkParameter.getStyle().getX1();
        int Y1 = watermarkParameter.getStyle().getY1();
        int X2 = watermarkParameter.getStyle().getX2();
        int Y2 = watermarkParameter.getStyle().getY2();
        InputStream in = watermarkParameter.getImage();
        byte[] imgBytes = IOUtils.toByteArray((InputStream)in);
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            if (imgBytes.length > 0xA00000) {
                logger.warn("img size={}, greater than limit size[{}], do nothing", (Object)imgBytes.length, (Object)0xA00000);
                return;
            }
            if (FileServiceConfig.WATERMARK_OPT_PDF_ENABLE.getBoolean()) {
                String tempFilePath = kd.bos.util.FileUtils.checkFileUrl((String)(TEMP_DIR + "/tempPDF" + UUID.randomUUID().toString().replace("-", "")));
                File tempFile = new File(tempFilePath);
                FileUtils.copyToFile((InputStream)origin, (File)tempFile);
                FileTimeoutUtil.removeFile(tempFilePath, null, 120000L);
                RandomAccessFileOrArray file = new RandomAccessFileOrArray(tempFilePath, false, FileServiceConfig.WATERMARK_OPT_PDF_PLAIN.getBoolean());
                reader = new PdfReader(file, null);
            } else {
                reader = new PdfReader(origin);
            }
            PdfWatermarkHandler.tryDecrypt(reader);
            stamper = new PdfStamper(reader, outputStream);
            Image image = Image.getInstance((byte[])imgBytes);
            float imgWidth = image.getWidth();
            float imgHeight = image.getHeight();
            float dmarkHeight = imgHeight > 30.0f ? 30.0f : imgHeight;
            float dmarkWidth = dmarkHeight / imgHeight * imgWidth;
            image.scaleAbsolute(dmarkWidth, dmarkHeight);
            JLabel label = new JLabel();
            label.setText(watermarkParameter.getText());
            FontMetrics metrics = label.getFontMetrics(label.getFont());
            int textH = metrics.getHeight();
            int textW = metrics.stringWidth(label.getText());
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(watermarkParameter.getAlpha().floatValue());
            gs.setStrokeOpacity(watermarkParameter.getAlpha().floatValue());
            int total = reader.getNumberOfPages() + 1;
            for (int i = 1; i < total; ++i) {
                PdfContentByte content = stamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                content.beginText();
                content.setFontAndSize(font, (float)watermarkParameter.getSize().intValue());
                content.setColorFill(watermarkParameter.getColor());
                content.setColorStroke(watermarkParameter.getColor());
                content.setLeading((float)watermarkParameter.getSize().intValue());
                Rectangle pageSizeWithRotation = reader.getPageSizeWithRotation(i);
                float pageH = pageSizeWithRotation.getHeight();
                float pageW = pageSizeWithRotation.getWidth();
                float mergeHeight = (float)textH - dmarkHeight > 0.0f ? (float)textH : dmarkHeight;
                float mergeWidth = (float)textW + dmarkWidth + 5.0f;
                int c = watermarkParameter.getText() == null || watermarkParameter.getText().equals("") ? 0 : this.splitNewline(watermarkParameter.getText()).length - 1;
                int fontSize = watermarkParameter.getSize();
                int h = c * fontSize;
                image.setRotationDegrees((float)watermarkParameter.getRotation().intValue());
                int x = X1;
                while ((float)x < pageW) {
                    int y = Y1;
                    while ((float)y < pageH) {
                        image.setAbsolutePosition((float)x, (float)y);
                        content.addImage(image);
                        image.setAbsolutePosition((float)(x + (X2 - X1)), (float)(y + (Y2 - Y1)));
                        content.addImage(image);
                        this.showTextSupportNewline(content, 0, (float)(x - textW) + mergeWidth, (float)y + mergeHeight / 2.0f + (float)h, false, watermarkParameter);
                        this.showTextSupportNewline(content, 0, (float)(x + (X2 - X1) - textW) + mergeWidth, (float)(y + (Y2 - Y1)) + mergeHeight / 2.0f + (float)h, false, watermarkParameter);
                        y += frameHeight;
                    }
                    x += frameWidth;
                }
                content.endText();
            }
            logger.debug("cost: " + (System.currentTimeMillis() - startTime) + " ms");
        }
        finally {
            if (stamper != null) {
                try {
                    stamper.close();
                }
                catch (Exception e) {
                    logger.error("stamper close failed", (Throwable)e);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void showTextSupportNewline(PdfContentByte content, int alignment, float x, float y, boolean kerned, WatermarkParameter watermarkParameter) {
        String text = watermarkParameter.getText();
        float rotation = watermarkParameter.getRotation().intValue();
        if (text == null || text.equals("")) {
            return;
        }
        String[] texts = this.splitNewline(text);
        if (rotation == 0.0f) {
            switch (alignment) {
                case 1: {
                    x -= content.getEffectiveStringWidth(text, kerned) / 2.0f;
                    break;
                }
                case 2: {
                    x -= content.getEffectiveStringWidth(text, kerned);
                }
            }
            content.setTextMatrix(x, y);
            for (int i = 0; i < texts.length; ++i) {
                if (kerned) {
                    content.showTextKerned(texts[i]);
                } else {
                    content.showText(texts[i]);
                }
                content.newlineText();
            }
        } else {
            double alpha = (double)rotation * Math.PI / 180.0;
            float cos = (float)Math.cos(alpha);
            float sin = (float)Math.sin(alpha);
            switch (alignment) {
                case 1: {
                    float len = content.getEffectiveStringWidth(text, kerned) / 2.0f;
                    x -= len * cos;
                    y -= len * sin;
                    break;
                }
                case 2: {
                    float len = content.getEffectiveStringWidth(text, kerned);
                    x -= len * cos;
                    y -= len * sin;
                }
            }
            content.setTextMatrix(cos, sin, -sin, cos, x, y);
            for (int i = 0; i < texts.length; ++i) {
                if (kerned) {
                    content.showTextKerned(texts[i]);
                } else {
                    content.showText(texts[i]);
                }
                content.newlineText();
            }
            content.setTextMatrix(0.0f, 0.0f);
        }
    }

    private static void tryDecrypt(PdfReader reader) throws DocumentException {
        if (reader.isEncrypted()) {
            try {
                Field ownerPasswordUsed = PdfReader.class.getDeclaredField("ownerPasswordUsed");
                ownerPasswordUsed.setAccessible(true);
                ownerPasswordUsed.setBoolean(reader, true);
            }
            catch (NoSuchFieldException e) {
                throw new DocumentException((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new DocumentException((Exception)e);
            }
        }
    }

    static {
        TEMP_DIR = System.getProperty("java.io.tmpdir");
        try {
            font = BaseFont.createFont((String)"/resources/SIMHEI.TTF", (String)"Identity-H", (boolean)false);
        }
        catch (Exception e) {
            logger.error("create font failed", (Throwable)e);
        }
    }
}

