/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.watermark;

import java.awt.Color;
import java.io.InputStream;
import java.util.Objects;
import kd.bos.fileservice.enums.ScreenResolution;
import kd.bos.fileservice.enums.WatermarkType;

public class WatermarkParameter {
    private String position;
    private Float alpha;
    private Integer rotation;
    private Integer type;
    private InputStream image;
    private String text;
    private Color color;
    private Integer size;
    private Boolean compress;
    private Style style;
    private String pdfImpl;

    private WatermarkParameter(Builder builder) {
        this.position = builder.position;
        this.alpha = builder.alpha;
        this.rotation = builder.rotation;
        this.type = builder.type;
        this.image = builder.image;
        this.text = builder.text;
        this.color = builder.color;
        this.size = builder.size;
        this.compress = builder.compress;
        this.style = builder.style;
        this.pdfImpl = builder.pdfImpl;
    }

    public boolean valid() {
        if (this.type.intValue() == WatermarkType.NO_WATER.ordinal()) {
            return false;
        }
        if (WatermarkType.TEXT.ordinal() == this.type.intValue() && (this.text == null || this.text.length() == 0)) {
            return false;
        }
        if (WatermarkType.IMG.ordinal() == this.type.intValue() && this.image == null) {
            return false;
        }
        if ((this.text == null || this.text.length() == 0) && this.image == null) {
            return false;
        }
        if (WatermarkType.LEFT_IMG_RIGHT_TEXT.ordinal() == this.type.intValue() || WatermarkType.UP_IMG_UNDER_TEXT.ordinal() == this.type.intValue()) {
            return this.text != null && this.text.length() != 0 && this.image != null;
        }
        return true;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(Float alpha) {
        this.alpha = alpha;
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public InputStream getImage() {
        return this.image;
    }

    public void setImage(InputStream image) {
        this.image = image;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setCompress(Boolean compress) {
        this.compress = compress;
    }

    public Boolean getCompress() {
        return this.compress;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String getPdfImpl() {
        return this.pdfImpl;
    }

    public void setPdfImpl(String pdfImpl) {
        this.pdfImpl = pdfImpl;
    }

    public String toString() {
        return "WatermarkParameter{position='" + this.position + '\'' + ", alpha=" + this.alpha + ", rotation=" + this.rotation + ", type=" + this.type + ", image is null=" + Objects.isNull(this.image) + ", text='" + this.text + '\'' + ", color=" + this.color.toString() + ", size=" + this.size + ", compress=" + this.compress + ", pdfImpl=" + this.pdfImpl + ", style=" + this.style + '}';
    }

    public static class Builder {
        private String position;
        private Float alpha;
        private Integer rotation;
        private Integer type;
        private InputStream image;
        private String text;
        private Color color;
        private Integer size;
        private Boolean compress;
        private Style style;
        private String pdfImpl;

        public Builder(Integer type, String text) {
            this.type = type;
            this.text = text;
        }

        public Builder(Integer type, InputStream image) {
            this.type = type;
            this.image = image;
        }

        public Builder(Integer type, String text, InputStream image) {
            this.type = type;
            this.text = text;
            this.image = image;
        }

        public Builder setPosition(String position) {
            this.position = position;
            return this;
        }

        public Builder setAlpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder setRotation(Integer rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder setType(Integer type) {
            this.type = type;
            return this;
        }

        public Builder setImage(InputStream image) {
            this.image = image;
            return this;
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setColor(Color color) {
            this.color = color;
            return this;
        }

        public Builder setSize(Integer size) {
            this.size = size;
            return this;
        }

        public Builder setCompress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder setStyle(Style style) {
            this.style = style;
            return this;
        }

        public void setPdfImpl(String pdfImpl) {
            this.pdfImpl = pdfImpl;
        }

        public WatermarkParameter build() {
            this.alpha = this.alpha == null ? Float.valueOf(0.1f) : this.alpha;
            this.rotation = this.rotation == null ? Integer.valueOf(10) : this.rotation;
            this.position = this.position == null ? "" : this.position;
            this.color = this.color == null ? Color.BLACK : this.color;
            this.size = this.size == null ? Integer.valueOf(12) : this.size;
            this.compress = this.compress == null ? Boolean.TRUE : this.compress;
            this.style = this.style == null ? new Style() : this.style;
            this.pdfImpl = this.pdfImpl == null ? "openPDF" : this.pdfImpl;
            return new WatermarkParameter(this);
        }
    }

    public static class Style {
        private int frameWidth = 440;
        private int frameHeight = 120;
        private int x1 = 0;
        private int y1 = 30;
        private int x2 = 220;
        private int y2 = 90;
        private ScreenResolution resolution = ScreenResolution.FULL_HD;
        private boolean scale = true;

        public Style() {
        }

        public Style(int width, int height) {
            this.frameWidth = width;
            this.frameHeight = height;
            this.x2 = width / 2;
            this.y2 = height / 2 + this.y1;
        }

        public Style(int width, int height, ScreenResolution resolution) {
            this.frameWidth = width;
            this.frameHeight = height;
            this.x2 = width / 2;
            this.y2 = height / 2 + this.y1;
            this.resolution = resolution;
        }

        public Style(int width, int heigth, int x1, int x2, int y1, int y2) {
            this.frameWidth = width;
            this.frameHeight = heigth;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Style(int width, int heigth, int x1, int x2, int y1, int y2, ScreenResolution resolution) {
            this.frameWidth = width;
            this.frameHeight = heigth;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.resolution = resolution;
        }

        public int getFrameWidth() {
            return this.frameWidth;
        }

        public void setFrameWidth(int frameWidth) {
            this.frameWidth = frameWidth;
        }

        public int getFrameHeight() {
            return this.frameHeight;
        }

        public void setFrameHeight(int frameHeight) {
            this.frameHeight = frameHeight;
        }

        public int getX1() {
            return this.x1;
        }

        public void setX1(int x1) {
            this.x1 = x1;
        }

        public int getY1() {
            return this.y1;
        }

        public void setY1(int y1) {
            this.y1 = y1;
        }

        public int getX2() {
            return this.x2;
        }

        public void setX2(int x2) {
            this.x2 = x2;
        }

        public int getY2() {
            return this.y2;
        }

        public void setY2(int y2) {
            this.y2 = y2;
        }

        public ScreenResolution getResolution() {
            return this.resolution;
        }

        public void setResolution(ScreenResolution resolution) {
            this.resolution = resolution;
        }

        public boolean isScale() {
            return this.scale;
        }

        public void setScale(boolean scale) {
            this.scale = scale;
        }

        public String toString() {
            return "Style{frameWidth=" + this.frameWidth + ", frameHeight=" + this.frameHeight + ", x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", resolution=" + (Object)((Object)this.resolution) + ", isScale=" + this.scale + '}';
        }
    }
}

