/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.configuration;

import feign.Client;
import kd.bos.mservice.rpc.feign.httpclient.KdApacheHttpClient;
import kd.bos.mservice.rpc.feign.loadbalance.BosLoadBalancerFeignClient;
import kd.bos.mservice.rpc.handshake.ClientTypeEnum;
import kd.bos.mservice.rpc.handshake.HandshakeServiceFactory;
import kd.bos.mservice.rpc.handshake.client.HandshakeClient;
import kd.bos.mservice.rpc.handshake.client.impl.ApacheHttpHandshakeClient;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"feign.config.auto"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={KdApacheHttpClient.class})
@Configuration
public class FeignLoadbalanceConfiguration {
    @Bean
    public Client feignClient(LoadBalancerClient loadBalancerClient, LoadBalancerClientFactory loadBalancerClientFactory) {
        if (Boolean.getBoolean("feign.apacheclient.disable")) {
            return new BosLoadBalancerFeignClient((Client)new Client.Default(null, null), loadBalancerClient, loadBalancerClientFactory);
        }
        CloseableHttpClient builder = HttpClientBuilder.create().setMaxConnTotal(Integer.parseInt(System.getProperty("mservice.apache.httpclient.maxTotal", "200"))).setMaxConnPerRoute(Integer.parseInt(System.getProperty("mservice.apache.httpclient.maxConnPerRoute", "50"))).build();
        HandshakeServiceFactory.create((ClientTypeEnum)ClientTypeEnum.APACHE_HTTP, (HandshakeClient)new ApacheHttpHandshakeClient((HttpClient)builder));
        return new BosLoadBalancerFeignClient((Client)new KdApacheHttpClient((HttpClient)builder), loadBalancerClient, loadBalancerClientFactory);
    }
}

