/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.controller;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.service.invoke.MServiceFactory;
import kd.bos.thread.ThreadTruck;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConverterServiceController {
    private static final Log log = LogFactory.getLog(ConverterServiceController.class);
    private static final String CONVERTER_SERVICE_REQUEST = "/kdConverterServiceRequest";
    private final TypeConverter typeConverter = new SimpleTypeConverter();

    @RequestMapping(value={"/kdConverterServiceRequest"}, method={RequestMethod.POST}, produces={"application/xx-kd-serialization; charset=UTF-8"})
    public Object invoke(@RequestHeader(value="originalUri") String requestPath, @RequestHeader(value="codecType", defaultValue="javaobj") String codecType, @RequestBody(required=false) CommonRpcParam commonRpcParam) {
        String serviceName = "";
        try {
            commonRpcParam = (CommonRpcParam)ThreadTruck.get((Object)"commonRpcParam");
            MServiceDefineMeta serviceDefine = this.getMServiceDefine(requestPath);
            serviceName = serviceDefine.getServiceName();
            Object serviceObject = MServiceFactory.getService((String)serviceName);
            MServiceDefineMeta.MethodDefine md = MServiceFactory.getMethodDefineByRequestPath((String)serviceName, (String)requestPath);
            List pdLs = md.getServiceMethodParams();
            Method mehtod = MServiceFactory.findServiceMethod(serviceObject.getClass(), (String)md.getServiceMethodName(), (int)pdLs.size());
            Object[] params = commonRpcParam.getParams();
            if (params != null && "restTemplate".equals(commonRpcParam.getAttachments().get("rpcType")) && HttpMethod.GET.name().equals(commonRpcParam.getAttachments().get("rpcRequestMethod"))) {
                String paramsStr = (String)params[0];
                MultiMap<String> paramMap = this.extractQueryParameters(paramsStr);
                Object[] realParams = new Object[pdLs.size()];
                if (paramMap != null) {
                    for (int i = 0; i < pdLs.size(); ++i) {
                        List vals = paramMap.getValues(((MServiceDefineMeta.ParamDefine)pdLs.get(i)).getName());
                        String[] rv = vals == null ? null : vals.toArray(new String[vals.size()]);
                        realParams[i] = this.typeConverter.convertIfNecessary((Object)rv, mehtod.getParameterTypes()[i], new MethodParameter(mehtod, i));
                    }
                }
                params = realParams;
            }
            return mehtod.invoke(serviceObject, params);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (!(e instanceof RpcException.RpcServerException)) {
                e = new RpcException.RpcServerException(e.getMessage(), e);
            }
            log.error("\u8bf7\u6c42serviceName\u4e3a\uff1a " + serviceName + ",\u8bf7\u6c42uri\u4e3a\uff1a " + requestPath, e);
            return new ResponseEntity((Object)e, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private MServiceDefineMeta getMServiceDefine(String requestPath) {
        MServiceDefineMeta serviceDefine = MServiceFactory.getServiceDefineByPath((String)requestPath);
        if (null == serviceDefine) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"The path: " + requestPath + " does not exist"});
        }
        return serviceDefine;
    }

    private MultiMap<String> extractQueryParameters(String params) {
        MultiMap paramMap = new MultiMap();
        UrlEncoded.decodeUtf8To((String)params, (MultiMap)paramMap);
        return paramMap;
    }
}

