/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.debug;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.debug.DebugInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.debug.DebugUtil;

public class FeignDebugUtil {
    private static final Log log = LogFactory.getLog(FeignDebugUtil.class);

    public static <T> T invoke(RequestContext rc, Callable<T> invoker, Supplier<String> invokerInfo) throws Exception {
        if (!DebugUtil.dev_log_sysout && log.isDebugEnabled()) {
            log.debug("#" + (String)DebugUtil.wrapInvokerInfoSupplier(invokerInfo).get());
        }
        if (rc != null) {
            DebugInfo di = rc.getDebugInfo();
            String debugId = null;
            if (di != null) {
                debugId = di.getDebugId();
            }
            if (debugId != null && !"null".equals(debugId)) {
                if (di.isCmd()) {
                    return (T)DebugUtil.runAtDebugCmdThread.invoke(null, debugId, invoker, DebugUtil.wrapInvokerInfoSupplier(invokerInfo));
                }
                return (T)DebugUtil.runAtDebugMainThread.invoke(null, debugId, invoker, DebugUtil.wrapInvokerInfoSupplier(invokerInfo));
            }
        }
        return invoker.call();
    }
}

