/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.debug;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kd.bos.context.RequestContext;
import kd.bos.debug.DebugInfo;
import kd.bos.exception.KDException;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.rpc.feign.debug.FeignDebugUtil;

public class FeignLocalDebugProxy {
    public static <T> T debugProxy(Class<T> clazz, final T obj) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RequestContext rc = RequestContext.get();
                try {
                    return FeignDebugUtil.invoke(rc, () -> {
                        RequestContext.set((RequestContext)rc);
                        DebugInfo.setupThreadDebug((DebugInfo)rc.getDebugInfo());
                        return method.invoke(obj, args);
                    }, () -> method.getDeclaringClass().getName() + "." + method.getName() + "(" + DebugUtil.argumentsInfo((Object[])args) + ")");
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    if (e instanceof KDException) {
                        throw (KDException)e;
                    }
                    throw e;
                }
            }
        });
    }
}

