/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.eureka;

import com.netflix.appinfo.InstanceInfo;
import kd.bos.mservice.discovery.KRegistryInstance;
import kd.bos.mservice.discovery.KRegistryInstanceTransform;
import kd.bos.mservice.rpc.feign.FieldUtils;
import kd.bos.util.StringUtils;

public class KRegistryInstanceEurekaTransform
implements KRegistryInstanceTransform<InstanceInfo, InstanceInfo> {
    public InstanceInfo transform(KRegistryInstance registryInstance, InstanceInfo instanceInfo) {
        String appId = registryInstance.getAppId();
        String appName = registryInstance.getRegistryAppName();
        if (StringUtils.isNotEmpty((String)appId)) {
            instanceInfo.getMetadata().put("serverAppId", appId);
        }
        String instanceId = instanceInfo.getIPAddr() + ":" + appName + ":" + instanceInfo.getPort();
        this.changeToRealInstance(instanceInfo, appName, instanceId);
        return instanceInfo;
    }

    private void changeToRealInstance(InstanceInfo instanceInfo, String appName, String instanceId) {
        FieldUtils.setFiledValue("appName", instanceInfo, appName);
        FieldUtils.setFiledValue("vipAddress", instanceInfo, appName);
        FieldUtils.setFiledValue("secureVipAddress", instanceInfo, appName);
        FieldUtils.setFiledValue("vipAddressUnresolved", instanceInfo, appName);
        FieldUtils.setFiledValue("secureVipAddressUnresolved", instanceInfo, appName);
        FieldUtils.setFiledValue("instanceId", instanceInfo, instanceId);
    }
}

