/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.kregistrycenter.discovery;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.kregistrycenter.CallNotify;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;
import kd.bos.mservice.kregistrycenter.spi.KRegistryCenter;
import kd.bos.mservice.kregistrycenter.spi.KRegistryCenterFactory;
import kd.bos.mservice.rpc.feign.registry.kregistrycenter.RegistrationUtils;
import kd.bos.mservice.rpc.feign.registry.kregistrycenter.registry.KCommonRegistration;
import kd.bos.serializer.HessianSerializer;
import kd.bos.util.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class KCommonDiscoveryClient
implements DiscoveryClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private KRegistryCenter registryCenter = KRegistryCenterFactory.getRegistryCenter();
    private Cache<String, List<ServiceInstance>> cache = CacheBuilder.newBuilder().expireAfterWrite((long)Integer.getInteger("spring.cloud.kcommonregistry.discovery.timeout", 30).intValue(), TimeUnit.SECONDS).build();
    private Map<String, CallNotify> subscribeListener = new ConcurrentHashMap<String, CallNotify>(1);

    public String description() {
        return "king dee common discovery client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List ls = null;
        try {
            ls = (List)this.cache.get((Object)serviceId, () -> this.innerGetInstances(serviceId));
        }
        catch (ExecutionException e) {
            this.log.debug("get ExecutionException ", (Throwable)e);
        }
        if (ls != null) {
            return ls;
        }
        List<ServiceInstance> serviceInstances = this.innerGetInstances(serviceId);
        this.cache.put((Object)serviceId, serviceInstances);
        return serviceInstances;
    }

    private List<ServiceInstance> innerGetInstances(String serviceId) {
        String interfaceName = RegisterAppNameUtils.getRequestFeignParam().getInterfaceName();
        String appid = RegisterAppNameUtils.getOriginaRequestAppID();
        RegistrationInfo out = RegistrationUtils.createRegistration(appid, interfaceName);
        this.subscribeListener.computeIfAbsent(serviceId, k -> {
            CallNotify callnotify = (parentPath, currentChilds) -> {
                if (currentChilds == null || currentChilds.isEmpty()) {
                    List serviceInstances = (List)this.cache.getIfPresent((Object)serviceId);
                    if (serviceInstances != null) {
                        serviceInstances.clear();
                    }
                } else {
                    this.cache.put((Object)serviceId, this.transServerList(currentChilds));
                }
                this.log.error("notifyChange get serverlist for " + serviceId);
            };
            this.registryCenter.doAddSubscribeListener(out, callnotify);
            return callnotify;
        });
        List<ServiceInstance> serviceInstances = (List<ServiceInstance>)this.cache.getIfPresent((Object)serviceId);
        if (serviceInstances == null) {
            List serverList = this.registryCenter.getProviderList(out, "/" + interfaceName + (appid == null ? "" : "/" + appid) + "/providers");
            this.log.error("get serverlist for " + serviceId);
            System.err.println("get serverlist for " + serviceId);
            serviceInstances = this.transServerList(serverList);
        }
        return serviceInstances;
    }

    private List<ServiceInstance> transServerList(List<String> serverList) {
        ArrayList<ServiceInstance> returnList = new ArrayList<ServiceInstance>(1);
        for (String serverStr : serverList) {
            try {
                int index = (serverStr = URLDecoder.decode(serverStr, "UTF-8")).indexOf("?");
                if (index <= 0) continue;
                KCommonRegistration registration = (KCommonRegistration)HessianSerializer.deserialize((byte[])HexUtils.fromHex((String)serverStr.substring(index + 1)));
                returnList.add((ServiceInstance)registration);
            }
            catch (UnsupportedEncodingException e) {
                this.log.warn("UnsupportedEncodingException", (Throwable)e);
            }
            catch (Exception e) {
                this.log.warn("transServerList Exception", (Throwable)e);
            }
        }
        return returnList;
    }

    public List<String> getServices() {
        ArrayList<String> s = new ArrayList<String>();
        s.add("sss");
        return s;
    }
}

