/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.nacos;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.HashMap;
import kd.bos.config.client.util.StringUtils;
import kd.bos.mservice.discovery.KRegistryInstance;
import kd.bos.mservice.discovery.KRegistryInstanceTransform;
import kd.bos.mservice.rpc.feign.registry.nacos.NacosRegistrationInfo;
import org.springframework.cloud.client.serviceregistry.Registration;

public class KRegistryInstanceNacosTransform
implements KRegistryInstanceTransform<NacosRegistrationInfo, Instance> {
    public Instance transform(KRegistryInstance registryInstance, NacosRegistrationInfo nacosRegistrationInfo) {
        Registration registration = nacosRegistrationInfo.getRegistration();
        NacosDiscoveryProperties nacosDiscoveryProperties = nacosRegistrationInfo.getNacosDiscoveryProperties();
        Instance instance = new Instance();
        if (StringUtils.isNotEmpty((String)nacosDiscoveryProperties.getIp())) {
            instance.setIp(nacosDiscoveryProperties.getIp());
        } else {
            instance.setIp(registryInstance.getHost());
        }
        if (nacosDiscoveryProperties.getPort() != -1) {
            instance.setPort(nacosDiscoveryProperties.getPort());
        } else {
            instance.setPort(registryInstance.getPort().intValue());
        }
        instance.setClusterName(nacosDiscoveryProperties.getClusterName());
        instance.setWeight((double)nacosDiscoveryProperties.getWeight());
        instance.setEnabled(nacosDiscoveryProperties.isInstanceEnabled());
        instance.setMetadata(new HashMap(registration.getMetadata()));
        instance.setEphemeral(nacosDiscoveryProperties.isEphemeral());
        instance.addMetadata("serverInstanceId", registryInstance.getInstanceId());
        instance.addMetadata("group", registryInstance.getGroup());
        instance.addMetadata("appId", registryInstance.getAppId());
        instance.addMetadata("appGroup", registryInstance.getAppGroup());
        instance.addMetadata("transType", registryInstance.getTransProtocolType());
        return instance;
    }
}

