/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.nacos;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kd.bos.instance.Instance;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.discovery.KRegistryInstanceTransformAdapter;
import kd.bos.mservice.rpc.feign.registry.RegistryCallback;
import kd.bos.mservice.rpc.feign.registry.RegistryFailedRetry;
import kd.bos.mservice.rpc.feign.registry.nacos.NacosRegistrationInfo;
import kd.bos.service.register.ServiceRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.util.ReflectionUtils;

public class NacosServiceRegistry
extends com.alibaba.cloud.nacos.registry.NacosServiceRegistry {
    private static final String LOG_MESSAGE_INFO = "nacos registry, {} {} {}:{} register finished";
    private static final String LOG_MESSAGE_ERROR = "nacos registry, {} register failed...{},";
    private static final String STATUS_UP = "UP";
    private static final String STATUS_DOWN = "DOWN";
    private static final Logger log = LoggerFactory.getLogger(com.alibaba.cloud.nacos.registry.NacosServiceRegistry.class);
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private com.alibaba.nacos.api.naming.pojo.Instance modelInstance;
    private final RegistryFailedRetry registryFailedRetry = RegistryFailedRetry.getInstance("NacosServiceRegistry", new RegistryCallback<NacosRegistryInfo>(){

        @Override
        public void doRegistry(NacosRegistryInfo service) throws Exception {
            NamingService namingService = NacosServiceRegistry.this.namingService();
            try {
                namingService.registerInstance(service.getAppName(), service.getGroup(), service.getInstance());
            }
            catch (Exception var6) {
                log.error(NacosServiceRegistry.LOG_MESSAGE_ERROR, new Object[]{service.getAppName(), service.getInstance(), var6});
            }
        }

        @Override
        public void unRegistry(NacosRegistryInfo service) throws Exception {
            NamingService namingService = NacosServiceRegistry.this.namingService();
            try {
                com.alibaba.nacos.api.naming.pojo.Instance instance = service.getInstance();
                namingService.deregisterInstance(service.getAppName(), service.getGroup(), instance.getIp(), instance.getPort(), NacosServiceRegistry.this.nacosDiscoveryProperties.getClusterName());
            }
            catch (Exception e) {
                log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", (Object)service.toString(), (Object)e);
            }
        }

        @Override
        public void initRegistryDelay(String interfaceName, String appid) {
            NamingService namingService = NacosServiceRegistry.this.namingService();
            if (NacosServiceRegistry.this.modelInstance == null) {
                return;
            }
            if (appid == null) {
                String appName = RegisterAppNameUtils.getRegisterInterfaceName((String)interfaceName);
                String group = NacosServiceRegistry.this.nacosDiscoveryProperties.getGroup();
                com.alibaba.nacos.api.naming.pojo.Instance instance = NacosServiceRegistry.this.modelInstance;
                try {
                    namingService.registerInstance(appName, group, instance);
                    NacosRegistryInfo registryInfo = new NacosRegistryInfo().withAppName(appName).withGroup(group).withInstance(instance);
                    NacosServiceRegistry.this.registryFailedRetry.addRegistery(registryInfo);
                    NacosServiceRegistry.this.registryFailedRetry.hasInitRegistery(interfaceName, null);
                    log.info(NacosServiceRegistry.LOG_MESSAGE_INFO, new Object[]{group, appName, instance.getIp(), instance.getPort()});
                }
                catch (Exception var6) {
                    log.error(NacosServiceRegistry.LOG_MESSAGE_ERROR, new Object[]{appName, instance.toString(), var6});
                    ReflectionUtils.rethrowRuntimeException((Throwable)var6);
                }
            } else {
                String appName = RegisterAppNameUtils.getRegisterAppName((String)appid, (String)interfaceName);
                String group = NacosServiceRegistry.this.nacosDiscoveryProperties.getGroup();
                com.alibaba.nacos.api.naming.pojo.Instance instance = NacosServiceRegistry.this.modelInstance;
                instance.addMetadata("serverAppId", appid);
                try {
                    namingService.registerInstance(appName, group, instance);
                    NacosRegistryInfo registryInfo = new NacosRegistryInfo().withAppName(appName).withAppId(appid).withGroup(group).withInstance(instance);
                    NacosServiceRegistry.this.registryFailedRetry.addRegistery(registryInfo);
                    NacosServiceRegistry.this.registryFailedRetry.hasInitRegistery(interfaceName, appid);
                    log.info(NacosServiceRegistry.LOG_MESSAGE_INFO, new Object[]{group, appName, instance.getIp(), instance.getPort()});
                }
                catch (Exception var6) {
                    log.error(NacosServiceRegistry.LOG_MESSAGE_ERROR, new Object[]{appName, instance.toString(), var6});
                    ReflectionUtils.rethrowRuntimeException((Throwable)var6);
                }
            }
        }
    });
    @Autowired
    private NacosServiceManager nacosServiceManager;

    public NacosServiceRegistry(NacosDiscoveryProperties nacosDiscoveryProperties) {
        super(nacosDiscoveryProperties);
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    public void register(Registration registration) {
        if (!ServiceRegister.isMServiceRegistryEnable()) {
            return;
        }
        this.cacheNacosModelInstance(registration);
        NacosRegistrationInfo nacosRegistrationInfo = new NacosRegistrationInfo(registration, this.nacosDiscoveryProperties);
        KRegistryInstanceTransformAdapter transformAdapter = KRegistryInstanceTransformAdapter.getAdapter((String)"http", (String)"nacos", (KRegistryInstanceTransformAdapter.SourceRegistryType)new KRegistryInstanceTransformAdapter.SourceRegistryType<NacosRegistrationInfo, com.alibaba.nacos.api.naming.pojo.Instance>(){});
        List instances = transformAdapter.getRegistryList((Object)nacosRegistrationInfo);
        for (KRegistryInstanceTransformAdapter.RegistryInstanceWrapper nacosInstanceWarpper : instances) {
            com.alibaba.nacos.api.naming.pojo.Instance instance = (com.alibaba.nacos.api.naming.pojo.Instance)nacosInstanceWarpper.getInstacne();
            String interfaceName = nacosInstanceWarpper.getInterfaceName();
            String group = this.nacosDiscoveryProperties.getGroup();
            String appName = nacosInstanceWarpper.getRegistryAppName();
            for (int i = 0; i < 5; ++i) {
                try {
                    this.namingService().registerInstance(appName, group, instance);
                    break;
                }
                catch (Exception e) {
                    if (i == 4) {
                        log.error(LOG_MESSAGE_ERROR, new Object[]{appName, registration.toString(), e});
                        ReflectionUtils.rethrowRuntimeException((Throwable)e);
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(500 + i * 500);
                    }
                    catch (InterruptedException ex) {
                        log.error(LOG_MESSAGE_ERROR, new Object[]{appName, registration.toString(), e});
                    }
                    continue;
                }
            }
            NacosRegistryInfo registryInfo = new NacosRegistryInfo().withAppName(appName).withGroup(group).withInstance(instance);
            this.registryFailedRetry.addRegistery(registryInfo);
            this.registryFailedRetry.hasInitRegistery(interfaceName, null);
            log.info(LOG_MESSAGE_INFO, new Object[]{group, appName, instance.getIp(), instance.getPort()});
        }
        this.registryFailedRetry.finishBaseInit();
    }

    public void deregister(Registration registration) {
        log.info("De-registering from Nacos Server now...");
        String str = registration.getServiceId();
        if (str == null || "".equals(str)) {
            log.warn("No dom to de-register for nacos client...");
            return;
        }
        NamingService namingService = this.namingService();
        String serviceId = registration.getServiceId();
        String group = this.nacosDiscoveryProperties.getGroup();
        try {
            namingService.deregisterInstance(serviceId, group, registration.getHost(), registration.getPort(), this.nacosDiscoveryProperties.getClusterName());
        }
        catch (Exception e) {
            log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", (Object)registration, (Object)e);
        }
        log.info("De-registration finished.");
    }

    public void close() {
        try {
            this.nacosServiceManager.nacosServiceShutDown();
        }
        catch (NacosException e) {
            log.error("Nacos namingService shutDown failed", (Throwable)e);
        }
    }

    public void setStatus(Registration registration, String status) {
        if (!STATUS_UP.equalsIgnoreCase(status) && !STATUS_DOWN.equalsIgnoreCase(status)) {
            log.warn("can't support status {},please choose UP or DOWN", (Object)status);
            return;
        }
        String serviceId = registration.getServiceId();
        com.alibaba.nacos.api.naming.pojo.Instance instance = this.getNacosInstanceFromRegistration(registration);
        instance.setEnabled(!STATUS_DOWN.equalsIgnoreCase(status));
        try {
            Properties nacosProperties = this.nacosDiscoveryProperties.getNacosProperties();
            this.nacosServiceManager.getNamingMaintainService(nacosProperties).updateInstance(serviceId, this.nacosDiscoveryProperties.getGroup(), instance);
        }
        catch (Exception e) {
            throw new RuntimeException("update nacos instance status fail", e);
        }
    }

    public Object getStatus(Registration registration) {
        String serviceName = registration.getServiceId();
        try {
            List instances = this.namingService().getAllInstances(serviceName);
            for (com.alibaba.nacos.api.naming.pojo.Instance instance : instances) {
                if (!instance.getIp().equalsIgnoreCase(this.nacosDiscoveryProperties.getIp()) || instance.getPort() != this.nacosDiscoveryProperties.getPort()) continue;
                return instance.isEnabled() ? STATUS_UP : STATUS_DOWN;
            }
        }
        catch (Exception e) {
            log.error("get all instance of {} error,", (Object)serviceName, (Object)e);
        }
        return null;
    }

    private com.alibaba.nacos.api.naming.pojo.Instance getNacosInstanceFromRegistration(Registration registration) {
        com.alibaba.nacos.api.naming.pojo.Instance instance = new com.alibaba.nacos.api.naming.pojo.Instance();
        instance.setIp(registration.getHost());
        instance.setPort(registration.getPort());
        instance.setWeight((double)this.nacosDiscoveryProperties.getWeight());
        instance.setClusterName(this.nacosDiscoveryProperties.getClusterName());
        instance.setEnabled(this.nacosDiscoveryProperties.isInstanceEnabled());
        instance.setMetadata(registration.getMetadata());
        instance.setEphemeral(this.nacosDiscoveryProperties.isEphemeral());
        instance.addMetadata("serverInstanceId", Instance.getInstanceId());
        if (this.modelInstance == null) {
            this.modelInstance = instance;
        }
        return instance;
    }

    private com.alibaba.nacos.api.naming.pojo.Instance cacheNacosModelInstance(Registration registration) {
        com.alibaba.nacos.api.naming.pojo.Instance instance = new com.alibaba.nacos.api.naming.pojo.Instance();
        instance.setIp(registration.getHost());
        instance.setPort(registration.getPort());
        instance.setWeight((double)this.nacosDiscoveryProperties.getWeight());
        instance.setClusterName(this.nacosDiscoveryProperties.getClusterName());
        instance.setEnabled(this.nacosDiscoveryProperties.isInstanceEnabled());
        instance.setMetadata(registration.getMetadata());
        instance.setEphemeral(this.nacosDiscoveryProperties.isEphemeral());
        instance.addMetadata("serverInstanceId", Instance.getInstanceId());
        if (this.modelInstance == null) {
            this.modelInstance = instance;
        }
        return instance;
    }

    private NamingService namingService() {
        return this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties());
    }

    public class NacosRegistryInfo {
        private String appName;
        private String group;
        private String appId;
        private com.alibaba.nacos.api.naming.pojo.Instance instance;

        public String getAppName() {
            return this.appName;
        }

        public NacosRegistryInfo withAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public String getGroup() {
            return this.group;
        }

        public NacosRegistryInfo withGroup(String group) {
            this.group = group;
            return this;
        }

        public com.alibaba.nacos.api.naming.pojo.Instance getInstance() {
            return this.instance;
        }

        public NacosRegistryInfo withInstance(com.alibaba.nacos.api.naming.pojo.Instance instance) {
            this.instance = instance;
            return this;
        }

        public String getAppId() {
            return this.appId;
        }

        public NacosRegistryInfo withAppId(String appId) {
            this.appId = appId;
            return this;
        }
    }
}

