/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.zookeeper;

import kd.bos.mservice.rpc.feign.registry.zookeeper.ServiceDiscoveryImpl;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;

public class ServiceDiscoveryBuilder<T> {
    private CuratorFramework client;
    private String basePath;
    private InstanceSerializer<T> serializer;
    private ServiceInstance<T> thisInstance;
    private Class<T> payloadClass;
    private boolean watchInstances = false;
    private ZookeeperDiscoveryProperties properties;

    public static <T> ServiceDiscoveryBuilder<T> builder(Class<T> payloadClass) {
        return new ServiceDiscoveryBuilder<T>(payloadClass);
    }

    public ServiceDiscovery<T> build() {
        if (this.serializer == null) {
            this.serializer((InstanceSerializer<T>)new JsonInstanceSerializer(this.payloadClass));
        }
        return new ServiceDiscoveryImpl<T>(this.client, this.serializer, this.thisInstance, this.properties);
    }

    public ServiceDiscoveryBuilder<T> client(CuratorFramework client) {
        this.client = client;
        return this;
    }

    public ServiceDiscoveryBuilder<T> basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public ServiceDiscoveryBuilder<T> serializer(InstanceSerializer<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    public ServiceDiscoveryBuilder<T> thisInstance(ServiceInstance<T> thisInstance) {
        this.thisInstance = thisInstance;
        return this;
    }

    public ServiceDiscoveryBuilder<T> watchInstances(boolean watchInstances) {
        this.watchInstances = watchInstances;
        return this;
    }

    public ServiceDiscoveryBuilder<T> properties(ZookeeperDiscoveryProperties properties) {
        this.properties = properties;
        return this;
    }

    ServiceDiscoveryBuilder(Class<T> payloadClass) {
        this.payloadClass = payloadClass;
    }
}

