/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.zookeeper;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import kd.bos.instance.Instance;
import kd.bos.mservice.rpc.feign.registry.zookeeper.DefaultServiceDiscoveryCustomizer;
import kd.bos.mservice.rpc.feign.registry.zookeeper.ServiceDiscoveryBuilder;
import kd.bos.mservice.rpc.feign.registry.zookeeper.ServiceDiscoveryImpl;
import kd.bos.mservice.rpc.feign.registry.zookeeper.ZookeeperRootPathUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceCacheBuilder;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProviderBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;

public class ServiceDiscoveryImplWrapper<T>
extends org.apache.curator.x.discovery.details.ServiceDiscoveryImpl<T> {
    private final ServiceDiscovery<ZookeeperInstance> serviceDiscovery;

    public ServiceDiscoveryImplWrapper(CuratorFramework client, InstanceSerializer<T> serializer, ZookeeperDiscoveryProperties properties, DefaultServiceDiscoveryCustomizer discoveryCustomizer) {
        super(client, System.getProperty("spring.cloud.zookeeper.discovery.root", ZookeeperRootPathUtils.getZkPrePath() + (String)Preconditions.checkNotNull((Object)properties.getRoot(), (Object)"basePath cannot be null") + "/" + Instance.getClusterName()), serializer, null, false);
        this.serviceDiscovery = discoveryCustomizer.customize(ServiceDiscoveryBuilder.builder(ZookeeperInstance.class));
    }

    public void start() throws Exception {
        this.serviceDiscovery.start();
    }

    public void close() throws IOException {
        this.serviceDiscovery.close();
    }

    public void registerService(ServiceInstance service) throws Exception {
        this.serviceDiscovery.registerService(service);
    }

    public void updateService(ServiceInstance service) throws Exception {
        this.serviceDiscovery.updateService(service);
    }

    protected void internalRegisterService(ServiceInstance service) throws Exception {
        ServiceDiscoveryImpl serviceDiscoveryImpl = (ServiceDiscoveryImpl)this.serviceDiscovery;
        serviceDiscoveryImpl.internalRegisterService(service);
    }

    public void unregisterService(ServiceInstance service) throws Exception {
        this.serviceDiscovery.unregisterService(service);
    }

    public ServiceProviderBuilder serviceProviderBuilder() {
        return this.serviceDiscovery.serviceProviderBuilder();
    }

    public ServiceCacheBuilder serviceCacheBuilder() {
        return this.serviceDiscovery.serviceCacheBuilder();
    }

    public Collection<String> queryForNames() throws Exception {
        return this.serviceDiscovery.queryForNames();
    }

    public Collection<ServiceInstance<T>> queryForInstances(String name) throws Exception {
        return super.queryForInstances(name);
    }

    public ServiceInstance queryForInstance(String name, String id) throws Exception {
        return this.serviceDiscovery.queryForInstance(name, id);
    }
}

