/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.registry.zookeeper;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kd.bos.mservice.rpc.feign.registry.zookeeper.ZookeeperRootPathUtils;
import kd.bos.zk.ZKFactory;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.GetACLBuilder;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetConfigBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.api.ReconfigBuilder;
import org.apache.curator.framework.api.RemoveWatchesBuilder;
import org.apache.curator.framework.api.SetACLBuilder;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.curator.framework.api.SyncBuilder;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.WatchesBuilder;
import org.apache.curator.framework.api.transaction.CuratorMultiTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.schema.SchemaSet;
import org.apache.curator.framework.state.ConnectionStateErrorPolicy;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.EnsurePath;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.zookeeper.ZookeeperProperties;

public class ZookeeperRegistryClient
implements CuratorFramework {
    @Autowired(required=false)
    private EnsembleProvider ensembleProvider;
    private CuratorFramework zkClient;

    public ZookeeperRegistryClient(RetryPolicy retryPolicy, ZookeeperProperties properties) throws Exception {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        if (this.ensembleProvider != null) {
            builder.ensembleProvider(this.ensembleProvider);
        }
        this.zkClient = ZKFactory.getZKClient((String)properties.getConnectString());
        ZookeeperRootPathUtils.setZkPrePath(ZKFactory.getZkRootPath((String)properties.getConnectString()));
        this.zkClient.blockUntilConnected(properties.getBlockUntilConnectedWait().intValue(), properties.getBlockUntilConnectedUnit());
    }

    public void start() {
        this.zkClient.start();
    }

    public void close() {
        this.zkClient.close();
    }

    public CuratorFrameworkState getState() {
        return this.zkClient.getState();
    }

    public boolean isStarted() {
        return this.zkClient.isStarted();
    }

    public CreateBuilder create() {
        return this.zkClient.create();
    }

    public DeleteBuilder delete() {
        return this.zkClient.delete();
    }

    public ExistsBuilder checkExists() {
        return this.zkClient.checkExists();
    }

    public GetDataBuilder getData() {
        return this.zkClient.getData();
    }

    public SetDataBuilder setData() {
        return this.zkClient.setData();
    }

    public GetChildrenBuilder getChildren() {
        return this.zkClient.getChildren();
    }

    public GetACLBuilder getACL() {
        return this.zkClient.getACL();
    }

    public SetACLBuilder setACL() {
        return this.zkClient.setACL();
    }

    public ReconfigBuilder reconfig() {
        return this.zkClient.reconfig();
    }

    public GetConfigBuilder getConfig() {
        return this.zkClient.getConfig();
    }

    public CuratorTransaction inTransaction() {
        return this.zkClient.inTransaction();
    }

    public CuratorMultiTransaction transaction() {
        return this.zkClient.transaction();
    }

    public TransactionOp transactionOp() {
        return this.zkClient.transactionOp();
    }

    public void sync(String path, Object backgroundContextObject) {
        this.zkClient.sync(path, backgroundContextObject);
    }

    public void createContainers(String path) throws Exception {
        this.zkClient.createContainers(path);
    }

    public SyncBuilder sync() {
        return this.zkClient.sync();
    }

    public RemoveWatchesBuilder watches() {
        return this.zkClient.watches();
    }

    public WatchesBuilder watchers() {
        return this.zkClient.watchers();
    }

    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.zkClient.getConnectionStateListenable();
    }

    public Listenable<CuratorListener> getCuratorListenable() {
        return this.zkClient.getCuratorListenable();
    }

    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return this.zkClient.getUnhandledErrorListenable();
    }

    public CuratorFramework nonNamespaceView() {
        return this.zkClient.nonNamespaceView();
    }

    public CuratorFramework usingNamespace(String newNamespace) {
        return this.zkClient.usingNamespace(newNamespace);
    }

    public String getNamespace() {
        return this.zkClient.getNamespace();
    }

    public CuratorZookeeperClient getZookeeperClient() {
        return this.zkClient.getZookeeperClient();
    }

    public EnsurePath newNamespaceAwareEnsurePath(String path) {
        return this.zkClient.newNamespaceAwareEnsurePath(path);
    }

    public void clearWatcherReferences(Watcher watcher) {
        this.zkClient.clearWatcherReferences(watcher);
    }

    public boolean blockUntilConnected(int maxWaitTime, TimeUnit units) throws InterruptedException {
        return this.zkClient.blockUntilConnected(maxWaitTime, units);
    }

    public void blockUntilConnected() throws InterruptedException {
        this.zkClient.blockUntilConnected();
    }

    public WatcherRemoveCuratorFramework newWatcherRemoveCuratorFramework() {
        return this.zkClient.newWatcherRemoveCuratorFramework();
    }

    public ConnectionStateErrorPolicy getConnectionStateErrorPolicy() {
        return this.zkClient.getConnectionStateErrorPolicy();
    }

    public QuorumVerifier getCurrentConfig() {
        return this.zkClient.getCurrentConfig();
    }

    public SchemaSet getSchemaSet() {
        return this.zkClient.getSchemaSet();
    }

    public CompletableFuture<Void> postSafeNotify(Object monitorHolder) {
        return this.zkClient.postSafeNotify(monitorHolder);
    }

    public CompletableFuture<Void> runSafe(Runnable runnable) {
        return this.zkClient.runSafe(runnable);
    }
}

