/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.circuitbreaker;

import java.lang.reflect.InvocationTargetException;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.circuitbreaker.CircuitbreakerFactory;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.rpc.interceptor.FeignCall;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;
import kd.bos.mservice.spi.circuitbreaker.Circuitbreaker;

@Intercept(group="provider", order=10)
public class ProviderCircuitbreakerInterceptor
extends AbstractLinkedInterceptor {
    public Object handle(CommonRpcParam commonRpcParam, FeignCall feignCall) {
        String[] serviceMethodArr = super.getProviderServiceAndMethodName(commonRpcParam);
        String serviceName = serviceMethodArr[0];
        String methodName = serviceMethodArr[1];
        String ident = serviceName + ":" + methodName;
        try (Circuitbreaker breaker = CircuitbreakerFactory.get((String)"RpcService", (String)this.getTenantId(), (String)commonRpcParam.getAppId()).withName(ident).begin();){
            Object object = breaker.call(() -> {
                try {
                    return super.handle(commonRpcParam, feignCall);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    throw new KDException(e, BosErrorCode.bOS, new Object[]{e.getMessage()});
                }
            });
            return object;
        }
    }

    private String getTenantId() {
        String tenantId = null;
        RequestContext requestContext = RequestContext.get();
        if (requestContext != null) {
            tenantId = requestContext.getTenantId();
        }
        return tenantId;
    }
}

