/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.exception;

import kd.bos.context.RequestTimeoutContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.TerminationEvent;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.rpc.interceptor.FeignCall;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;

@Intercept(group="consumer", order=10)
public class ConsumerExceptionHandleInterceptor
extends AbstractLinkedInterceptor {
    public Object handle(CommonRpcParam params, FeignCall feignCall) throws Throwable {
        try {
            return super.handle(params, feignCall);
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw e;
            }
            if (e instanceof RpcException) {
                if (e instanceof RpcException.RpcTimeoutException) {
                    RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
                    if (requestTimeoutContext != null && requestTimeoutContext.isWebRequest() && requestTimeoutContext.isAutomaticTimeout()) {
                        EventDataReporter.report((EventType)TerminationEvent.WebAutoTimeoutEvent.getInstance(), (String)((RpcException)e).getErrorMessage(), (Throwable)e);
                    } else {
                        EventDataReporter.report((EventType)TerminationEvent.RpcTimeoutEvent.getInstance(), (String)((RpcException)e).getErrorMessage(), (Throwable)e);
                    }
                }
                if (e.getCause() instanceof KDException) {
                    throw e.getCause();
                }
                throw new KDException(e, BosErrorCode.bOS, new Object[]{((RpcException)e).getErrorMessage()});
            }
            throw new KDException(e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
    }
}

