/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.thread;

import kd.bos.cache.redis.CacheLimiter;
import kd.bos.context.RequestContext;
import kd.bos.db.DBLimiter;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.rpc.interceptor.FeignCall;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;
import kd.bos.thread.OutOfMemoryObserver;
import kd.bos.thread.SetThreadName;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.util.TraceIdUtil;

@Intercept(group="provider", order=1)
public class ProviderThreadLifeCycleInterceptor
extends AbstractLinkedInterceptor {
    public Object handle(CommonRpcParam params, FeignCall feignCall) throws Throwable {
        try {
            ThreadLifeCycleManager.start();
            this.modifyCurrentThreadName();
            CacheLimiter.init();
            DBLimiter.init();
            Object object = super.handle(params, feignCall);
            return object;
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryObserver.onOutOfMemory((OutOfMemoryError)e);
            throw e;
        }
        finally {
            ThreadLifeCycleManager.end();
        }
    }

    private void modifyCurrentThreadName() {
        TraceIdUtil.setCurrentTraceId((String)RequestContext.get().getTraceId());
        SetThreadName.convertHttpToRpcServer();
    }
}

