/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.trace;

import java.util.Map;
import kd.bos.instance.Instance;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.SpanInjector;
import kd.bos.util.NetAddressUtils;

public class FeignSpanInjector
implements SpanInjector<CommonRpcParam> {
    private static String ip = NetAddressUtils.getLocalIpAddress();

    public void inject(InnerSpan span, CommonRpcParam commonRpcParam) {
        Long parentId;
        long spanId;
        Map attachments = commonRpcParam.getAttachments();
        long traceId = span.getTraceId();
        if (traceId != 0L) {
            attachments.put("X-B3-TraceId", InnerSpan.idToHex((long)traceId));
        }
        if ((spanId = span.getSpanId()) != 0L) {
            attachments.put("X-B3-SpanId", InnerSpan.idToHex((long)spanId));
        }
        attachments.put("X-Span-Name", span.getName());
        attachments.put("X-B3-Sampled", span.isExportable() ? "1" : "0");
        attachments.put("service", span.tags().get("service"));
        attachments.put("consumer.appName", Instance.getAppName());
        attachments.put("consumer.ip", ip);
        Long l = parentId = span.getParents().size() > 0 ? (Long)span.getParents().get(0) : null;
        if (parentId != null && parentId != 0L) {
            attachments.put("X-B3-ParentSpanId", InnerSpan.idToHex((long)parentId));
        }
        attachments.put("X-Process-Id", span.getProcessId());
    }
}

