/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptors.trace;

import java.util.Map;
import kd.bos.govern.GovernConfigs;
import kd.bos.mservice.common.rpc.param.CommonRpcParam;
import kd.bos.mservice.rpc.handshake.entity.RequestStatus;
import kd.bos.mservice.rpc.interceptor.FeignCall;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;
import kd.bos.mservice.rpc.interceptors.trace.FeignSpanExtractor;
import kd.bos.mservice.rpc.interceptors.trace.FeignSpanInjector;
import kd.bos.service.DispatchService;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.core.InnerFactory;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.Sampler;
import kd.bos.trace.sampler.NeverSampler;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

@Intercept(group="provider", order=2000)
public class ProviderSpanInterceptor
extends AbstractLinkedInterceptor {
    private static String ip = NetAddressUtils.getLocalIpAddress();
    private FeignSpanInjector spanInjector = new FeignSpanInjector();
    private FeignSpanExtractor spanExtractor = new FeignSpanExtractor();

    private static String getServiceName(String serviceName) {
        if (DispatchService.class.getName().equals(serviceName)) {
            return "RpcService";
        }
        return serviceName.substring(serviceName.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(CommonRpcParam params, FeignCall feignCall) throws Throwable {
        boolean isContinue = TraceConfig.isTraceEnable() || GovernConfigs.getTopologyEnable() || GovernConfigs.getApicallEnable() || GovernConfigs.getBreakerEnable();
        InnerTracer tracer = null;
        InnerSpan parentSpan = null;
        InnerSpan childSpan = null;
        try {
            tracer = InnerFactory.getTracer();
            if (isContinue) {
                String spanName = "provider(" + ip + ")";
                StringBuilder serviceNameBuild = new StringBuilder(spanName);
                String appId = params.getAppId();
                serviceNameBuild.append("[");
                if (StringUtils.isNotEmpty((String)appId)) {
                    serviceNameBuild.append(appId).append(".");
                }
                String[] serviceMethodArr = super.getProviderServiceAndMethodName(params);
                String serviceName = serviceMethodArr[0];
                String methodName = serviceMethodArr[1];
                serviceNameBuild.append(serviceName).append(".").append(methodName).append("]");
                parentSpan = this.spanExtractor.joinTrace(params);
                if (parentSpan != null) {
                    childSpan = tracer.createSpan(serviceNameBuild.toString(), parentSpan, true);
                    parentSpan.logEvent("sr");
                    childSpan.tag("consumer.appName", (String)parentSpan.tags().get("consumer.appName"));
                } else {
                    Map attachments = params.getAttachments();
                    boolean skip = "0".equals(attachments.get("X-B3-Sampled"));
                    childSpan = skip ? tracer.createSpan(spanName, (Sampler)NeverSampler.INSTANCE) : tracer.createSpan(serviceNameBuild.toString(), true);
                    childSpan.logEvent("sr");
                }
                childSpan.tag("service", ProviderSpanInterceptor.getServiceName(params.getInterfaceName()));
                this.spanInjector.inject(childSpan, params);
            }
            String appId = params.getAppId();
            RequestStatus.requestApp((String)appId);
            Object object = super.handle(params, feignCall);
            return object;
        }
        finally {
            if (isContinue) {
                if (parentSpan != null) {
                    parentSpan.logEvent("ss");
                    parentSpan.stop();
                } else if (childSpan != null) {
                    childSpan.logEvent("ss");
                }
                if (childSpan != null) {
                    tracer.close(childSpan);
                }
            }
        }
    }
}

