/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.starter;

import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.framework.lifecycle.Service;
import kd.bos.util.SystemProperties;
import kd.bos.xcache.starter.NoopXCacheService;
import kd.bos.xcache.starter.RealXCacheService;
import kd.bos.xcache.starter.exception.XCacheErrorCodes;
import kd.bos.xcache.starter.util.ErrorUtil;
import kd.bos.xcache.starter.util.SleepUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCacheService
implements Service {
    private static final Logger log = LoggerFactory.getLogger(XCacheService.class);
    public static final String XCACHE_ENABLE = "xcache_enable";
    public static final int DEFAULT_RETRY_TIMES = 5;
    public static final String CACHE_TEST_KEY = "_cache_test_";
    private Service delegate = this.isServiceEnabled() ? new RealXCacheService() : new NoopXCacheService();

    public String getName() {
        return this.delegate.getName();
    }

    public void start() {
        this.delegate.start();
        this.clientCheckXCacheService();
    }

    private void clientCheckXCacheService() {
        if (!CacheConfigKeys.isXCacheClientEnabled()) {
            return;
        }
        int checkTimes = 0;
        Exception exception = null;
        do {
            try {
                SleepUtil.sleepSeconds(10 * checkTimes);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((exception = XCacheService.checkCacheAvailable()) != null && ++checkTimes <= 5);
        if (exception != null) {
            ErrorUtil.logErrorAndExit(log, exception, XCacheErrorCodes.CACHE_SERVER_NOT_READY_ERROR);
        }
    }

    private static Exception checkCacheAvailable() {
        try {
            DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            distributeSessionlessCache.contains(CACHE_TEST_KEY);
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    public void stop() {
        this.delegate.stop();
    }

    public boolean isStarted() {
        return this.delegate.isStarted();
    }

    private boolean isServiceEnabled() {
        return Boolean.parseBoolean(SystemProperties.getWithEnv((String)XCACHE_ENABLE));
    }
}

