/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.starter.elect;

import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectorService {
    private static final Logger log = LoggerFactory.getLogger(ElectorService.class);
    private final Elector elector;

    public ElectorService(String groupName) {
        this.elector = ElectFactory.getElector((String)String.format("xcache_%s", groupName));
    }

    public void start() {
        this.elector.registerListener(new ElectorListener(){

            public void notifyMaster() {
                log.info("This XCache service node become master");
            }

            public void notifyLostMaster() {
                log.info("This XCache service node lost master");
            }
        });
        this.elector.start();
    }

    public void stop() {
        this.elector.close();
    }
}

