/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import kd.bos.db.RequestContextInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.LimiterUtil;
import kd.bos.util.StringUtils;

public class DBLimiter {
    private static final Log log = LogFactory.getLog(DBLimiter.class);
    public static final String LIMIT_ENABLE = "db.limit.enable";
    public static final String MAX_COUNT = "db.limit.maxCount";
    private static final String WARN_THRESHOLD = "db.limit.warn.threshold";
    private static final String DB_ACCESS_COUNT = "DB_ACCESS_COUNT";
    public static final int DEFAULT_MAX_COUNT = 20000;
    private static final int DEFAULT_WARN_THRESHOLD = 80;

    public static void checkCount() {
        if (DBLimiter.isLimit()) {
            Object count = ThreadTruck.get((Object)DB_ACCESS_COUNT);
            if (count == null) {
                return;
            }
            int accessCount = (Integer)count;
            if (accessCount >= DBLimiter.getMaxCount()) {
                String msg = "Operate was terminated by DB Limiter. maxCount: " + DBLimiter.getMaxCount();
                EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
                throw new KDException(BosErrorCode.dbOverMaxCount, new Object[]{msg});
            }
            ThreadTruck.put((Object)DB_ACCESS_COUNT, (Object)(++accessCount));
        }
    }

    public static void init() {
        Object count;
        if (DBLimiter.isLimit() && (count = ThreadTruck.get((Object)DB_ACCESS_COUNT)) == null) {
            ThreadTruck.put((Object)DB_ACCESS_COUNT, (Object)0);
        }
    }

    public static void end() {
        int accessCount;
        Object count;
        if (DBLimiter.isLimit() && (count = ThreadTruck.get((Object)DB_ACCESS_COUNT)) != null && (accessCount = ((Integer)count).intValue()) < DBLimiter.getMaxCount() && accessCount >= DBLimiter.getWarnCount()) {
            log.warn("DB access count exceeds the warning threshold. access count: " + accessCount + ", warning threshold: " + DBLimiter.getWarnCount());
        }
    }

    private static int getMaxCount() {
        int ret;
        try {
            String key;
            String tenantMaxCount;
            String tenantId = DBLimiter.getTenantId();
            ret = !StringUtils.isEmpty((String)tenantId) ? (!StringUtils.isEmpty((String)(tenantMaxCount = System.getProperty(key = tenantId + "_" + MAX_COUNT))) ? Integer.parseInt(tenantMaxCount) : Integer.getInteger(MAX_COUNT, 20000)) : Integer.getInteger(MAX_COUNT, 20000);
        }
        catch (Exception e) {
            ret = 20000;
        }
        return ret;
    }

    public static boolean isLimit() {
        boolean enable = false;
        String limitEnable = System.getProperty(LIMIT_ENABLE);
        if (!StringUtils.isEmpty((String)limitEnable)) {
            enable = Boolean.parseBoolean(limitEnable);
        } else {
            String tenantId = DBLimiter.getTenantId();
            if (!StringUtils.isEmpty((String)tenantId)) {
                String key = tenantId + "_" + LIMIT_ENABLE;
                enable = Boolean.parseBoolean(System.getProperty(key, "false"));
            }
        }
        return LimiterUtil.isSystemBootFinish() && enable;
    }

    private static int getWarnCount() {
        int threshold = DBLimiter.thresholdRestrict(Integer.getInteger(WARN_THRESHOLD, 80));
        try {
            return DBLimiter.getMaxCount() * threshold / 100;
        }
        catch (Exception e) {
            log.error("DB get warn count error.", (Throwable)e);
            return DBLimiter.getMaxCount();
        }
    }

    private static int thresholdRestrict(int threshold) {
        if (threshold < 50 || threshold > 100) {
            threshold = 100;
        }
        return threshold;
    }

    private static String getTenantId() {
        String tenantId = null;
        try {
            RequestContextInfo request = RequestContextInfo.get();
            if (request != null) {
                tenantId = request.getTenantId();
            }
        }
        catch (Exception e) {
            return null;
        }
        return tenantId;
    }
}

