/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.util.AlgoSystemInit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataSetDataType {
    private static Map<Class<?>, DataType> baseDataTypeMap;
    private static final Log log;

    public static DataType getDataType(Class<?> cls) {
        do {
            DataType dt;
            if ((dt = baseDataTypeMap.get(cls)) != null) {
                return dt;
            }
            if (Blob.class.isAssignableFrom(cls)) {
                return DataType.AnyType;
            }
            if (!Clob.class.isAssignableFrom(cls)) continue;
            return DataType.StringType;
        } while ((cls = cls.getSuperclass()) != null);
        return DataType.StringType;
    }

    static {
        log = LogFactory.getLog((String)"DB");
        AlgoSystemInit.init();
        baseDataTypeMap = new HashMap();
        baseDataTypeMap.put(Integer.TYPE, (DataType)DataType.IntegerType);
        baseDataTypeMap.put(Integer.class, (DataType)DataType.IntegerType);
        baseDataTypeMap.put(Clob.class, (DataType)DataType.StringType);
        baseDataTypeMap.put(Blob.class, (DataType)DataType.AnyType);
        baseDataTypeMap.put(Long.TYPE, (DataType)DataType.LongType);
        baseDataTypeMap.put(Long.class, (DataType)DataType.LongType);
        baseDataTypeMap.put(byte[].class, (DataType)DataType.AnyType);
        baseDataTypeMap.put(Boolean.TYPE, (DataType)DataType.BooleanType);
        baseDataTypeMap.put(Boolean.class, (DataType)DataType.BooleanType);
        baseDataTypeMap.put(String.class, (DataType)DataType.StringType);
        baseDataTypeMap.put(Integer.TYPE, (DataType)DataType.IntegerType);
        baseDataTypeMap.put(Integer.class, (DataType)DataType.IntegerType);
        baseDataTypeMap.put(Long.TYPE, (DataType)DataType.LongType);
        baseDataTypeMap.put(Long.class, (DataType)DataType.LongType);
        baseDataTypeMap.put(Double.TYPE, (DataType)DataType.DoubleType);
        baseDataTypeMap.put(Double.class, (DataType)DataType.DoubleType);
        baseDataTypeMap.put(BigDecimal.class, (DataType)DataType.BigDecimalType);
        baseDataTypeMap.put(BigInteger.class, (DataType)DataType.BigDecimalType);
        baseDataTypeMap.put(Number.class, (DataType)DataType.BigDecimalType);
        baseDataTypeMap.put(Date.class, (DataType)DataType.TimestampType);
        baseDataTypeMap.put(java.sql.Date.class, (DataType)DataType.TimestampType);
        baseDataTypeMap.put(Timestamp.class, (DataType)DataType.TimestampType);
    }
}

