/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import kd.bos.db.RequestContextInfo;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.temptable.pk.PKTempTableHint;

public final class HugeInConfig4DB {
    private static final String orm_opt_in_enable = "orm.opt.in.enable";
    private static final String orm_opt_in_type = "orm.opt.in.type";
    private static final String orm_opt_in_threshold = "orm.opt.in.threshold";
    private static final String orm_opt_in_maxsize = "orm.opt.in.maxsize";
    private static final String orm_opt_in_paramWithSql = "orm.opt.in.paramWithSql";
    private static boolean enableOptIn = true;
    private static OptType optType = OptType.temp_table;
    private static int inThresholdSize = 2000;
    private static int inQueryMaxSize = 500000;
    private static boolean inParamWithSql = true;

    public static int inThreshold() {
        PKTempTableHint hint = PKTempTableHint.get();
        if (hint != null) {
            return hint.getThreshold();
        }
        try {
            String tenantId = RequestContextInfo.get().getTenantId();
            String tenantProperty = System.getProperty(tenantId + "_" + orm_opt_in_threshold);
            if (tenantProperty != null) {
                return Integer.parseInt(tenantProperty);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inThresholdSize;
    }

    public static boolean isToTemp(int paramLength) {
        return paramLength > HugeInConfig4DB.inThreshold();
    }

    public static int inMaxSize() {
        return inQueryMaxSize;
    }

    public static boolean isEnableOpt() {
        return enableOptIn && inThresholdSize > 0;
    }

    public static OptType getOptType() {
        return optType;
    }

    public static boolean isParamWithSql() {
        return inParamWithSql;
    }

    static {
        ConfigurationUtil.observeBoolean((String)orm_opt_in_enable, (boolean)enableOptIn, b -> {
            enableOptIn = b;
        });
        ConfigurationUtil.observeInteger((String)orm_opt_in_threshold, (int)inThresholdSize, v -> {
            inThresholdSize = v <= 0 ? Integer.MAX_VALUE : v;
        });
        ConfigurationUtil.observeInteger((String)orm_opt_in_maxsize, (int)inQueryMaxSize, v -> {
            inQueryMaxSize = v <= 0 ? Integer.MAX_VALUE : v;
        });
        ConfigurationUtil.observeString((String)orm_opt_in_type, (String)optType.toString(), v -> {
            optType = OptType.from(v);
        });
        ConfigurationUtil.observeBoolean((String)orm_opt_in_paramWithSql, (boolean)inParamWithSql, b -> {
            inParamWithSql = b;
        });
    }

    public static enum OptType {
        temp_table("temp"),
        split_in("split");

        private String id;

        private OptType(String id) {
            this.id = id;
        }

        public static OptType from(String value) {
            if (OptType.split_in.id.equals(value)) {
                return split_in;
            }
            return temp_table;
        }
    }
}

