/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.util.Collections;
import java.util.List;

public final class IndexInfo {
    private final String indexName;
    private final List<IndexFieldInfo> indexFieldInfo;

    IndexInfo(String indexName, List<IndexFieldInfo> indexFieldInfo) {
        this.indexName = indexName;
        this.indexFieldInfo = indexFieldInfo;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<IndexFieldInfo> getIndexFieldInfo() {
        return Collections.unmodifiableList(this.indexFieldInfo);
    }

    void addIndexFieldInfo(IndexFieldInfo fieldInfo) {
        this.indexFieldInfo.add(fieldInfo);
    }

    public static final class IndexFieldInfo {
        private final String fieldName;
        private final String sortType;
        private final boolean isDesc;

        IndexFieldInfo(String fieldName, String sortType) {
            this.fieldName = fieldName;
            this.sortType = sortType;
            this.isDesc = "DESC".equals(sortType);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean isDesc() {
            return this.isDesc;
        }

        public String getSortType() {
            return this.sortType;
        }
    }
}

