/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Proxy;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.db.DBType;
import kd.bos.db.DataSetDataType;
import kd.bos.exception.SecureExceptionUtil;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.WrapCloseResultSet;

public class QueryMeta {
    private static final boolean DECIMAL_AUTO_LONG = Boolean.parseBoolean(System.getProperty("orm.decimal_auto_long", "true"));
    private Map<Field, Converter> convertFunctions;
    private RowMeta rowMeta;

    static QueryMeta createOrFixQueryMeta(QueryMeta qm, ResultSet rs, DBType dbType) {
        try {
            ResultSetMetaData md = rs.getMetaData();
            if (qm == null) {
                int col = md.getColumnCount();
                Field[] fs = new Field[col];
                if (DECIMAL_AUTO_LONG && (dbType == DBType.Oracle || dbType == DBType.DM || dbType == DBType.GS100 || dbType == DBType.OceanBase_Oracle)) {
                    for (int i = 1; i <= col; ++i) {
                        String typeName = md.getColumnClassName(i);
                        Class<Object> typeCls = "java.math.BigDecimal".equals(typeName) && md.getPrecision(i) == 19 && md.getScale(i) == 0 ? Long.class : Class.forName(typeName);
                        fs[i - 1] = new Field(md.getColumnLabel(i), DataSetDataType.getDataType(typeCls));
                    }
                } else {
                    for (int i = 1; i <= col; ++i) {
                        String typeName = md.getColumnClassName(i);
                        Class<?> typeCls = Class.forName(typeName);
                        fs[i - 1] = new Field(md.getColumnLabel(i), DataSetDataType.getDataType(typeCls));
                    }
                }
                qm = new QueryMeta();
                qm.setRowMeta(new RowMeta(fs));
            } else {
                int i = 0;
                for (Field f : qm.rowMeta.getFields()) {
                    ++i;
                    if (f.getDataType() != DataType.UnknownType) continue;
                    f.setDataType(DataSetDataType.getDataType(Class.forName(md.getColumnClassName(i))));
                }
            }
            return qm;
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void setTransFunction(Field field, Converter converter) {
        if (this.convertFunctions == null) {
            this.convertFunctions = new HashMap<Field, Converter>();
        }
        this.convertFunctions.put(field, converter);
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public ResultSet convertResultSet(ResultSet rs) {
        if (!(rs instanceof WrapCloseResultSet)) {
            try {
                rs = new WrapCloseResultSet(rs, null);
            }
            catch (SQLException e) {
                throw SecureExceptionUtil.wrapSQLException((SQLException)e);
            }
        }
        if (this.convertFunctions != null) {
            HashMap<String, Converter> namedConverterMap = new HashMap<String, Converter>();
            HashMap<Integer, Converter> indexiedConverterMap = new HashMap<Integer, Converter>();
            int n = this.rowMeta.getFieldCount();
            for (int i = 0; i < n; ++i) {
                Field field = this.rowMeta.getField(i);
                Converter func = this.convertFunctions.get(field);
                if (func == null) continue;
                namedConverterMap.put(field.getName().toLowerCase(), func);
                indexiedConverterMap.put(i + 1, func);
            }
            ResultSet innerRS = rs;
            return (ResultSet)Proxy.newProxyInstance(ResultSet.class.getClassLoader(), new Class[]{ResultSet.class}, (proxy, method, args) -> {
                String name = method.getName();
                if (args != null && name.startsWith("get")) {
                    Object v1 = args[0];
                    if (v1 instanceof String) {
                        Converter converter = (Converter)namedConverterMap.get(((String)v1).toLowerCase());
                        if (converter != null) {
                            Object value = innerRS.getObject((String)v1);
                            if (value instanceof Clob) {
                                value = this.readClob((Clob)value);
                            }
                            return converter.convert(value);
                        }
                    } else {
                        Converter converter = (Converter)indexiedConverterMap.get((Integer)v1);
                        if (converter != null) {
                            Object value = innerRS.getObject((Integer)v1);
                            if (value instanceof Clob) {
                                value = this.readClob((Clob)value);
                            }
                            return converter.convert(value);
                        }
                    }
                }
                return method.invoke((Object)innerRS, args);
            });
        }
        return rs;
    }

    private String readClob(Clob clob) throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        try (Reader reader = clob.getCharacterStream();){
            int size;
            char[] buf = new char[12];
            while ((size = reader.read(buf)) != -1) {
                sb.append(buf, 0, size);
            }
        }
        return sb.toString();
    }

    public static interface Converter {
        public Object convert(Object var1);
    }
}

