/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.config.client.util.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.HugeInConfig4DB;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.pktemptable.utils.TableVariableUtil;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.db.tx.DBTypeTransUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.temptable.facade.TemptableFacade;
import kd.bos.xdb.temptable.facade.TemptableFacades;
import kd.bos.xdb.temptable.facade.TemptableType;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SqlBuilder {
    private static final Log log = LogFactory.getLog(SqlBuilder.class);
    private List<Seg> segs = new ArrayList<Seg>();

    public SqlBuilder append(String sqlPart, List<Object> params) {
        return this.append(sqlPart, params.toArray(new Object[0]));
    }

    public SqlBuilder append(String sqlPart, Object ... params) {
        Seg seg = new Seg();
        seg.sqlPart = sqlPart;
        Seg.access$202(seg, params);
        this.segs.add(seg);
        return this;
    }

    public SqlBuilder appendIn(String field, List<Object> inValues) {
        return this.appendIn(field, inValues.toArray(new Object[0]));
    }

    public SqlBuilder appendIn(String field, Object[] inValues) {
        Seg seg = new Seg();
        seg.isIn = true;
        if (StringUtils.isEmpty((String)field)) {
            seg.sqlPart = "";
        } else {
            seg.sqlPart = " " + field;
        }
        Seg.access$202(seg, inValues);
        this.segs.add(seg);
        return this;
    }

    @SdkInternal
    SqlObject genSQLObject(DBRoute dbRoute) {
        DBType dbType = this.getDBType(dbRoute);
        StringBuilder sb = new StringBuilder();
        ArrayList<TemptableFacade> tempTableReleaseList = new ArrayList<TemptableFacade>(this.segs.size());
        for (Seg seg : this.segs) {
            seg.gen(dbType, tempTableReleaseList);
            if (seg.sqlPart.charAt(0) != ' ') {
                sb.append(' ');
            }
            sb.append(seg.sqlPart);
        }
        SqlParameter[] ps = this.getSQLParams(dbType);
        return new SqlObject(sb.toString(), ps, tempTableReleaseList);
    }

    private DBType getDBType(DBRoute dbRoute) {
        RequestContextInfo rc = RequestContextInfo.get();
        DataSourceInfo dataSourceInfo = DataSourceFactory.getDataSource(rc.getTenantId(), dbRoute.getRouteKey(), rc.getAccountId(), false);
        return DBTypeTransUtils.trans(dataSourceInfo.getDBConfig().getDBType());
    }

    private SqlParameter[] getSQLParams(DBType dbType) {
        ArrayList<SqlParameter> list = new ArrayList<SqlParameter>();
        for (Seg seg : this.segs) {
            Object[] ps = seg.params;
            if (ps == null || ps.length <= 0) continue;
            if (seg.isIn && seg.isToTemp() && TableVariableUtil.allowSetTableVariableParams(dbType)) {
                int i;
                SqlParameter parameter = new SqlParameter(ps);
                if (ps[0] instanceof String) {
                    parameter.setDbType(12);
                    if (!(ps instanceof String[])) {
                        HashSet<String> set = new HashSet<String>(500);
                        for (i = 0; i < ps.length; ++i) {
                            set.add(ps[i].toString());
                        }
                        parameter.setValue(set.toArray(new String[set.size()]));
                    }
                } else {
                    HashSet<Long> set = new HashSet<Long>(500);
                    parameter.setDbType(-5);
                    for (i = 0; i < ps.length; ++i) {
                        set.add(Long.parseLong(ps[i].toString()));
                    }
                    parameter.setValue(set.toArray(new Long[set.size()]));
                }
                list.add(parameter);
                continue;
            }
            for (Object p : ps) {
                SqlParameter parameter = new SqlParameter(p);
                list.add(parameter);
            }
        }
        return list.toArray(new SqlParameter[0]);
    }

    public SqlBuilder appendSqlBuilder(SqlBuilder sqlBuilder) {
        if (sqlBuilder != null) {
            this.segs.addAll(sqlBuilder.getSegs());
        }
        return this;
    }

    boolean isUseTempTable() {
        for (Seg seg : this.segs) {
            if (!seg.isIn || !seg.isToTemp()) continue;
            return true;
        }
        return false;
    }

    private List<Seg> getSegs() {
        return this.segs;
    }

    private List<Object> getParams() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Seg seg : this.segs) {
            Object[] ps = seg.params;
            if (ps == null) continue;
            for (Object p : ps) {
                list.add(p);
            }
        }
        return list;
    }

    String getMockSQL() {
        StringBuilder sb = new StringBuilder();
        for (Seg seg : this.segs) {
            String mockSql = seg.mockSQL();
            if (mockSql.charAt(0) != ' ') {
                sb.append(' ');
            }
            sb.append(mockSql);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getMockSQL() + "\n" + this.getParams();
    }

    public boolean isEmpty() {
        return this.segs.isEmpty();
    }

    private class Seg {
        private boolean isIn;
        private boolean isInGenned;
        private String sqlPart;
        private Object[] params;

        private Seg() {
        }

        void gen(DBType dbType, List<TemptableFacade> tempTableReleaseList) {
            if (!this.isIn || this.isInGenned) {
                return;
            }
            if (this.isToTemp() && (ThreadReadWriteContext.isAllowUseTempTable() || TableVariableUtil.allowUseTableVariable(dbType))) {
                if (TableVariableUtil.allowUseTableVariable(dbType)) {
                    if (dbType == DBType.oracle) {
                        this.sqlPart = this.sqlPart + " IN (SELECT COLUMN_VALUE FROM UDT_INTTABLE(?))";
                        this.params = new Object[]{this.params};
                    } else if (TableVariableUtil.isDMDbType(dbType)) {
                        this.sqlPart = this.sqlPart + " IN (SELECT TV.COLUMN_VALUE FROM UDT_INTTABLE(?) as TV)";
                        this.params = new Object[]{this.params};
                    } else if (this.params[0] instanceof String && TableVariableUtil.enableStringMaxSize(this.params.length)) {
                        this.sqlPart = this.sqlPart + " IN (SELECT FID FROM UDT_VARCHARTABLE(?)) ";
                    } else if (this.params[0] instanceof Integer || this.params[0] instanceof Long) {
                        this.sqlPart = this.sqlPart + " IN (SELECT FID FROM UDT_INTTABLE(?)) ";
                    } else {
                        this.useTempTable(tempTableReleaseList);
                    }
                } else {
                    this.useTempTable(tempTableReleaseList);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder(this.sqlPart);
                stringBuilder.append(" IN (");
                for (int i = 0; i < this.params.length; ++i) {
                    if (i == 0) {
                        stringBuilder.append('?');
                        continue;
                    }
                    stringBuilder.append(",?");
                }
                stringBuilder.append(')');
                this.sqlPart = stringBuilder.toString();
            }
            this.isInGenned = true;
        }

        private TemptableType getTemptableType() {
            Object noneNullParam = null;
            for (Object param : this.params) {
                if (param == null) continue;
                noneNullParam = param;
                break;
            }
            if (noneNullParam instanceof String) {
                return TemptableType.BIG_STRING;
            }
            return TemptableType.PK_LONG;
        }

        void useTempTable(List<TemptableFacade> tempTableReleaseList) {
            TemptableFacade temptableFacade = TemptableFacades.create((TemptableType)this.getTemptableType());
            temptableFacade.insert(Arrays.asList(this.params));
            this.sqlPart = this.sqlPart + " IN (SELECT FID FROM " + temptableFacade.getName() + ")";
            tempTableReleaseList.add(temptableFacade);
            this.params = null;
        }

        boolean isToTemp() {
            if (HugeInConfig4DB.isEnableOpt()) {
                if (this.params == null || this.params.length == 0) {
                    throw new KDException(BosErrorCode.nullError, new Object[]{"in query params can not be null or empty." + SqlBuilder.this.getMockSQL()});
                }
                int length = this.params.length;
                int maxSize = HugeInConfig4DB.inMaxSize();
                if (length > maxSize) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{"in query params length over the maximum:" + length + ">" + maxSize});
                }
                Object param = this.params[0];
                return HugeInConfig4DB.isToTemp(this.params.length) && (param instanceof Long || param instanceof Integer || param instanceof String);
            }
            return false;
        }

        public String toString() {
            if (this.isIn && !this.isInGenned) {
                return this.mockSQL();
            }
            return this.sqlPart;
        }

        private String mockSQL() {
            if (this.isIn) {
                return this.sqlPart + " IN(?) ";
            }
            return this.sqlPart;
        }

        static /* synthetic */ Object[] access$202(Seg x0, Object[] x1) {
            x0.params = x1;
            return x1;
        }
    }
}

