/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.audit.sql.ForbidHardSQL;
import kd.bos.bundle.Resources;
import kd.bos.db.BaseDB;
import kd.bos.db.DBImpl;
import kd.bos.db.DBRoute;
import kd.bos.db.DefaultPreparedBatch;
import kd.bos.db.ExResultSetHandler;
import kd.bos.db.QueryMeta;
import kd.bos.db.QueryResource;
import kd.bos.db.QueryResult;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.RequestParallelExecuteContext;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SpaceAsEmptyString;
import kd.bos.db.extract.ExtractQuery;
import kd.bos.db.extract.ExtractQueryImpl;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.DelegateConnectionHolder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXImplicitObject;
import kd.bos.exception.KDExceptionKit;
import kd.bos.ksql.shell.timeout.context.ThreadRouteKeyContext;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.ParallelConnectionHolder;
import kd.bos.xdb.ParallelExecuteContext;
import kd.bos.xdb.QueryTimeout;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.eventbus.EventBus;
import kd.bos.xdb.eventbus.EventHandler;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.ext.ExtContextThreadCloser;
import kd.bos.xdb.ext.ExtXDB;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveCommittedEvent;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveCommittedEventHandler;
import kd.bos.xdb.sharding.strategy.cache.ShardingStrategyCacheCleaner;
import kd.bos.xdb.util.Threads;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

final class XDBImpl
extends BaseDB {
    private static final XDBImpl self = new XDBImpl();

    static XDBImpl getInstance() {
        return self;
    }

    private XDBImpl() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.dbLogTag = "xdb ";
        ShardingManager.get().setupXDB(5000);
        SpaceAsEmptyString.setupSpaceAsEmptyStringByConfig();
        XDBConfig xconfig = XDBConfig.get();
        ConfigurationUtil.observeInteger((String)"db.query.timeout", (int)300, v -> {
            this.queryTimeoutSeconds = v;
            xconfig.setQueryTimeoutSeconds(this.queryTimeoutSeconds);
        });
        new Thread(Threads.wrapRunnable(() -> {
            try {
                Thread.sleep(1000L);
                if (!Boolean.getBoolean("xdb.env.unittest") && Boolean.getBoolean("xdb.enable")) {
                    String channel = "sharding-data-move";
                    EventBus.subscribe((String)channel, ShardingDataMoveCommittedEvent.class, (EventHandler)new ShardingDataMoveCommittedEventHandler());
                    EventBus.startService((String[])new String[]{channel});
                    ShardingStrategyCacheCleaner.initEventBus();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("XDB-EventBus started error.AccountID=" + RequestContextInfo.get().getAccountId(), e);
            }
        })).start();
    }

    @Override
    int update(DBRoute dbRoute, String sql, Object[] params, TraceSpan ts) {
        return this.update(dbRoute, this.getConnection(dbRoute, sql, ts), true, sql, params);
    }

    @Override
    boolean execute(DBRoute dbRoute, String sql, Object[] params, TraceSpan ts) {
        int[] uc;
        List<Object[]> paramsList;
        if (params != null && params.length > 0) {
            paramsList = new ArrayList(1);
            paramsList.add(params);
        } else {
            paramsList = Collections.emptyList();
        }
        for (int c : uc = this.executeBatch(dbRoute, sql, paramsList, ts)) {
            if (c <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    int[] executeBatch(DBRoute dbRoute, String sql, List<Object[]> paramsList, TraceSpan ts) {
        return this.executeBatch(dbRoute, this.getConnection(dbRoute, sql, ts), true, sql, paramsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> QueryResult<T> queryImpl(DBRoute dbRoute, DelegateConnection con, boolean close, String sql, ResultSetHandler<T> rsh, boolean convertResultSet, Object ... params) {
        TXImplicitObject.ImplicitObject implicitObject = con.getCtx().getImplicitObject().handleImplicitTransaction(sql, con);
        boolean rollback = false;
        QueryResource resource = null;
        try {
            ExtContextThreadCloser rt;
            Object result;
            ResultSet rs;
            ExtContext ctx;
            block70: {
                if (rsh instanceof ExResultSetHandler) {
                    throw new UnsupportedOperationException(Resources.get((String)"bos-dbengine", (String)"XDBImpl_0", (String)"\u4e0d\u518d\u652f\u6301\u8be5\u63a5\u53e3: ", (Object[])new Object[0]) + ExResultSetHandler.class);
                }
                ctx = new ExtContext(dbRoute.getRouteKey(), (ParallelConnectionHolder)con, (ParallelExecuteContext)new RequestParallelExecuteContext());
                rs = null;
                result = null;
                long ts = System.currentTimeMillis();
                rt = ctx.setupThread(true);
                try {
                    block69: {
                        try (MetricsCollector mc = MetricsCollector.createCollector();){
                            TraceSpan tts;
                            if (sqlLogger != null) {
                                sqlLogger.logSQL(sql, new Object[0]);
                            }
                            if (Audit.isEnable()) {
                                this.audit(sql);
                            }
                            if (params == null || params.length == 0) {
                                rs = ExtXDB.query((ExtContext)ctx, (String)sql, (Object[])new Object[0]);
                                tts = Tracer.create((String)"DB", (String)"result_handle");
                                Throwable throwable = null;
                                try {
                                    if (convertResultSet) {
                                        rs = QueryMeta.createOrFixQueryMeta(null, rs, con.getDBConfig().getDBType()).convertResultSet(rs);
                                    }
                                    result = rsh.handle(rs);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (tts != null) {
                                        if (throwable != null) {
                                            try {
                                                tts.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                        } else {
                                            tts.close();
                                        }
                                    }
                                }
                                if (Audit.isEnable()) {
                                    ForbidHardSQL.audit((String)sql);
                                }
                                break block69;
                            }
                            rs = ExtXDB.query((ExtContext)ctx, (String)sql, (Object[])params);
                            tts = Tracer.create((String)"DB", (String)"result_handle");
                            Throwable throwable = null;
                            try {
                                if (convertResultSet) {
                                    rs = QueryMeta.createOrFixQueryMeta(null, rs, con.getDBConfig().getDBType()).convertResultSet(rs);
                                }
                                result = rsh.handle(rs);
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (tts != null) {
                                    if (throwable != null) {
                                        try {
                                            tts.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        tts.close();
                                    }
                                }
                            }
                        }
                    }
                    if (!this.enableOutSQL) break block70;
                }
                catch (Throwable e) {
                    try {
                        rollback = true;
                        this.close(rs);
                        try {
                            ctx.closeStatements();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw this.rethrow(con, e, sql, params);
                    }
                    catch (Throwable throwable) {
                        if (this.enableOutSQL) {
                            this.logSQLCost(dbRoute, con, sql, params, ts);
                        }
                        if (close || rollback && !TX.inTX()) {
                            if (implicitObject != null) {
                                implicitObject.release();
                            }
                            rt.close();
                            this.close(rs);
                            try {
                                ctx.closeStatements();
                            }
                            catch (Throwable throwable6) {
                            }
                            finally {
                                this.close(con, rollback);
                            }
                        } else {
                            ResultSet frs = rs;
                            resource = new QueryResource(con, sql, () -> {
                                if (implicitObject != null) {
                                    implicitObject.release();
                                }
                                rt.close();
                                this.close(frs);
                                ctx.closeStatements();
                            });
                        }
                        throw throwable;
                    }
                }
                this.logSQLCost(dbRoute, con, sql, params, ts);
            }
            if (close || rollback && !TX.inTX()) {
                if (implicitObject != null) {
                    implicitObject.release();
                }
                rt.close();
                this.close(rs);
                try {
                    ctx.closeStatements();
                }
                catch (Throwable mc) {
                }
                finally {
                    this.close(con, rollback);
                }
            } else {
                ResultSet frs = rs;
                resource = new QueryResource(con, sql, () -> {
                    if (implicitObject != null) {
                        implicitObject.release();
                    }
                    rt.close();
                    this.close(frs);
                    ctx.closeStatements();
                });
            }
            return new QueryResult<Object>(result, resource);
        }
        catch (Throwable e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    int update(DBRoute dbRoute, DelegateConnection conn, boolean closeConn, String sql, Object ... params) {
        try (ThreadRouteKeyContext context = ThreadRouteKeyContext.create((String)dbRoute.getRouteKey());){
            int rows;
            block30: {
                ExtContext ctx = new ExtContext(dbRoute.getRouteKey(), (ParallelConnectionHolder)conn, (ParallelExecuteContext)new RequestParallelExecuteContext());
                boolean rollback = false;
                rows = 0;
                long ts = System.currentTimeMillis();
                try {
                    if (sqlLogger != null) {
                        sqlLogger.logSQL(sql, params);
                    }
                    if (Audit.isEnable()) {
                        this.audit(sql);
                    }
                    if (params == null || params.length == 0) {
                        rows = ExtXDB.update((ExtContext)ctx, (String)sql, (Object[])new Object[0]);
                        if (Audit.isEnable()) {
                            ForbidHardSQL.audit((String)sql);
                        }
                        break block30;
                    }
                    rows = ExtXDB.update((ExtContext)ctx, (String)sql, (Object[])params);
                }
                catch (Throwable e) {
                    rollback = true;
                    throw this.rethrow(conn, e, sql, params);
                }
                finally {
                    if (this.enableOutSQL) {
                        this.logSQLCost(dbRoute, conn, sql, params, ts);
                    }
                    try {
                        ctx.closeStatements();
                    }
                    finally {
                        if (closeConn || rollback && !TX.inTX()) {
                            this.close(conn, rollback);
                        }
                    }
                }
            }
            int n = rows;
            return n;
        }
        catch (Throwable e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private int[] executeBatch(DBRoute dbRoute, DelegateConnection conn, boolean closeConn, String sql, List<Object[]> paramsList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    <T> T callWithExtContext(DBRoute dbRoute, boolean readOnly, Callable<T> callable) throws Exception {
        try (DelegateConnectionHolder conh = new DelegateConnectionHolder(() -> (DelegateConnection)TX.__getConnection(dbRoute.getRouteKey(), readOnly));){
            ExtContext ctx = new ExtContext(dbRoute.getRouteKey(), (ParallelConnectionHolder)conh, (ParallelExecuteContext)new RequestParallelExecuteContext());
            Object object = ExtXDB.call((ExtContext)ctx, callable);
            return (T)object;
        }
    }

    @Override
    public DefaultPreparedBatch prepareBatch(DBRoute dbRoute, String sql, TraceSpan ts, Auditable audit) {
        return DBImpl.getInstance().prepareBatch(dbRoute, sql, ts, audit);
    }

    @Override
    PreparedStatement preparedStatement(DBRoute dbRoute, String sql, TraceSpan ts, Auditable audit) {
        return DBImpl.getInstance().preparedStatement(dbRoute, sql, ts, audit);
    }

    @Override
    List<ExtractQuery> extractQuery(DBRoute dbRoute, String sql, Object[] params, TraceSpan ts) throws SQLException {
        try (DelegateConnectionHolder conh = new DelegateConnectionHolder(() -> this.getConnection(dbRoute, sql, ts));){
            ArrayList<ExtractQueryImpl> ret = new ArrayList<ExtractQueryImpl>(1);
            ExtContext ctx = new ExtContext(dbRoute.getRouteKey(), (ParallelConnectionHolder)conh, (ParallelExecuteContext)new RequestParallelExecuteContext());
            List sis = ExtXDB.extractSQLs((ExtContext)ctx, (String)sql, (Object[])params);
            for (SQLInfo si : sis) {
                ret.add(new ExtractQueryImpl(dbRoute, si.getSql(), si.getParams()));
            }
            ArrayList<ExtractQueryImpl> arrayList = ret;
            return arrayList;
        }
    }

    @Override
    QueryTimeout timeout(int seconds) {
        return ExtXDB.timeout((int)seconds);
    }

    private static /* synthetic */ int[] lambda$executeBatch$3(ExtContext ctx, String sql, List shardParamsList) throws SQLException {
        return ExtXDB.executeBatch((ExtContext)ctx, (String)sql, (List)shardParamsList);
    }
}

