/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.archive.IArchiveConfigProvider;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ArchiveIndexConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;
import kd.bos.db.archive.config.MainArchiveConfig;

public class ArchiveConfigProvider
implements IArchiveConfigProvider {
    private Map<String, ArchiveConfig> logicMap = new ConcurrentHashMap<String, ArchiveConfig>();
    private static final String table_arch_deli = "$";
    private Map<String, ArchiveIndexConfig> indexMap = new ConcurrentHashMap<String, ArchiveIndexConfig>();

    public ArchiveIndexConfig getIndex(String table) {
        ArchiveIndexConfig ret = this.indexMap.get(table = this.getOriTable(table));
        if (ret != null) {
            return ret;
        }
        return this.indexMap.computeIfAbsent(table, key -> new ArchiveIndexConfig((String)key));
    }

    private String getOriTable(String table) {
        int p = table.lastIndexOf(table_arch_deli);
        if (p != -1) {
            table = table.substring(0, p);
        }
        return table.toLowerCase();
    }

    @Override
    public ArchiveConfig getConfig(String logicTable) {
        return this.logicMap.get(logicTable.toLowerCase());
    }

    @Override
    public List<ArchiveConfig> getConfigs(String logicTable) {
        HashSet<ArchiveConfig> configSet = new HashSet<ArchiveConfig>(this.logicMap.values());
        ArchiveConfig ac = null;
        logicTable = logicTable.toLowerCase(Locale.ENGLISH);
        for (ArchiveConfig config : configSet) {
            if (!config.getLogicTable().equals(logicTable)) continue;
            ac = config;
            break;
        }
        ArrayList<ArchiveConfig> ret = new ArrayList<ArchiveConfig>(1);
        if (ac != null) {
            while (ac instanceof ChildrenArchiveConfig) {
                ac = ((ChildrenArchiveConfig)ac).getParent();
            }
            if (ac == null) {
                throw new IllegalArgumentException(logicTable + " do not found the main table archive config.");
            }
            ret.add(ac);
            for (String table : ((MainArchiveConfig)ac).getGroupTables()) {
                ArchiveConfig groupSC = this.logicMap.get(table);
                if (ac == groupSC) continue;
                ret.add(groupSC);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfig(ArchiveConfig ac) {
        Map<String, ArchiveConfig> map = this.logicMap;
        synchronized (map) {
            this.logicMap.put(ac.getLogicTable().toLowerCase(), ac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigs(ArchiveConfig ... acs) {
        Map<String, ArchiveConfig> map = this.logicMap;
        synchronized (map) {
            for (ArchiveConfig ac : acs) {
                this.logicMap.put(ac.getLogicTable().toLowerCase(), ac);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchiveConfig removeConfig(String logicTable) {
        Map<String, ArchiveConfig> map = this.logicMap;
        synchronized (map) {
            ArchiveConfig config = this.logicMap.remove(logicTable.toLowerCase());
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArchiveConfig> removeConfigs(String logicTable) {
        Map<String, ArchiveConfig> map = this.logicMap;
        synchronized (map) {
            List<ArchiveConfig> removed = this.getConfigs(logicTable);
            if (!removed.isEmpty()) {
                for (ArchiveConfig sc : removed) {
                    this.logicMap.remove(sc.getLogicTable());
                }
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceConfigs(ArchiveConfig ... acs) {
        Map<String, ArchiveConfig> map = this.logicMap;
        synchronized (map) {
            for (ArchiveConfig ac : acs) {
                this.logicMap.put(ac.getLogicTable(), ac);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearConfig() {
        Map<String, ArchiveConfig> map = this.logicMap;
        synchronized (map) {
            if (!this.logicMap.isEmpty()) {
                this.logicMap.clear();
            }
        }
    }

    @Override
    public ArchiveIndexConfig getIndexConfig(String table) {
        return this.getIndex(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexConfig(ArchiveIndexConfig aic) {
        Map<String, ArchiveIndexConfig> map = this.indexMap;
        synchronized (map) {
            this.indexMap.put(this.getOriTable(aic.getTable()), aic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexConfigs(ArchiveIndexConfig ... aics) {
        Map<String, ArchiveIndexConfig> map = this.indexMap;
        synchronized (map) {
            for (ArchiveIndexConfig aic : aics) {
                this.indexMap.put(this.getOriTable(aic.getTable()), aic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchiveIndexConfig removeIndexConfig(String table) {
        Map<String, ArchiveIndexConfig> map = this.indexMap;
        synchronized (map) {
            ArchiveIndexConfig config = this.indexMap.remove(this.getOriTable(table));
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearIndexConfig() {
        Map<String, ArchiveIndexConfig> map = this.indexMap;
        synchronized (map) {
            if (!this.indexMap.isEmpty()) {
                this.indexMap.clear();
            }
        }
    }

    @Override
    public boolean isIndexTbExists(String table) {
        return this.getIndex(table).isIndexTbExists();
    }

    @Override
    public void setIndexTbExists(String table, boolean indexTbExists) {
        this.getIndex(table).setIndexTbExists(indexTbExists);
    }

    @Override
    public String[] getIndexFields(String table) {
        return this.getIndex(table).getIndexFields();
    }

    @Override
    public void setIndexFields(String table, String[] indexFields) {
        this.getIndex(table).setIndexFields(indexFields);
    }
}

