/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive;

import kd.bos.util.StringUtils;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;

public class ArchiveName {
    public static final int index_length = 30;
    public static final int zero_suffix = 0;
    public static final int blank_suffix = -1;
    public static final String table_archi_tran_suffix = "$a";
    public static final String table_archi_mv_suffix = "$am";
    public static final String table_archi_index_suffix = "$ai";
    public static final String table_archi_map = "$amap";
    public static final String table_archi_pk = "$apk";
    public static final String table_archi_prefix = "archi_";
    public static final String table_archi_delim = "$";
    private String originalName;
    private final String name;

    public static ArchiveName of(String name) {
        name = SQLUtil.unWrapSQLTableName((String)name);
        return new ArchiveName(name);
    }

    private ArchiveName(String name) {
        this.name = name;
        int p = name.lastIndexOf(table_archi_delim);
        this.originalName = p != -1 ? name.substring(0, p) : name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getName() {
        return this.name;
    }

    private String getArchiveTranTable() {
        String tranTable = this.originalName + table_archi_tran_suffix;
        return tranTable;
    }

    public String getArchiveMapTable() {
        String mapTable = this.originalName + table_archi_map;
        return mapTable;
    }

    public String getArchivePkTable() {
        String pkTable = this.originalName + table_archi_pk;
        return pkTable;
    }

    public String getArchiveTranTable(long suffix) {
        if (suffix == 0L) {
            return this.getArchiveTranTable();
        }
        return this.getArchiveTranTable(table_archi_tran_suffix + String.valueOf(suffix));
    }

    public String getArchiveTranTable(String suffix) {
        String tranTable = this.originalName + suffix;
        return tranTable;
    }

    private String getArchivePkmTable() {
        String pkmTable = this.originalName + table_archi_mv_suffix;
        return pkmTable;
    }

    public String getArchivePkmTable(long suffix) {
        if (suffix == 0L) {
            return this.getArchivePkmTable();
        }
        return this.getArchivePkmTable(table_archi_mv_suffix + String.valueOf(suffix));
    }

    public String getArchivePkmTable(String suffix) {
        String pkmTable = this.originalName + suffix;
        return pkmTable;
    }

    public static String getArchiveIndexSuffix(long suffix) {
        return suffix == -1L ? "" : (suffix == 0L ? table_archi_index_suffix : table_archi_index_suffix + suffix);
    }

    public String getArchiveIndex(String suffix, String logicSuffix) {
        if (StringUtils.isEmpty((String)suffix) && StringUtils.isEmpty((String)logicSuffix)) {
            return this.originalName;
        }
        String newIndexName = this.originalName + logicSuffix + suffix;
        return newIndexName;
    }
}

