/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.ArchiveInfo;

public class LogicArchiveRoute {
    private static Map<String, Map<String, LogicArchiveRoute>> accountCache = new ConcurrentHashMap<String, Map<String, LogicArchiveRoute>>();
    public static final String logicPrefix = "$";
    private final String realArchiveKey;
    private final String logicSuffix;
    private final boolean isLogicArchiveRoute;
    private final boolean isCurrentArchive;

    public static LogicArchiveRoute of(String archiveKey) {
        Map<String, LogicArchiveRoute> logicArchiveRouteMap = accountCache.get(LogicArchiveRoute.getTenantAccountKey());
        if (logicArchiveRouteMap != null) {
            LogicArchiveRoute logicArchiveRoute = logicArchiveRouteMap.get(archiveKey);
            if (logicArchiveRoute != null) {
                return logicArchiveRoute;
            }
            return logicArchiveRouteMap.computeIfAbsent(archiveKey, k -> new LogicArchiveRoute((String)k));
        }
        logicArchiveRouteMap = new ConcurrentHashMap<String, LogicArchiveRoute>();
        accountCache.put(LogicArchiveRoute.getTenantAccountKey(), logicArchiveRouteMap);
        return logicArchiveRouteMap.computeIfAbsent(archiveKey, k -> new LogicArchiveRoute((String)k));
    }

    private LogicArchiveRoute(String archiveKey) {
        int indexLg = archiveKey.indexOf(logicPrefix);
        if (indexLg != -1) {
            this.realArchiveKey = archiveKey.substring(0, indexLg);
            this.logicSuffix = archiveKey.substring(indexLg);
            this.isLogicArchiveRoute = true;
        } else {
            this.realArchiveKey = archiveKey;
            this.logicSuffix = "";
            this.isLogicArchiveRoute = false;
        }
        this.isCurrentArchive = this.realArchiveKey.equals("cur_database");
    }

    public String getRealArchiveKey() {
        return this.realArchiveKey;
    }

    public String getLogicSuffix() {
        return this.logicSuffix;
    }

    public boolean isLogicArchiveRoute() {
        return this.isLogicArchiveRoute;
    }

    public boolean isCurrentArchive() {
        return this.isCurrentArchive;
    }

    public ArchiveInfo getLogic2ArchiveInfo(ArchiveInfo realArchiveInfo) {
        return new ArchiveInfo(realArchiveInfo.getKey() + this.logicSuffix, realArchiveInfo.getName() + this.logicSuffix, realArchiveInfo.getDesc() + this.logicSuffix);
    }

    private static String getTenantAccountKey() {
        RequestContextInfo rc = RequestContextInfo.get();
        return rc.getTenantId() + '#' + rc.getAccountId();
    }

    public String toString() {
        return "LogicArchiveRoute{realArchiveKey='" + this.realArchiveKey + '\'' + ", logicSuffix='" + this.logicSuffix + '\'' + ", isLogicArchiveRoute=" + this.isLogicArchiveRoute + ", isCurrentArchive=" + this.isCurrentArchive + '}';
    }
}

