/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive.configchanged;

import kd.bos.db.archive.configchanged.DBArchiveConfigInfo;
import kd.bos.db.archive.configchanged.DBArchiveConfigListener;
import kd.bos.db.archive.configchanged.DBArchiveIndexConfigListener;
import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class DBArchiveIndexConfigNotifier
extends ZKWatchValueNotifier {
    private static final String ARCHIVE_INDEX_CONFIG_WATCHER = "archive.index.config.watcher";
    private static final String FIRE_RELOAD_ARCHIVE_INDEX_CONFIG_LOCK_KEY = "/archive/fire_reload_index_config";

    public static void registerReloadArchiveIndexConfigListener(final DBArchiveIndexConfigListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    DBArchiveConfigInfo ai = DBArchiveConfigListener.fromKey((String)newValue);
                    l.onReceiveReloadArchiveIndexConfig(ai);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        DBArchiveIndexConfigNotifier.observeChange(ARCHIVE_INDEX_CONFIG_WATCHER, listener);
    }

    public static void fireReloadArchiveIndexConfig(String entityName) {
        String value = DBArchiveConfigListener.currentKey(entityName);
        log.info("fireReloadArchiveIndexConfig " + entityName + " " + value);
        DBArchiveIndexConfigNotifier.fireLimit(FIRE_RELOAD_ARCHIVE_INDEX_CONFIG_LOCK_KEY, ARCHIVE_INDEX_CONFIG_WATCHER, value);
    }
}

