/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.blinking;

import java.util.EnumMap;
import java.util.Map;
import kd.bos.db.blinking.BlinkingAWait;
import kd.bos.db.blinking.BlinkingAWaitNone;
import kd.bos.db.blinking.BlinkingAWaitTablesSync;
import kd.bos.db.blinking.BlinkingUtil;

public class BlinkingAWaitFactory {
    private static Map<WaitType, BlinkingAWait> waitMap = new EnumMap<WaitType, BlinkingAWait>(WaitType.class);

    public static BlinkingAWait getBlinkingAWaitor() {
        String url = BlinkingUtil.getBlinkingRedisUrl();
        if (!BlinkingUtil.isBlinkingEnable() || url == null || url.length() == 0) {
            return BlinkingAWaitFactory.getBlinkingAWaitor(WaitType.NONE);
        }
        if (!BlinkingUtil.isBlinkingLive()) {
            return BlinkingAWaitFactory.getBlinkingAWaitor(WaitType.NONE);
        }
        return BlinkingAWaitFactory.getBlinkingAWaitor(WaitType.TABLESYNC);
    }

    private static BlinkingAWait getBlinkingAWaitor(WaitType type) {
        return waitMap.get((Object)type);
    }

    static {
        waitMap.put(WaitType.NONE, new BlinkingAWaitNone());
        waitMap.put(WaitType.TABLESYNC, new BlinkingAWaitTablesSync());
    }

    public static enum WaitType {
        NONE,
        TABLESYNC;

    }
}

