/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.blinking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.blinking.BlinkingAWait;
import kd.bos.db.blinking.BlinkingTableInfo;
import kd.bos.db.blinking.BlinkingUtil;
import kd.bos.db.datasource.DBConfig;
import kd.bos.redis.JedisClient;

public class BlinkingAWaitTablesSync
implements BlinkingAWait {
    private static String blingkingTablePositionKey = "blinking-table-position";

    @Override
    public Set<BlinkingTableInfo> syncInfo(DBConfig conf, Set<String> tables) {
        String table;
        String[] tableArr;
        String queryRouteKey = conf.getRouteKey();
        tables = tables.stream().map(String::toLowerCase).collect(Collectors.toSet());
        HashSet<BlinkingTableInfo> rv = new HashSet<BlinkingTableInfo>(4);
        HashMap<String, BlinkingTableInfo> tempMap = new HashMap<String, BlinkingTableInfo>(4);
        for (String tableName : tables) {
            BlinkingTableInfo bti = new BlinkingTableInfo();
            bti.setTableName(tableName);
            bti.setLast(false);
            bti.setSync(false);
            rv.add(bti);
            tempMap.put(tableName, bti);
        }
        int syncTimeout = BlinkingUtil.getSyncTimeOut();
        long beginTS = System.currentTimeMillis();
        String bizDbKey = BlinkingUtil.getBizDbKey(conf.getTenantId(), queryRouteKey, conf.getAccountId());
        if (null == bizDbKey || bizDbKey.length() == 0) {
            return rv;
        }
        Set<String> syncTableSet = BlinkingUtil.syncTableSet(conf.getTenantId(), queryRouteKey, conf.getAccountId());
        if (syncTableSet != null && syncTableSet.size() > 2) {
            tables.retainAll(syncTableSet);
        }
        for (String s : tables) {
            ((BlinkingTableInfo)tempMap.get(s)).setSync(true);
        }
        ArrayList<String> keys = new ArrayList<String>(4);
        for (String table2 : tableArr = tables.toArray(new String[0])) {
            keys.add("o-" + table2);
            keys.add("s-" + bizDbKey + "-" + table2);
        }
        List<String> positions = this.getPositions(blingkingTablePositionKey, keys.toArray(new String[0]));
        HashMap<String, String> occtorPostMap = new HashMap<String, String>();
        ArrayList<String> keysRepeatQuery = new ArrayList<String>();
        ArrayList<String> keysRepeatTableName = new ArrayList<String>();
        int j = 0;
        for (int i = 0; i < tableArr.length; ++i) {
            String occtorPos = positions.get(j++);
            String syncPos = positions.get(j++);
            if (this.isNull(occtorPos)) {
                ((BlinkingTableInfo)tempMap.get(tableArr[i])).setLast(true);
                continue;
            }
            table = tableArr[i];
            if (this.isNull(syncPos) || occtorPos.compareTo(syncPos) < 0) {
                occtorPostMap.put("s-" + bizDbKey + "-" + table, occtorPos);
                keysRepeatQuery.add("s-" + bizDbKey + "-" + table);
                keysRepeatTableName.add(table);
                continue;
            }
            ((BlinkingTableInfo)tempMap.get(tableArr[i])).setLast(true);
        }
        while (!keysRepeatQuery.isEmpty()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if (System.currentTimeMillis() - beginTS > (long)(syncTimeout * 1000)) {
                return rv;
            }
            String[] repeatQueryArr = keysRepeatQuery.toArray(new String[0]);
            String[] repeatTableNameArr = keysRepeatTableName.toArray(new String[0]);
            keysRepeatQuery.clear();
            keysRepeatTableName.clear();
            List<String> positionsRe = this.getPositions(blingkingTablePositionKey, repeatQueryArr);
            for (int i = 0; i < repeatQueryArr.length; ++i) {
                table = repeatQueryArr[i];
                String pos = positionsRe.get(i);
                if (this.isNull(pos) || ((String)occtorPostMap.get(table)).compareTo(pos) < 0) {
                    keysRepeatQuery.add(table);
                    keysRepeatTableName.add(repeatTableNameArr[i]);
                    continue;
                }
                ((BlinkingTableInfo)tempMap.get(repeatTableNameArr[i])).setLast(true);
            }
        }
        return rv;
    }

    private List<String> getPositions(String blingkingTablePositionKey, String[] repeatQueryArr) {
        try (JedisClient jedis = BlinkingUtil.getJedis();){
            List list = jedis.hmget(blingkingTablePositionKey, repeatQueryArr);
            return list;
        }
    }

    private boolean isNull(String value) {
        boolean retV = false;
        if (value == null || value.length() == 0 || value.equalsIgnoreCase("nil")) {
            retV = true;
        }
        return retV;
    }
}

