/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.blinking;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class BlinkingUtil {
    private static final Log log;
    public static final String BLINKING_SYNC_WAIT_TIMEOUT_KEY = "bos.blinking.wait_sync_timeout";
    public static final String BLINKING_REDIS_KEY = "bos.blinking.redis.url";
    public static final String BLINKING_ENABLE = "bos.blinking.enable";
    public static final String BLINKING_BIZ_DB_KEY = "bos.blinking.biz.db.key";
    public static final String BLINKING_BASEDATA_DB_KEY = "bos.blinking.basedata.db.key";
    private static boolean blinkingEnable;
    private static boolean blinkingLive;
    private static Map<String, Set<String>> tableSyncMap;

    public static int getSyncTimeOut() {
        return Integer.getInteger(BLINKING_SYNC_WAIT_TIMEOUT_KEY);
    }

    public static String getBizDbKey(String tenantId, String routeKey, String accountId) {
        String rv = System.getProperty("bos.blinking.biz.db.key_" + tenantId + "_" + routeKey + "_" + accountId);
        return rv;
    }

    public static String getBlinkingRedisUrl() {
        return System.getProperty(BLINKING_REDIS_KEY);
    }

    private static String getMasterKey() {
        return System.getProperty(BLINKING_BASEDATA_DB_KEY);
    }

    public static boolean isBlinkingLive() {
        return blinkingLive;
    }

    private static void setKddriverPropertiesOfBlink() {
        try (JedisClient jedis = BlinkingUtil.getJedis();){
            Map m = jedis.hgetAll("kddirverproperties");
            if (m != null && m.size() > 0) {
                System.getProperties().putAll((Map<?, ?>)m);
            }
        }
        catch (Exception e) {
            blinkingLive = false;
        }
    }

    private static void setBlinkingLive() {
        if (!blinkingLive) {
            return;
        }
        try (JedisClient jedis = BlinkingUtil.getJedis();){
            blinkingLive = jedis.exists(BlinkingUtil.getMasterKey() + ".active");
        }
        catch (Exception e) {
            blinkingLive = false;
        }
    }

    public static void release(JedisClient jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public static Set<String> syncTableSet(String tenantId, String routeKey, String accountId) {
        String getBizDbKey = BlinkingUtil.getBizDbKey(tenantId, routeKey, accountId);
        if (!tableSyncMap.containsKey(getBizDbKey)) {
            try (JedisClient jedis = BlinkingUtil.getJedis();){
                tableSyncMap.put(getBizDbKey, jedis.smembers(getBizDbKey + "-syncTables"));
            }
        }
        return tableSyncMap.get(getBizDbKey);
    }

    public static JedisClient getJedis() {
        try (TraceSpan span = Tracer.create((String)"BlinkingRedis", (String)"getJedis");){
            JedisClient jedisClient = RedisFactory.getJedisClient((String)BlinkingUtil.getBlinkingRedisUrl());
            return jedisClient;
        }
    }

    public static boolean isBlinkingEnable() {
        return blinkingEnable;
    }

    private static void setBlinkingEnable(boolean blinkingEnable) {
        BlinkingUtil.blinkingEnable = blinkingEnable;
    }

    static {
        String url;
        log = LogFactory.getLog((String)"DB");
        blinkingEnable = false;
        blinkingLive = false;
        tableSyncMap = new HashMap<String, Set<String>>();
        boolean enable = Boolean.getBoolean(BLINKING_ENABLE);
        if (enable && ((url = BlinkingUtil.getBlinkingRedisUrl()) == null || url.trim().length() == 0)) {
            enable = false;
            log.info("Blinking bos.blinking.redis.url is empty, blinking will disabled.");
        }
        if (enable) {
            log.info("Blinking enabled.");
            BlinkingUtil.setBlinkingEnable(true);
            BlinkingUtil.setBlinkingLive();
            BlinkingUtil.setKddriverPropertiesOfBlink();
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    BlinkingUtil.setBlinkingLive();
                }
            }, 10000L, 2000L);
        } else {
            log.info("Blinking disabled.");
            blinkingLive = false;
            BlinkingUtil.setBlinkingEnable(false);
        }
    }
}

