/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.HashMap;
import java.util.List;
import kd.bos.db.datasource.ConfiguredDataSource;
import kd.bos.db.datasource.ConfiguredDataSourceParser;
import kd.bos.db.datasource.ConfiguredDataSourceParserBuilder;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ConfiguredDataSourceImpl
implements ConfiguredDataSource {
    private static final String configKey = "db.datasource.customFromConfig";
    private static final Log log = LogFactory.getLog(ConfiguredDataSourceImpl.class);
    private HashMap<String, Account> accountMap = new HashMap();

    protected ConfiguredDataSourceImpl() {
        String config = System.getProperty(configKey);
        this.initAccountMap(config);
    }

    private void initAccountMap(String text) {
        if (text != null) {
            ConfiguredDataSourceParserBuilder builder = new ConfiguredDataSourceParserBuilder();
            builder.setText(text);
            try {
                ConfiguredDataSourceParser parser = builder.build();
                List<Account> accounts = parser.parse();
                HashMap<String, Account> map = new HashMap<String, Account>();
                for (Account account : accounts) {
                    String key = account.getTenantId() + '#' + account.getAccountId();
                    map.put(key, account);
                }
                this.accountMap = map;
            }
            catch (Exception exception) {
                log.error("custom datasource config error: " + exception.getMessage(), (Throwable)exception);
                this.accountMap.clear();
            }
        }
    }

    @Override
    public Account getExtendAccount(String tenantId, String accountId) {
        String key = tenantId + '#' + accountId;
        return this.accountMap.get(key);
    }

    @Override
    public boolean hasConfiguredDataSource() {
        return !this.accountMap.isEmpty();
    }
}

