/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.db.DBType;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.blinking.BlinkingAWait;
import kd.bos.db.blinking.BlinkingAWaitFactory;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.DataSourceManager;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.db.datasource.InitCustomDataSource;
import kd.bos.db.extension.DBExtensionsRegister;
import kd.bos.db.tx.TX;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.ksql.CONSTANT;
import kd.bos.metric.MetricSystem;
import kd.bos.security.PermissionManager;

public final class DataSourceFactory {
    public static final String datasource_trace_name = "datasource";
    public static final String datasource_audit_name = "datasource";
    public static final String datasource_type = "datasource.type";
    public static final String datasource_mariadb = "datasource.mariadb";
    public static final String DATA_SOURCE_MYSQL = "datasource.mysql";
    public static final String datasource_metric_connection_threadstack = "datasource.metric.connection.threadstack";
    public static final String datasource_config = "datasource.config";
    private static DataSourceManager dsm = new DataSourceManager();

    public static void registDataSourceIfNotExists(String routeKey, DBType dbType, String ip, int port, String db, String user, String pwd, Properties props) {
        PermissionManager.check();
        RequestContextInfo rci = RequestContextInfo.get();
        DataSourceFactory.registDataSourceIfNotExists(rci.getTenantId(), rci.getAccountId(), routeKey, dbType, ip, port, db, user, pwd, props);
    }

    public static void registDataSourceIfNotExists(String tenantId, String accountId, String routeKey, DBType dbType, String ip, int port, String db, String user, String pwd, Properties dataSourceProperties) {
        PermissionManager.check();
        dsm.registDataSourceIfNotExists(tenantId, accountId, routeKey, dbType, ip, port, db, user, pwd, dataSourceProperties);
    }

    public static DataSourceInfo getDataSource(String tenantId, String routeKey, String accountId, boolean readOnly) {
        PermissionManager.check();
        return dsm.getGroup(tenantId, routeKey, accountId).serve(readOnly);
    }

    public static boolean isReadOnlyDBAvailable(String tenantId, String routeKey, String accountId) {
        PermissionManager.check();
        return dsm.getGroup(tenantId, routeKey, accountId).isReadOnlyDBAvailable();
    }

    public static String getSharedRouteKey(String tenantId, String routeKey, String accountId) {
        PermissionManager.check();
        return dsm.getSharedRouteKey(tenantId, routeKey, accountId);
    }

    public static void destoryDataSource(String tenantId, String routeKey, String accountId) {
        dsm.destoryGroup(tenantId, routeKey, accountId);
    }

    public static List<DBConfig> getReadOnlyDBConfigs(String tenantId, String routeKey, String accountId) {
        PermissionManager.check();
        return dsm.getGroup(tenantId, routeKey, accountId).getReadOnlyDBConfigs();
    }

    public static DBConfig getDBConfig(String tenantId, String routeKey, String accountId) {
        PermissionManager.check();
        return dsm.getGroup(tenantId, routeKey, accountId).serve(false).getDBConfig();
    }

    public static Set<DBConfig> getDBConfigs(String tenantId, String routeKey, String accountId, String ... useTables) {
        PermissionManager.check();
        HashSet<DBConfig> set = new HashSet<DBConfig>(3);
        if (CONSTANT.CONNECTION_SHARD) {
            List<DBConfig> dbConfigs = DBExtensionsRegister.getDBConfigs(tenantId, routeKey, accountId, false);
            for (DBConfig dBConfig : dbConfigs) {
                if (dBConfig.getDBType() != DBType.MySQL && dBConfig.getDBType() != DBType.PostgreSQL && dBConfig.getDBType() != DBType.TDSQL && dBConfig.getDBType() != DBType.TiDB && dBConfig.getDBType() != DBType.GaussDB) {
                    set.clear();
                    set.add(DataSourceFactory.getDBConfig(tenantId, routeKey, accountId));
                    break;
                }
                if (dBConfig.isReadOnly()) continue;
                set.add(dBConfig);
            }
        } else {
            set.add(DataSourceFactory.getDBConfig(tenantId, routeKey, accountId));
        }
        if (TX.__canQueryOnReadOnlyDB(tenantId, routeKey, accountId, useTables)) {
            List<DBConfig> readOnlyDbConfigs = DataSourceFactory.getReadOnlyDBConfigs(tenantId, routeKey, accountId);
            if (CONSTANT.CONNECTION_SHARD) {
                readOnlyDbConfigs.clear();
                List<DBConfig> dbConfigs = DBExtensionsRegister.getDBConfigs(tenantId, routeKey, accountId, false);
                for (DBConfig dbConfig : dbConfigs) {
                    if (dbConfig.getDBType() != DBType.MySQL && dbConfig.getDBType() != DBType.PostgreSQL && dbConfig.getDBType() != DBType.TDSQL && dbConfig.getDBType() != DBType.TiDB) {
                        readOnlyDbConfigs = DataSourceFactory.getReadOnlyDBConfigs(tenantId, routeKey, accountId);
                        break;
                    }
                    if (!dbConfig.isReadOnly()) continue;
                    readOnlyDbConfigs.add(dbConfig);
                }
            }
            if (!readOnlyDbConfigs.isEmpty()) {
                HashSet<String> tableSet = new HashSet<String>(useTables.length);
                for (String table : useTables) {
                    tableSet.add(table);
                }
                BlinkingAWait blinkingAWait = BlinkingAWaitFactory.getBlinkingAWaitor();
                for (DBConfig conf : readOnlyDbConfigs) {
                    if (!blinkingAWait.isLastAt(conf, tableSet)) continue;
                    set.add(conf);
                }
            }
        }
        return set;
    }

    public static DataSourceInfo getSplittingReadDataSourceInfo(Set<DBConfig> dbConfigSet) {
        PermissionManager.check();
        return dsm.getSplittingReadDataSourceInfo(dbConfigSet);
    }

    public static String dumpStatus(boolean withDetail) {
        PermissionManager.check();
        return dsm.dumpStatus(withDetail);
    }

    public static Map<String, Object> dumpStatusMap(boolean withDetail) {
        PermissionManager.check();
        return dsm.dumpStatusMap(withDetail);
    }

    public static Map<String, Map<String, Object>> dumpDetailStatus() {
        PermissionManager.check();
        return dsm.dumpDetailStatus();
    }

    static DataSourceManager getDataSourceManager() {
        return dsm;
    }

    public static List<String[]> getAllDBInstanceDataSource() {
        PermissionManager.check();
        HashSet<String> instanceContain = new HashSet<String>();
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Account account : AccountUtils.getAllAccountsOfCurrentEnv()) {
            for (DBInstance dbInstance : account.getDBInstanceList()) {
                if (instanceContain.contains(dbInstance.getDbip() + ':' + dbInstance.getDbport())) continue;
                instanceContain.add(dbInstance.getDbip() + ':' + dbInstance.getDbport());
                DBType dbType = null;
                switch (dbInstance.getDbtype().trim()) {
                    case "0": {
                        if (Integer.parseInt(dbInstance.getDbport()) == 5236 && Boolean.getBoolean("oracle_5236_as_dm")) {
                            dbType = DBType.DM;
                            break;
                        }
                        dbType = DBType.Oracle;
                        break;
                    }
                    case "2": {
                        dbType = DBType.MySQL;
                        break;
                    }
                    case "17": {
                        dbType = DBType.TDSQL;
                        break;
                    }
                    case "19": {
                        dbType = DBType.TiDB;
                        break;
                    }
                    case "1": {
                        if (Boolean.getBoolean("pg_as_gs")) {
                            dbType = DBType.GS;
                            break;
                        }
                        if (Boolean.getBoolean("pg_as_gs100")) {
                            dbType = DBType.GS100;
                            break;
                        }
                        dbType = DBType.PostgreSQL;
                        break;
                    }
                    case "3": {
                        dbType = DBType.DM;
                        break;
                    }
                    case "4": {
                        dbType = Boolean.getBoolean("pg_as_gs100") ? DBType.GS100 : (Boolean.getBoolean("pg_as_gs") ? DBType.GS : DBType.PostgreSQL);
                        if (!Boolean.getBoolean("pg_as_gs100")) break;
                        dbType = DBType.GS100;
                        break;
                    }
                    case "5": {
                        dbType = DBType.GS100;
                        if (!Boolean.getBoolean("pg_as_gs")) break;
                        dbType = DBType.GS;
                        break;
                    }
                    case "6": {
                        dbType = DBType.SQLServer;
                        break;
                    }
                    case "14": {
                        dbType = DBType.GaussDB;
                        break;
                    }
                    case "15": {
                        dbType = DBType.KingBase;
                        break;
                    }
                    case "16": {
                        dbType = DBType.Vastbase;
                        break;
                    }
                    case "18": {
                        dbType = DBType.Gbase;
                        break;
                    }
                    case "20": {
                        dbType = DBType.YasDB;
                        break;
                    }
                    case "21": {
                        dbType = DBType.OceanBase_Oracle;
                        break;
                    }
                    case "101": {
                        dbType = DBType.HANA;
                        break;
                    }
                    case "103": {
                        dbType = DBType.Gauss200;
                        break;
                    }
                    case "104": {
                        dbType = DBType.Greenplum;
                    }
                }
                if (dbType == null) {
                    throw new UnsupportedOperationException("Parse dbType fail,unknown dbType : " + dbInstance.getDbtype());
                }
                String url = dbInstance.isCluster() ? DataSourceURLs.genClusterUrl(dbType, dbInstance.getClusterDbUrl(), dbInstance.getDBInsatnce()) : DataSourceURLs.genURL(dbType, dbInstance.getDbip(), Integer.parseInt(dbInstance.getDbport()), dbInstance.getDBInsatnce());
                result.add(new String[]{url, dbInstance.getDbuser(), dbInstance.getDbpassword(), account.getTenantId(), account.getAccountId(), dbInstance.getRouteKey()});
            }
        }
        return result;
    }

    static {
        try {
            MetricSystem.registerGauge((String)"kd.metrics.datasource.ActiveConnectionCount", () -> dsm.statTotalPoolStatus().getActive());
            MetricSystem.registerGauge((String)"kd.metrics.datasource.MaxConnectionTotal", () -> dsm.statTotalPoolStatus().getMaxTotal());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        InitCustomDataSource.init();
    }
}

